/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.application.internal.library.RegistryKey;
import weblogic.application.internal.library.util.AbstractTraversal;
import weblogic.application.internal.library.util.RONode;
import weblogic.application.internal.library.util.Traversal;
import weblogic.application.library.LibraryDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryLookup
extends AbstractTraversal<RegistryKey, LibraryDefinition>
implements Traversal<RegistryKey, LibraryDefinition> {
    private final RegistryKey[] edges;
    private final boolean exactMatch;
    private int edgeIndex = -1;
    private RONode<RegistryKey, LibraryDefinition> matchNode = null;

    public LibraryLookup(RegistryKey[] registryKeyArray, boolean bl) {
        this.edges = registryKeyArray;
        this.exactMatch = bl;
    }

    @Override
    public RegistryKey getNextEdge(RONode<RegistryKey, LibraryDefinition> rONode) {
        ++this.edgeIndex;
        if (this.edgeIndex == this.edges.length || !rONode.hasChildren()) {
            return null;
        }
        RegistryKey registryKey = this.edges[this.edgeIndex];
        if (rONode.getDepth() == 2) {
            registryKey = this.getSpecVersionEdge(rONode, registryKey);
        } else if (rONode.getDepth() == 3) {
            registryKey = this.getImplVersionEdge(rONode, registryKey);
        }
        if (registryKey != null && rONode.hasEdge(registryKey)) {
            return registryKey;
        }
        return null;
    }

    private RegistryKey getSpecVersionEdge(RONode<RegistryKey, LibraryDefinition> rONode, RegistryKey registryKey) {
        if (this.exactMatch && registryKey != null) {
            return registryKey;
        }
        return this.getHighestVersion(rONode, registryKey);
    }

    private RegistryKey getHighestVersion(RONode<RegistryKey, LibraryDefinition> rONode, RegistryKey registryKey) {
        RegistryKey registryKey2 = rONode.getHighestEdge();
        if (registryKey == null) {
            return registryKey2;
        }
        if (registryKey2.compareTo(registryKey) >= 0) {
            return registryKey2;
        }
        return registryKey;
    }

    private RegistryKey getImplVersionEdge(RONode<RegistryKey, LibraryDefinition> rONode, RegistryKey registryKey) {
        if (this.exactMatch && registryKey != null) {
            return registryKey;
        }
        boolean bl = this.areComparable(rONode.getEdges());
        if (registryKey == null) {
            if (bl) {
                return this.getHighestVersion(rONode, null);
            }
            if (rONode.getNumChildren() == 1) {
                return rONode.getEdges().iterator().next();
            }
        }
        if (registryKey != null && this.isComparable(registryKey) && bl) {
            return this.getHighestVersion(rONode, registryKey);
        }
        return registryKey;
    }

    private boolean isComparable(RegistryKey registryKey) {
        return registryKey.isComparable();
    }

    private boolean areComparable(Set<RegistryKey> set) {
        Iterator<RegistryKey> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isComparable()) continue;
            return false;
        }
        return true;
    }

    public boolean match() {
        return this.getMatch() != null;
    }

    public LibraryDefinition getMatch() {
        if (this.matchNode == null) {
            return null;
        }
        return this.matchNode.getValue();
    }

    @Override
    public void visitLeaf(RONode<RegistryKey, LibraryDefinition> rONode, List<RegistryKey> list) {
        if (this.edgeIndex == this.edges.length - 1 || this.remainingEdgesAreNull()) {
            this.matchNode = rONode;
        }
    }

    private boolean remainingEdgesAreNull() {
        for (int i = this.edgeIndex + 1; i < this.edges.length; ++i) {
            if (this.edges[i] == null) continue;
            return false;
        }
        return true;
    }
}

