/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import weblogic.application.internal.library.LibraryRegistry;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryProvider;
import weblogic.application.utils.XMLWriter;

public class LibraryManagerAggregate {
    private static final LibraryRegistry libReg = LibraryRegistry.getRegistry();
    private final Collection<LibraryManager> libraryManagers = new HashSet<LibraryManager>();
    private final Map<String, LibraryManager> moduleMapping = new HashMap<String, LibraryManager>();
    private LibraryManager appLevelLibraryManager = null;
    private LibraryManager optionalPackagesManager = null;

    public void setAppLevelLibraryManager(LibraryManager libraryManager) {
        this.appLevelLibraryManager = libraryManager;
        this.addLibraryManager(libraryManager);
    }

    public void setOptionalPackagesManager(LibraryManager libraryManager) {
        this.optionalPackagesManager = libraryManager;
        this.addLibraryManager(libraryManager);
    }

    public LibraryManager getOptionalPackagesManager() {
        return this.optionalPackagesManager;
    }

    public void addLibraryManager(String string, LibraryManager libraryManager) {
        this.addLibraryManager(libraryManager);
        this.moduleMapping.put(string, libraryManager);
    }

    public void removeLibraryManager(String string, LibraryManager libraryManager) {
        this.libraryManagers.remove(libraryManager);
        this.moduleMapping.remove(string);
    }

    public LibraryProvider getLibraryProvider(String string) {
        if (string == null) {
            return this.appLevelLibraryManager;
        }
        return this.moduleMapping.get(string);
    }

    public void addLibraryManager(LibraryManager libraryManager) {
        this.libraryManagers.add(libraryManager);
    }

    public boolean hasUnresolvedRefs() {
        for (LibraryManager libraryManager : this.libraryManagers) {
            if (!libraryManager.hasUnresolvedReferences()) continue;
            return true;
        }
        return false;
    }

    public Library[] getUnreferencedLibraries() {
        Collection<LibraryDefinition> collection = libReg.getAll();
        for (LibraryManager libraryManager : this.libraryManagers) {
            Library[] libraryArray = libraryManager.getReferencedLibraries();
            for (int i = 0; i < libraryArray.length; ++i) {
                collection.remove(libraryArray[i]);
            }
        }
        return collection.toArray(new Library[collection.size()]);
    }

    public String getUnresolvedRefsError() {
        StringBuffer stringBuffer = new StringBuffer();
        for (LibraryManager libraryManager : this.libraryManagers) {
            if (!libraryManager.hasUnresolvedReferences()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            libraryManager.getUnresolvedReferencesError(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        for (LibraryManager libraryManager : this.libraryManagers) {
            libraryManager.writeDiagnosticImage(xMLWriter);
        }
    }
}

