/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.util.Collection;
import java.util.HashSet;
import weblogic.application.Type;
import weblogic.application.internal.library.LibraryLookup;
import weblogic.application.internal.library.LibraryRegistrationException;
import weblogic.application.internal.library.RegistryKey;
import weblogic.application.internal.library.util.NodeModificationException;
import weblogic.application.internal.library.util.SortedNodeTree;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryRegistry {
    private static final LibraryRegistry registry = new LibraryRegistry();
    private final SortedNodeTree<RegistryKey, LibraryDefinition> libTree = new SortedNodeTree();

    private LibraryRegistry() {
    }

    public static LibraryRegistry getRegistry() {
        return registry;
    }

    public synchronized void register(LibraryDefinition libraryDefinition) throws LibraryRegistrationException {
        this.validate(libraryDefinition);
        RegistryKey[] registryKeyArray = RegistryKey.newInstance(libraryDefinition);
        if (this.libTree.hasElement((RegistryKey[])registryKeyArray)) {
            throw new LibraryRegistrationException("Cannot register the same Library twice - this Library has already been registered: " + libraryDefinition.toString());
        }
        try {
            this.libTree.put((RegistryKey[])registryKeyArray, libraryDefinition);
        }
        catch (NodeModificationException nodeModificationException) {
            this.handleNodeModificationException(libraryDefinition, nodeModificationException);
        }
    }

    private void validate(LibraryDefinition libraryDefinition) throws LibraryRegistrationException {
        if (libraryDefinition.getName() == null) {
            throw new LibraryRegistrationException(LibraryConstants.NAME_MUST_BE_SET_ERROR);
        }
        if (libraryDefinition.getImplementationVersion() != null && libraryDefinition.getSpecificationVersion() == null) {
            throw new LibraryRegistrationException(LibraryConstants.NO_IMPL_WITHOUT_SPEC_ERROR);
        }
    }

    public LibraryDefinition lookup(LibraryReference libraryReference) {
        return this.lookup(RegistryKey.newInstance(libraryReference), libraryReference.getExactMatch(), libraryReference.getType());
    }

    private synchronized LibraryDefinition lookup(RegistryKey[] registryKeyArray, boolean bl, Type type) {
        LibraryLookup libraryLookup = new LibraryLookup(registryKeyArray, bl);
        this.libTree.traverse(libraryLookup);
        LibraryDefinition libraryDefinition = libraryLookup.getMatch();
        if (libraryDefinition != null && type != null && type != libraryDefinition.getType()) {
            return null;
        }
        return libraryDefinition;
    }

    public synchronized void remove(LibraryDefinition libraryDefinition) {
        try {
            this.validate(libraryDefinition);
        }
        catch (LibraryRegistrationException libraryRegistrationException) {
            return;
        }
        this.libTree.remove((RegistryKey[])RegistryKey.newInstance(libraryDefinition));
    }

    public synchronized int size() {
        return this.libTree.size();
    }

    public synchronized String toString() {
        return this.libTree.toString();
    }

    public synchronized Collection<LibraryDefinition> getAll() {
        HashSet<LibraryDefinition> hashSet = new HashSet<LibraryDefinition>();
        this.libTree.getAll(hashSet);
        return hashSet;
    }

    private void handleNodeModificationException(LibraryDefinition libraryDefinition, NodeModificationException nodeModificationException) throws LibraryRegistrationException {
        String string = null;
        if (nodeModificationException.getDepth() == 2) {
            string = LibraryConstants.SPEC_VERSION_NAME;
        } else if (nodeModificationException.getDepth() == 3) {
            string = LibraryConstants.IMPL_VERSION_NAME;
        }
        String string2 = null;
        if (nodeModificationException.getType() == NodeModificationException.Type.ADDING_VALUE_TO_NON_LEAF_NODE) {
            string2 = "Must provide " + string + " for Library, " + "because it is set for all other registered Libraries with name \"" + libraryDefinition.getName() + "\"";
        } else if (nodeModificationException.getType() == NodeModificationException.Type.ADDING_EDGE_TO_LEAF_NODE) {
            string2 = "Cannot register Library \"" + libraryDefinition.getName() + "\" with " + string + " set, because other registered Libraries with the " + "same name do not have " + string + " set";
        }
        throw new LibraryRegistrationException(string2);
    }
}

