/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryReferencer;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public final class LibraryRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements LibraryRuntimeMBean {
    private final ComponentMBean[] components;
    private final LibraryData libData;
    private final String libId;
    private final Collection references = new HashSet();

    public LibraryRuntimeMBeanImpl(LibraryData libraryData, String string, ComponentMBean[] componentMBeanArray) throws ManagementException {
        super(string);
        this.components = componentMBeanArray;
        this.libData = libraryData;
        this.libId = string;
    }

    public ComponentMBean[] getComponents() {
        return this.components;
    }

    public String getLibraryName() {
        return this.libData.getName();
    }

    public File getLocation() {
        return this.libData.getLocation();
    }

    public String getLibraryIdentifier() {
        return this.libId;
    }

    public String getSpecificationVersion() {
        if (this.libData.getSpecificationVersion() == null) {
            return null;
        }
        return this.libData.getSpecificationVersion().toString();
    }

    public String getImplementationVersion() {
        return this.libData.getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeMBean[] getReferencingRuntimes() {
        Collection collection = this.references;
        synchronized (collection) {
            RuntimeMBean[] runtimeMBeanArray = new RuntimeMBean[this.references.size()];
            int n = 0;
            for (LibraryReferencer libraryReferencer : this.references) {
                runtimeMBeanArray[n++] = libraryReferencer.getReferencerRuntime();
            }
            return runtimeMBeanArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getReferencingNames() {
        Collection collection = this.references;
        synchronized (collection) {
            String[] stringArray = new String[this.references.size()];
            int n = 0;
            Iterator iterator = this.references.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = ((LibraryReferencer)iterator.next()).getReferencerName();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(LibraryReferencer libraryReferencer) {
        Collection collection = this.references;
        synchronized (collection) {
            this.references.add(libraryReferencer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(LibraryReferencer libraryReferencer) {
        Collection collection = this.references;
        synchronized (collection) {
            this.references.remove(libraryReferencer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReferenced() {
        Collection collection = this.references;
        synchronized (collection) {
            return !this.references.isEmpty();
        }
    }
}

