/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.Serializable;
import java.util.ArrayList;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.internal.library.util.DeweyDecimal;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryReference;

class RegistryKey
implements Serializable,
Comparable {
    private final DeweyDecimal comparableKey;
    private final String keyStringRepr;
    private final boolean isComparable;

    static RegistryKey[] newInstance(LibraryReference libraryReference) {
        return RegistryKey.newInstance(libraryReference.getLibData(), true);
    }

    static RegistryKey[] newInstance(LibraryDefinition libraryDefinition) {
        return RegistryKey.newInstance(libraryDefinition.getLibData(), false);
    }

    static RegistryKey[] newInstance(BasicLibraryData basicLibraryData, boolean bl) {
        ArrayList<RegistryKey> arrayList = new ArrayList<RegistryKey>(3);
        arrayList.add(new RegistryKey(basicLibraryData.getName()));
        if (basicLibraryData.getSpecificationVersion() != null) {
            arrayList.add(new RegistryKey(basicLibraryData.getSpecificationVersion()));
        } else if (bl) {
            arrayList.add(null);
        }
        if (basicLibraryData.getImplementationVersion() != null) {
            arrayList.add(new RegistryKey(basicLibraryData.getImplementationVersion()));
        } else if (bl) {
            arrayList.add(null);
        }
        return arrayList.toArray(new RegistryKey[arrayList.size()]);
    }

    private RegistryKey(DeweyDecimal deweyDecimal) {
        if (deweyDecimal == null) {
            throw new IllegalArgumentException("Cannot make RegistryKey with null DeweyDecimal");
        }
        this.comparableKey = deweyDecimal;
        this.isComparable = true;
        this.keyStringRepr = deweyDecimal.toString();
    }

    private RegistryKey(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot make RegistryKey with null String");
        }
        DeweyDecimal deweyDecimal = RegistryKey.initDeweyDecimal(string);
        if (deweyDecimal == null) {
            this.comparableKey = null;
            this.isComparable = false;
            this.keyStringRepr = string;
        } else {
            this.comparableKey = deweyDecimal;
            this.isComparable = true;
            this.keyStringRepr = deweyDecimal.toString();
        }
    }

    public int compareTo(Object object) {
        return this.compareTo((RegistryKey)object);
    }

    public int compareTo(RegistryKey registryKey) {
        if (this.isComparable() && registryKey.isComparable()) {
            return this.getComparableKey().compareTo(registryKey.getComparableKey());
        }
        return this.toString().compareTo(registryKey.toString());
    }

    public boolean isComparable() {
        return this.isComparable;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RegistryKey)) {
            return false;
        }
        RegistryKey registryKey = (RegistryKey)object;
        return this.keyStringRepr.equals(registryKey.toString());
    }

    public String toString() {
        return this.keyStringRepr;
    }

    private DeweyDecimal getComparableKey() {
        return this.comparableKey;
    }

    private static DeweyDecimal initDeweyDecimal(String string) {
        try {
            return new DeweyDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

