/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library.util;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeweyDecimal
implements Comparable<DeweyDecimal>,
Serializable {
    private static final long serialVersionUID = -1547973439851595348L;
    private static final String FORMAT = "int(.int)*, int >=0";
    private static final String FORMAT_ERROR = "DeweyDecimal must be of format: int(.int)*, int >=0";
    private final int[] decimals;
    private final String stringRepr;

    public DeweyDecimal(Float f) {
        this(String.valueOf(f));
    }

    public DeweyDecimal(String string) {
        this.validate(string);
        this.decimals = this.init(string);
        this.stringRepr = this.decimalsToString();
    }

    private void validate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("DeweyDecimal cannot be constructed from null String");
        }
        if (string.startsWith(".") || string.endsWith(".")) {
            throw new NumberFormatException(FORMAT_ERROR);
        }
    }

    private int[] init(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(".");
        if (n == -1) {
            return new int[]{this.parseInt(string)};
        }
        int n2 = 0;
        int n3 = string2.length();
        int[] nArray = null;
        while (n > -1) {
            int n4 = this.parseInt(string2.substring(n + 1, n3));
            if (n4 != 0 || nArray != null) {
                if (nArray == null) {
                    n2 = this.countNumDots(string2);
                    nArray = new int[n2 + 1];
                }
                nArray[n2] = n4;
            }
            string2 = string2.substring(0, n);
            n3 = n;
            n = string2.lastIndexOf(".");
            --n2;
        }
        if (nArray == null) {
            nArray = new int[]{this.parseInt(string2)};
        }
        return nArray;
    }

    private int parseInt(String string) {
        int n = Integer.parseInt(string);
        if (n < 0) {
            throw new NumberFormatException(n + " " + FORMAT_ERROR);
        }
        return n;
    }

    private int countNumDots(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n;
    }

    private String decimalsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.decimals.length; ++i) {
            stringBuffer.append(this.decimals[i]);
            if (i >= this.decimals.length - 1) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.stringRepr.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DeweyDecimal)) {
            return false;
        }
        return this.equalsInternal(object);
    }

    public String toString() {
        return this.stringRepr;
    }

    private int[] getDecimals() {
        return this.decimals;
    }

    private boolean equalsInternal(Object object) {
        return this.hashCode() == object.hashCode();
    }

    @Override
    public int compareTo(DeweyDecimal deweyDecimal) {
        if (this.equalsInternal(deweyDecimal)) {
            return 0;
        }
        int n = 0;
        while (n != deweyDecimal.getDecimals().length) {
            if (n == this.getDecimals().length) {
                return -1;
            }
            if (this.getDecimals()[n] > deweyDecimal.getDecimals()[n]) {
                return 1;
            }
            if (this.getDecimals()[n] < deweyDecimal.getDecimals()[n]) {
                return -1;
            }
            ++n;
        }
        return 1;
    }
}

