/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library.util;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import weblogic.application.internal.library.util.RONode;
import weblogic.utils.NestedRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node<Edge, Value>
implements RONode<Edge, Value> {
    private final SortedMap<Edge, Node<Edge, Value>> edges = new TreeMap<Edge, Node<Edge, Value>>();
    private final Node<Edge, Value> parent;
    private Value value = null;

    Node(Node<Edge, Value> node) {
        this.parent = node;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public int getDepth() {
        int n = 1;
        Node<Edge, Value> node = this;
        while (!node.isRoot()) {
            node = node.getParent();
            ++n;
        }
        return n;
    }

    public Node<Edge, Value> remove(Edge Edge) {
        return (Node)this.edges.remove(Edge);
    }

    @Override
    public boolean hasEdge(Edge Edge) {
        return this.edges.containsKey(Edge);
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public Value setVal(Value Value) {
        Value Value2 = null;
        Value2 = this.value;
        this.value = Value;
        return Value2;
    }

    public Node<Edge, Value> getParent() {
        return this.parent;
    }

    public Node<Edge, Value> getChild(Edge Edge) {
        return (Node)this.edges.get(Edge);
    }

    @Override
    public int getNumChildren() {
        return this.edges.size();
    }

    public Node<Edge, Value> getOrCreateChild(Edge Edge) {
        Node<Edge, Value> node = (Node<Edge, Value>)this.edges.get(Edge);
        if (node == null) {
            node = new Node<Edge, Value>(this);
            this.edges.put(Edge, node);
        }
        return node;
    }

    @Override
    public Set<Edge> getEdges() {
        return this.edges.keySet();
    }

    @Override
    public boolean isLeafNode() {
        return this.edges.keySet().isEmpty();
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        if (this.isLeafNode()) {
            return "leaf(" + String.valueOf(this.value) + ")";
        }
        return "not a leaf";
    }

    @Override
    public boolean hasChildren() {
        return this.getNumChildren() != 0;
    }

    @Override
    public Edge getHighestEdge() {
        if (this.isLeafNode()) {
            throw new NoEdgesRuntimeException("No edges to traverse");
        }
        return this.edges.lastKey();
    }

    private static class NoEdgesRuntimeException
    extends NestedRuntimeException {
        private static final long serialVersionUID = 4299692877739743461L;

        public NoEdgesRuntimeException(String string) {
            super(string);
        }
    }
}

