/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import weblogic.application.internal.library.util.AbstractTraversal;
import weblogic.application.internal.library.util.Node;
import weblogic.application.internal.library.util.NodeModificationException;
import weblogic.application.internal.library.util.RONode;
import weblogic.application.internal.library.util.Traversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedNodeTree<Edge, Value> {
    public static final boolean VALUES_ONLY_IN_LEAF_NODES = true;
    private final Node<Edge, Value> root = new Node(null);

    public Value remove(Edge[] EdgeArray) {
        Node<Edge, Value> node = this.getNode(EdgeArray);
        if (node == null) {
            return null;
        }
        Value Value = node.getValue();
        this.killOnlyChild(EdgeArray, EdgeArray.length, node);
        return Value;
    }

    public Value put(Edge[] EdgeArray, Value Value) throws NodeModificationException {
        Node<Edge, Value> node = this.createPathTraversal(EdgeArray, 0, this.root);
        if (!node.isLeafNode()) {
            throw new NodeModificationException(NodeModificationException.Type.ADDING_VALUE_TO_NON_LEAF_NODE, node);
        }
        return node.setVal(Value);
    }

    public boolean hasElement(Edge[] EdgeArray) {
        return this.get(EdgeArray) != null;
    }

    public int size() {
        SizeTraversal sizeTraversal = new SizeTraversal();
        this.traverse(sizeTraversal);
        return sizeTraversal.size();
    }

    public Collection<Value> getAll() {
        ArrayList arrayList = new ArrayList();
        this.getAll(arrayList);
        return arrayList;
    }

    public void getAll(Collection<Value> collection) {
        this.traverse(new GathererTraversal(collection));
    }

    public String toString() {
        if (this.root.getNumChildren() == 0) {
            return "[]";
        }
        StringTraversal stringTraversal = new StringTraversal();
        this.traverse(stringTraversal);
        return ((Object)stringTraversal).toString();
    }

    public void traverse(Traversal<Edge, Value> traversal) {
        this.traverse(traversal, this.root, new ArrayList());
    }

    private void killOnlyChild(Edge[] EdgeArray, int n, Node<Edge, Value> node) {
        Node<Edge, Value> node2 = node.getParent();
        Edge Edge = EdgeArray[n - 1];
        node2.remove(Edge);
        if (!node2.isRoot() && node2.getNumChildren() == 0) {
            if (!node2.hasValue()) {
                this.killOnlyChild(EdgeArray, n - 1, node2);
            } else assert (false);
        }
    }

    private Value get(Edge[] EdgeArray) {
        Node<Edge, Value> node = this.getNode(EdgeArray);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    private Node<Edge, Value> getNode(Edge[] EdgeArray) {
        ExactMatchTraversal exactMatchTraversal = new ExactMatchTraversal(EdgeArray);
        this.traverse(exactMatchTraversal);
        return exactMatchTraversal.getMatchNode();
    }

    private Node<Edge, Value> createPathTraversal(Edge[] EdgeArray, int n, Node<Edge, Value> node) throws NodeModificationException {
        Node<Edge, Value> node2 = node.getOrCreateChild(EdgeArray[n]);
        if (n == EdgeArray.length - 1) {
            return node2;
        }
        if (node2.hasValue() && node2.isLeafNode()) {
            throw new NodeModificationException(NodeModificationException.Type.ADDING_EDGE_TO_LEAF_NODE, node2);
        }
        return this.createPathTraversal(EdgeArray, n + 1, node2);
    }

    private void traverse(Traversal<Edge, Value> traversal, Node<Edge, Value> node, List<Edge> list) {
        if (node.isLeafNode()) {
            traversal.visitLeaf(node, list);
        } else {
            traversal.visit(node, list);
            Edge Edge = traversal.getNextEdge(node);
            if (Edge != null) {
                this.traverse(traversal, node, Edge, list);
            } else {
                Edge[] EdgeArray = traversal.getNextEdges(node);
                if (EdgeArray != null) {
                    for (int i = 0; i < EdgeArray.length; ++i) {
                        this.traverse(traversal, node, EdgeArray[i], list);
                        list.remove(list.size() - 1);
                    }
                }
            }
        }
    }

    private void traverse(Traversal<Edge, Value> traversal, Node<Edge, Value> node, Edge Edge, List<Edge> list) {
        try {
            if (!node.hasEdge(Edge)) {
                this.throwUnknownEdgeException(Edge, node, null);
            }
        }
        catch (ClassCastException classCastException) {
            this.throwUnknownEdgeException(Edge, node, classCastException);
        }
        list.add(Edge);
        this.traverse(traversal, node.getChild(Edge), list);
    }

    private void throwUnknownEdgeException(Edge Edge, Node<Edge, Value> node, ClassCastException classCastException) {
        throw new UnknownEdgeRuntimeException("Unknown edge: " + String.valueOf(Edge) + ". Current " + "Node has edges: " + node.getEdges() + ".", classCastException);
    }

    private static class UnknownEdgeRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 3240595793558570615L;

        public UnknownEdgeRuntimeException(String string) {
            super(string);
        }

        public UnknownEdgeRuntimeException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SizeTraversal
    extends AbstractTraversal<Edge, Value>
    implements Traversal<Edge, Value> {
        private int numLeafNodes = 0;

        private SizeTraversal() {
        }

        @Override
        public Edge[] getNextEdges(RONode<Edge, Value> rONode) {
            return rONode.getEdges().toArray();
        }

        @Override
        public void visitLeaf(RONode<Edge, Value> rONode, List<Edge> list) {
            if (rONode.hasValue()) {
                ++this.numLeafNodes;
            }
        }

        public int size() {
            return this.numLeafNodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringTraversal
    extends AbstractTraversal<Edge, Value>
    implements Traversal<Edge, Value> {
        private final StringBuffer sb = new StringBuffer();

        private StringTraversal() {
        }

        @Override
        public Edge[] getNextEdges(RONode<Edge, Value> rONode) {
            return rONode.getEdges().toArray();
        }

        @Override
        public void visitLeaf(RONode<Edge, Value> rONode, List<Edge> list) {
            this.sb.append(list + " -> " + rONode.getValue()).append("\n");
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GathererTraversal
    extends AbstractTraversal<Edge, Value>
    implements Traversal<Edge, Value> {
        private final Collection<Value> rtn;

        public GathererTraversal(Collection<Value> collection) {
            this.rtn = collection;
        }

        @Override
        public Edge[] getNextEdges(RONode<Edge, Value> rONode) {
            return rONode.getEdges().toArray();
        }

        @Override
        public void visit(RONode<Edge, Value> rONode, List<Edge> list) {
            if (rONode.hasValue()) {
                this.rtn.add(rONode.getValue());
            }
        }

        @Override
        public void visitLeaf(RONode<Edge, Value> rONode, List<Edge> list) {
            if (rONode.hasValue()) {
                this.rtn.add(rONode.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExactMatchTraversal
    extends AbstractTraversal<Edge, Value>
    implements Traversal<Edge, Value> {
        private Edge[] edges = null;
        private RONode<Edge, Value> matchNode = null;
        private int edgeIndex = -1;

        public ExactMatchTraversal(Edge[] EdgeArray) {
            this.edges = EdgeArray;
        }

        @Override
        public Edge getNextEdge(RONode<Edge, Value> rONode) {
            ++this.edgeIndex;
            if (this.edgeIndex == this.edges.length) {
                return null;
            }
            if (this.edges[this.edgeIndex] != null && rONode.hasEdge(this.edges[this.edgeIndex])) {
                return this.edges[this.edgeIndex];
            }
            return null;
        }

        private Node<Edge, Value> getMatchNode() {
            return (Node)this.matchNode;
        }

        @Override
        public void visit(RONode<Edge, Value> rONode, List<Edge> list) {
        }

        @Override
        public void visitLeaf(RONode<Edge, Value> rONode, List<Edge> list) {
            if (this.edgeIndex == this.edges.length - 1) {
                this.matchNode = rONode;
            }
        }
    }
}

