/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.Iterators;
import weblogic.utils.jars.VirtualJarFile;

public final class ClassLoaderVJF
implements VirtualJarFile {
    private final String uri;
    private final String prefix;
    private final GenericClassLoader cl;
    private final File[] rootFiles;

    public ClassLoaderVJF(String string, GenericClassLoader genericClassLoader, File[] fileArray) {
        this.uri = string;
        this.prefix = string + "#";
        this.cl = genericClassLoader;
        this.rootFiles = fileArray;
    }

    public String getName() {
        return this.uri;
    }

    public void close() throws IOException {
    }

    public URL getResource(String string) {
        return this.cl.getResource(this.prefix + string);
    }

    public ZipEntry getEntry(String string) {
        URL uRL = this.getResource(string);
        return uRL == null ? null : new URLZipEntry(uRL);
    }

    public Iterator getEntries(String string) throws IOException {
        ArrayList<URLZipEntry> arrayList = new ArrayList<URLZipEntry>();
        Enumeration enumeration = this.cl.getResources(this.prefix + string);
        while (enumeration.hasMoreElements()) {
            arrayList.add(new URLZipEntry((URL)enumeration.nextElement()));
        }
        return arrayList.iterator();
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        URL uRL = ((URLZipEntry)zipEntry).getURL();
        return uRL.openStream();
    }

    public Manifest getManifest() throws IOException {
        throw new AssertionError((Object)"getManifest not supported");
    }

    public File[] getRootFiles() {
        return this.rootFiles;
    }

    public boolean isDirectory() {
        throw new AssertionError((Object)"isDirectory not supported");
    }

    public JarFile getJarFile() {
        throw new AssertionError((Object)"getJarFile not supported");
    }

    public File getDirectory() {
        throw new AssertionError((Object)"getDirectory not supported");
    }

    public Iterator entries() {
        try {
            return this.getEntries("/");
        }
        catch (IOException iOException) {
            return Iterators.EMPTY_ITERATOR;
        }
    }

    private static class URLZipEntry
    extends ZipEntry {
        private final URL url;

        URLZipEntry(URL uRL) {
            super(uRL.toString());
            this.url = uRL;
        }

        URL getURL() {
            return this.url;
        }
    }
}

