/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import weblogic.application.ApplicationConstants;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.io.ClasspathInfo;
import weblogic.application.io.DescriptorFinder;
import weblogic.application.io.ExplodedJar;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.utils.IOUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class Ear {
    private final ExplodedJar archive;
    private final ClassFinder classfinder;
    private final Map<String, List<File>> uriLinks = new ConcurrentHashMap();
    private final Map<String, VirtualJarFile> virtualJars = new HashMap<String, VirtualJarFile>();
    private final String uri;
    private static final ClasspathInfo earInfo = new ClasspathInfo(){
        private final String[] APP_INF_CLASSES = new String[]{ApplicationConstants.APP_INF_CLASSES};
        private final String[] LIB_DIRS = new String[]{ApplicationConstants.APP_INF_LIB};

        public String[] getClasspathURIs() {
            return this.APP_INF_CLASSES;
        }

        public String[] getJarURIs() {
            return this.LIB_DIRS;
        }
    };

    public Ear(String string, File file, File file2) throws IOException {
        this.archive = new ExplodedJar(string, file, file2, earInfo);
        this.classfinder = this.archive.getClassFinder();
        this.uri = string;
    }

    public Ear(String string, File file, File[] fileArray) throws IOException {
        this(string, file, fileArray, JarCopyFilter.DEFAULT_FILTER);
    }

    public Ear(String string, File file, File[] fileArray, JarCopyFilter jarCopyFilter) throws IOException {
        this.archive = new ExplodedJar(string, file, fileArray, earInfo, jarCopyFilter);
        this.classfinder = this.archive.getClassFinder();
        this.uri = string;
    }

    public Ear(String string, File file, SplitDirectoryInfo splitDirectoryInfo) throws IOException {
        this(string, file, splitDirectoryInfo, JarCopyFilter.DEFAULT_FILTER);
    }

    public Ear(String string, File file, SplitDirectoryInfo splitDirectoryInfo, JarCopyFilter jarCopyFilter) throws IOException {
        this(string, file, splitDirectoryInfo.getRootDirectories(), jarCopyFilter);
        this.uriLinks.putAll(splitDirectoryInfo.getUriLinks());
        String string2 = splitDirectoryInfo.getExtraClasspath();
        if (!"".equals(string2)) {
            MultiClassFinder multiClassFinder = (MultiClassFinder)this.classfinder;
            ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(string2);
            multiClassFinder.addFinder((ClassFinder)classpathClassFinder2);
            multiClassFinder.addFinder((ClassFinder)new DescriptorFinder(string, (ClassFinder)classpathClassFinder2));
        }
    }

    public String getURI() {
        return this.uri;
    }

    public File[] getModuleRoots(String string) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        File[] fileArray = this.archive.getDirs();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = new File(fileArray[i], string);
            if (!file.exists()) continue;
            linkedHashSet.add(file);
        }
        List<File> list = this.uriLinks.get(string);
        if (list != null) {
            linkedHashSet.addAll(list);
        }
        return linkedHashSet.toArray(new File[linkedHashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream findScopedModuleResource(String string, String string2, String string3) throws IOException {
        VirtualJarFile virtualJarFile = null;
        Object object = this.virtualJars;
        synchronized (object) {
            if (this.virtualJars.containsKey(string)) {
                virtualJarFile = this.virtualJars.get(string);
            } else {
                virtualJarFile = VirtualJarFactory.createVirtualJar((File[])this.getModuleRoots(string));
                this.virtualJars.put(string, virtualJarFile);
            }
        }
        if (virtualJarFile == null) {
            return null;
        }
        object = virtualJarFile.getEntry(string2 + "/" + string3);
        return object == null ? null : virtualJarFile.getInputStream((ZipEntry)object);
    }

    public synchronized void registerLink(String string, File file) {
        List<File> list = this.uriLinks.get(string);
        if (list == null) {
            list = new ArrayList<File>();
        }
        list.add(file);
        this.uriLinks.put(string, list);
    }

    public ClassFinder getClassFinder() {
        return this.classfinder;
    }

    public void remove() {
        Iterator<VirtualJarFile> iterator = this.virtualJars.values().iterator();
        while (iterator.hasNext()) {
            IOUtils.forceClose(iterator.next());
        }
        this.classfinder.close();
        this.archive.remove();
        this.archive.removeTopLevelTempDir();
    }
}

