/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import weblogic.application.io.Archive;
import weblogic.application.io.ClasspathInfo;
import weblogic.application.io.DescriptorFinder;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.io.ManifestFinder;
import weblogic.application.io.ManifestHelper;
import weblogic.utils.FileUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.jars.JarFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedJar
extends Archive {
    private static final FileFilter JAR_FILTER = new JarFileFilter(null);
    private final File extractDir;
    private final ClasspathInfo info;
    private final JarCopyFilter jarCopyFilter;
    protected final File[] dirs;
    protected final String uri;
    protected static final String MARKER_FILE = ".beamarker.dat";

    public ExplodedJar(String string, File file, File file2, ClasspathInfo classpathInfo) throws IOException {
        this(string, ExplodedJar.extractJarFile(file, file2), new File[0], classpathInfo, JarCopyFilter.NOCOPY_FILTER);
    }

    public ExplodedJar(String string, File file, File[] fileArray, ClasspathInfo classpathInfo, JarCopyFilter jarCopyFilter) {
        this.extractDir = file;
        this.info = classpathInfo;
        this.uri = string;
        this.jarCopyFilter = jarCopyFilter;
        this.dirs = new File[fileArray.length + 1];
        this.dirs[0] = file;
        System.arraycopy(fileArray, 0, this.dirs, 1, fileArray.length);
    }

    protected String getURI() {
        return this.uri;
    }

    public File[] getDirs() {
        return this.dirs;
    }

    @Override
    public ClassFinder getClassFinder() throws IOException {
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        multiClassFinder.addFinder(this.buildClasspathFinder());
        multiClassFinder.addFinder(this.buildDescriptorFinder());
        this.addManifestFinders(multiClassFinder);
        return multiClassFinder;
    }

    protected ClassFinder buildDescriptorFinder() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dirs.length; ++i) {
            this.addClasspath(stringBuffer, this.dirs[i]);
        }
        return new DescriptorFinder(this.uri, (ClassFinder)new ClasspathClassFinder2(stringBuffer.toString()));
    }

    protected FileFilter getJarFileFilter() {
        return JAR_FILTER;
    }

    private void addManifestFinders(MultiClassFinder multiClassFinder) throws IOException {
        for (int i = 0; i < this.dirs.length; ++i) {
            multiClassFinder.addFinder((ClassFinder)new ManifestFinder.ExtensionListFinder(this.dirs[i]));
        }
    }

    private ClassFinder buildClasspathFinder() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.info.getClasspathURIs();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addClasspathURI(stringBuffer, stringArray[i]);
        }
        String[] stringArray2 = this.info.getJarURIs();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.addJarURI(stringBuffer, stringArray2[i]);
        }
        return new ClasspathClassFinder2(stringBuffer.toString());
    }

    private void addClasspathURI(StringBuffer stringBuffer, String string) {
        for (int i = 0; i < this.dirs.length; ++i) {
            this.addClasspath(stringBuffer, new File(this.dirs[i], string));
        }
    }

    private void addJarURI(StringBuffer stringBuffer, String string) throws IOException {
        Set<File> set;
        File file = new File(this.extractDir, string);
        StringBuffer stringBuffer2 = new StringBuffer();
        Set<File> set2 = set = Collections.emptySet();
        if (this.dirs.length > 1 && file.exists() && file.isDirectory()) {
            set2 = new HashSet<File>(Arrays.asList(file.listFiles(this.getJarFileFilter())));
        }
        for (int i = 1; i < this.dirs.length; ++i) {
            this.addJars(stringBuffer2, this.dirs[i], string, file, set2);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            FileUtils.remove((File)((File)iterator.next()));
        }
        this.addJars(stringBuffer, this.dirs[0], string, file, set);
        stringBuffer.append(File.pathSeparator).append(stringBuffer2);
    }

    private void addJars(StringBuffer stringBuffer, File file, String string, File file2, Set<File> set) throws IOException {
        File file3 = new File(file, string);
        if (!file3.exists() || !file3.isDirectory()) {
            return;
        }
        File[] fileArray = file3.listFiles(this.getJarFileFilter());
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.addAndMaybeCopy(stringBuffer, fileArray[i], file, file2, set);
        }
    }

    private void addAndMaybeCopy(StringBuffer stringBuffer, File file, File file2, File file3, Set<File> set) throws IOException {
        if (!this.jarCopyFilter.copyJars()) {
            this.addClasspath(stringBuffer, file);
            return;
        }
        this.handleManifestReferences(stringBuffer, file, file2);
        File file4 = new File(file3, file.getName());
        if (set.contains(file4)) {
            set.remove(file4);
        }
        this.copyFile(file, file4);
        this.addClasspath(stringBuffer, file4);
    }

    private void copyFile(File file, File file2) throws IOException {
        if (!file2.exists() || file.lastModified() > file2.lastModified()) {
            FileUtils.copy((File)file, (File)file2);
            file2.setLastModified(file.lastModified());
        }
    }

    private void handleManifestReferences(StringBuffer stringBuffer, File file, File file2) throws IOException {
        File[] fileArray = ManifestHelper.getExistingMFClassPathElements(file);
        URI uRI = file2.toURI();
        for (int i = 0; i < fileArray.length; ++i) {
            URI uRI2 = fileArray[i].toURI();
            URI uRI3 = uRI.relativize(uRI2);
            if (uRI3 == uRI2) continue;
            if (fileArray[i].isFile()) {
                if (fileArray[i].getParentFile().equals(file.getParentFile())) continue;
                File file3 = new File(this.extractDir, uRI3.toString());
                this.copyFile(fileArray[i], file3);
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            this.addClasspath(stringBuffer, fileArray[i]);
        }
    }

    protected void addClasspath(StringBuffer stringBuffer, File file) {
        this.addClasspath(stringBuffer, file.getAbsolutePath());
    }

    private void addClasspath(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(File.pathSeparator);
        }
        stringBuffer.append(string);
    }

    @Override
    public void remove() {
        if (this.extractDir.exists()) {
            FileUtils.remove((File)this.extractDir);
        }
    }

    public void removeTopLevelTempDir() {
        File file = this.extractDir.getParentFile();
        if (file.exists()) {
            FileUtils.remove((File)file);
        }
    }

    protected static boolean extractionUpToDate(File file, File file2) {
        File file3 = new File(file, MARKER_FILE);
        return file3.exists() && file3.lastModified() == file2.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File extractJarFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block7: {
            if (file.exists()) {
                if (ExplodedJar.extractionUpToDate(file, file2)) {
                    return file;
                }
                FileUtils.remove((File)file);
            }
            file.mkdirs();
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file2);
                JarFileUtils.extract((JarFile)jarFile, (File)file);
                fileOutputStream = null;
                if (jarFile == null) break block7;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (jarFile != null) {
                    jarFile.close();
                }
                throw throwable;
            }
            jarFile.close();
        }
        File file3 = new File(file, MARKER_FILE);
        fileOutputStream = new FileOutputStream(file3);
        try {
            fileOutputStream.write(0);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        file3.setLastModified(file2.lastModified());
        return file;
    }

    protected static class JarFileFilter
    implements FileFilter {
        private File excludeFile;

        public JarFileFilter(File file) {
            this.excludeFile = file;
        }

        public boolean accept(File file) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) {
                return false;
            }
            return this.excludeFile == null || !this.excludeFile.equals(file);
        }
    }
}

