/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.io.File;
import java.io.IOException;
import weblogic.application.io.Archive;
import weblogic.application.io.DescriptorFinder;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;

public final class Jar
extends Archive {
    private final File jarFile;
    private final String uri;

    public Jar(String string, File file) {
        if (DEBUG) {
            Debug.assertion((file != null ? 1 : 0) != 0);
            Debug.assertion((boolean)file.exists());
            Debug.assertion((!file.isDirectory() ? 1 : 0) != 0);
        }
        this.uri = string;
        this.jarFile = file;
    }

    public ClassFinder getClassFinder() throws IOException {
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        multiClassFinder.addFinder((ClassFinder)new DescriptorFinder(this.uri, (ClassFinder)new ClasspathClassFinder2(this.jarFile.getAbsolutePath())));
        multiClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(this.jarFile.getAbsolutePath()));
        return multiClassFinder;
    }

    public void remove() {
    }
}

