/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.URLSource;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.SingleItemEnumeration;
import weblogic.utils.io.UnsyncByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergedDescriptorFinder
extends URLStreamHandler
implements ClassFinder {
    private static final String PROTOCOL_NAME = "merged-descriptor";
    private final Map<String, DescriptorBean> descriptors;

    public MergedDescriptorFinder(Map<String, DescriptorBean> map) {
        this.descriptors = map;
    }

    public Source getSource(String string) {
        DescriptorBean descriptorBean = this.descriptors.get(string);
        if (descriptorBean != null) {
            try {
                return new URLSource(new URL(PROTOCOL_NAME, null, -1, string, this));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Enumeration getSources(String string) {
        Source source = this.getSource(string);
        if (source == null) {
            return new EmptyEnumerator();
        }
        return new SingleItemEnumeration((Object)source);
    }

    public Source getClassSource(String string) {
        return null;
    }

    public String getClassPath() {
        return "";
    }

    public ClassFinder getManifestFinder() {
        return NullClassFinder.NULL_FINDER;
    }

    public Enumeration entries() {
        return EmptyEnumerator.EMPTY;
    }

    public void close() {
        this.descriptors.clear();
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        DescriptorBean descriptorBean = this.descriptors.get(uRL.getFile());
        if (descriptorBean == null) {
            throw new IOException("Merged descriptor not found " + uRL.getFile());
        }
        return new DescriptorURLConnection(uRL, descriptorBean);
    }

    @Override
    protected String toExternalForm(URL uRL) {
        return "merged-descriptor:/" + uRL.getFile();
    }

    static class DescriptorURLConnection
    extends URLConnection {
        public static final EditableDescriptorManager descMgr = new EditableDescriptorManager();
        private DescriptorBean descriptor;

        public DescriptorURLConnection(URL uRL, DescriptorBean descriptorBean) {
            super(uRL);
            this.descriptor = descriptorBean;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            descMgr.writeDescriptorAsXML(this.descriptor.getDescriptor(), (OutputStream)byteArrayOutputStream);
            return new UnsyncByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
    }
}

