/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.text.MessageFormat;

public final class VirtualEarException
extends Exception {
    public static final int PATH_CONFLICTS = 0;
    public static final int MALFORMED_DESC = 1;
    public static final int DELETE_FAILED = 2;
    private static final int LAST_ERROR_CODE = 2;
    private static final String[] templates = new String[3];
    private String message;

    public VirtualEarException(int n) {
        this(n, new String[0]);
    }

    public VirtualEarException(int n, String[] stringArray) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.message = MessageFormat.format(templates[n], stringArray);
    }

    public VirtualEarException(Throwable throwable) {
        super(throwable);
        this.message = throwable.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getMessage();
    }

    static {
        VirtualEarException.templates[0] = "\nCould not create a link due to conflicting paths.\n\n  Link:         {0} -> {1}\n  Conflict(s):  {2}\n\n";
        VirtualEarException.templates[1] = "Cannot parse .beabuild.txt file. It appears to be corrupted.";
        VirtualEarException.templates[2] = "The corrupt application.xml file could not be deleted.";
    }
}

