/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import weblogic.application.io.VirtualEarException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;

public final class VirtualEarManager {
    public static final String PAT_DIRECT_DESC = "*";
    public static final String PAT_DIRECT_DESC_OR_SELF = ".*";
    public static final String PAT_ALL_DESC = "**";
    public static final String PAT_ALL_DESC_OR_SELF = ".**";
    private static final String FILE_NAME = ".beabuild.txt";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Win");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LINKING_MSG = "Linking {0} to {1}.";
    private static final String NO_MODULES = "Application contains no deployable modules.";
    private final String earRootPath;
    private final ArrayList links;
    private boolean linksDirty;
    private ApplicationBean appBean;
    private boolean appBeanDirty;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VirtualEarManager(String string) throws VirtualEarException {
        this.earRootPath = VirtualEarManager.normalize(string);
        this.links = new ArrayList();
        this.linksDirty = false;
        this.appBean = null;
        this.appBeanDirty = false;
        File file = new File(string, FILE_NAME);
        if (!file.exists()) {
            return;
        }
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            int n = 1;
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = null;
            int n2 = reader.read();
            while (n2 != -1) {
                if (n2 == 10 || n2 == 13) {
                    if (n == 3) {
                        this._link(VirtualEarManager.unescape(stringBuffer.toString().trim()), VirtualEarManager.unescape(stringBuffer2.toString().trim()));
                        n = 1;
                    } else if (n == 2) {
                        throw new VirtualEarException(1);
                    }
                } else if (n2 == 61) {
                    if (n != 2) throw new VirtualEarException(1);
                    stringBuffer2 = new StringBuffer();
                    n = 3;
                } else if (n == 1) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append((char)n2);
                    n = 2;
                } else if (n == 2) {
                    stringBuffer.append((char)n2);
                } else {
                    stringBuffer2.append((char)n2);
                }
                n2 = reader.read();
            }
            if (n == 3) {
                this._link(VirtualEarManager.unescape(stringBuffer.toString().trim()), VirtualEarManager.unescape(stringBuffer2.toString().trim()));
                return;
            } else {
                if (n != 2) return;
                throw new VirtualEarException(1);
            }
        }
        catch (IOException iOException) {
            throw new VirtualEarException(iOException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void link(String string, String string2) throws VirtualEarException {
        File file = new File(string);
        if (file.exists()) {
            Object object;
            String[] stringArray = this.resolve(string2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                object = new File(stringArray[i]);
                if (file.equals(object) || !(file.isFile() && ((File)object).isDirectory() || file.isDirectory() && ((File)object).isFile()) && (!file.isFile() || !((File)object).isFile())) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n                ");
                }
                stringBuffer.append(stringArray[i]);
            }
            if (stringBuffer.length() > 0) {
                object = new String[]{VirtualEarManager.toPlatformFormat(VirtualEarManager.normalize(string)), VirtualEarManager.toPlatformFormat(VirtualEarManager.normalize(string2)), VirtualEarManager.toPlatformFormat(stringBuffer.toString())};
                throw new VirtualEarException(0, (String[])object);
            }
        }
        if (this._link(string, string2)) {
            this.linksDirty = true;
            this.write();
        }
    }

    private boolean _link(String string, String string2) {
        Link link = string.equals("bea.srcdir") ? new Link(string2, "") : new Link(string, string2);
        if (!this.links.contains(link)) {
            this.links.add(link);
            return true;
        }
        return false;
    }

    public void unlink(String string, String string2) throws VirtualEarException {
        Link[] linkArray = this.search(string, string2);
        for (int i = 0; i < linkArray.length; ++i) {
            this.links.remove(linkArray[i]);
            this.linksDirty = true;
        }
        this.write();
    }

    public Link[] search(String string, String string2) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        String[] stringArray = VirtualEarManager.split(string);
        String[] stringArray2 = VirtualEarManager.split(string2);
        int n = this.links.size();
        for (int i = 0; i < n; ++i) {
            Link link = (Link)this.links.get(i);
            String[] stringArray3 = VirtualEarManager.split(link.getSourcePath());
            String[] stringArray4 = VirtualEarManager.split(link.getTargetPath());
            if (!VirtualEarManager.match(stringArray3, stringArray) || !VirtualEarManager.match(stringArray4, stringArray2)) continue;
            arrayList.add(link);
        }
        return arrayList.toArray(new Link[arrayList.size()]);
    }

    private static boolean match(String[] stringArray, String[] stringArray2) {
        String string;
        int n;
        if (stringArray2 == null) {
            return true;
        }
        for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
            boolean bl;
            string = stringArray[n];
            String string2 = stringArray2[n];
            if ((!IS_WINDOWS || string.equalsIgnoreCase(string2)) && (IS_WINDOWS || string.equals(string2))) continue;
            boolean bl2 = bl = n + 1 == stringArray.length;
            return string2.equals(PAT_ALL_DESC) || string2.equals(PAT_ALL_DESC_OR_SELF) || string2.equals(PAT_DIRECT_DESC) && bl || string2.equals(PAT_DIRECT_DESC_OR_SELF) && bl;
        }
        if (n < stringArray.length) {
            return false;
        }
        if (n < stringArray2.length) {
            string = stringArray2[n];
            return n + 1 == stringArray2.length && (string.equals(PAT_DIRECT_DESC_OR_SELF) || string.equals(PAT_ALL_DESC_OR_SELF));
        }
        return true;
    }

    public String[] list(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = VirtualEarManager.normalize(string);
        String[] stringArray = this.resolve(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            File file = new File(string);
            if (file.isDirectory()) {
                String[] stringArray2 = file.list();
                for (int j = 0; j < stringArray2.length; ++j) {
                    hashSet.add(string2 + "/" + stringArray2[j]);
                }
                continue;
            }
            throw new IllegalArgumentException("not a directory");
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] resolve(String string) {
        String[] stringArray = VirtualEarManager.split(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.earRootPath + "/" + string);
        int n = this.links.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Link link = (Link)this.links.get(i);
            String[] stringArray2 = VirtualEarManager.split(link.getTargetPath());
            for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length; ++n2) {
                String string2 = stringArray[n2];
                String string3 = stringArray2[n2];
                if (IS_WINDOWS && !string2.equalsIgnoreCase(string3) || !IS_WINDOWS && !string2.equals(string3)) break;
            }
            if (n2 != stringArray2.length) continue;
            if (n2 == stringArray.length) {
                arrayList.add(link.getSourcePath());
                continue;
            }
            arrayList.add(link.getSourcePath() + VirtualEarManager.merge(stringArray, n2, stringArray.length - n2));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (new File((String)iterator.next()).exists()) continue;
            iterator.remove();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void addEjbModule(String string) throws VirtualEarException {
        ApplicationBean applicationBean = this.getApplicationBean(true);
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (!string.equals(moduleBeanArray[i].getEjb())) continue;
            return;
        }
        ModuleBean moduleBean = applicationBean.createModule();
        moduleBean.setEjb(string);
        this.appBeanDirty = true;
        this.write();
    }

    public void addWebModule(String string, String string2) throws VirtualEarException {
        WebBean webBean;
        ApplicationBean applicationBean = this.getApplicationBean(true);
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        boolean bl = false;
        for (int i = 0; i < moduleBeanArray.length && !bl; ++i) {
            webBean = moduleBeanArray[i].getWeb();
            if (webBean == null || !webBean.getWebUri().equals(string)) continue;
            bl = true;
            if (webBean.getContextRoot().equals(string2)) continue;
            webBean.setContextRoot(string2);
            this.appBeanDirty = true;
        }
        if (!bl) {
            ModuleBean moduleBean = applicationBean.createModule();
            webBean = moduleBean.createWeb();
            webBean.setWebUri(string);
            webBean.setContextRoot(string2);
            this.appBeanDirty = true;
        }
        this.write();
    }

    public void removeEjbModule(String string) throws VirtualEarException {
        boolean bl = string.endsWith(PAT_DIRECT_DESC);
        String string2 = bl ? string.substring(0, string.length() - 1) : string;
        ApplicationBean applicationBean = this.getApplicationBean(true);
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            ModuleBean moduleBean = moduleBeanArray[i];
            String string3 = moduleBean.getEjb();
            if (string3 == null || (!bl || !string3.startsWith(string2)) && (bl || !string3.equals(string2))) continue;
            applicationBean.destroyModule(moduleBean);
            this.appBeanDirty = true;
        }
        this.write();
    }

    public void removeWebModule(String string) throws VirtualEarException {
        ApplicationBean applicationBean = this.getApplicationBean(true);
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            ModuleBean moduleBean = moduleBeanArray[i];
            WebBean webBean = moduleBean.getWeb();
            if (webBean == null || !webBean.getWebUri().equals(string)) continue;
            applicationBean.destroyModule(moduleBean);
            this.appBeanDirty = true;
            break;
        }
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationBean getApplicationBean(boolean bl) throws VirtualEarException {
        this.appBean = null;
        File file = new File(this.earRootPath, "META-INF/application.xml");
        if (this.appBean != null && !file.exists()) {
            this.appBean = null;
        }
        if (this.appBean == null) {
            block16: {
                if (file.exists()) {
                    FileInputStream fileInputStream;
                    try {
                        fileInputStream = new FileInputStream(file);
                    }
                    catch (IOException iOException) {
                        throw new VirtualEarException(iOException);
                    }
                    try {
                        try {
                            this.appBean = (ApplicationBean)new EditableDescriptorManager().createDescriptor((InputStream)fileInputStream).getRootBean();
                        }
                        finally {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception exception) {
                        if (file.delete()) break block16;
                        throw new VirtualEarException(2);
                    }
                }
            }
            if (!file.exists() && bl) {
                this.appBean = (ApplicationBean)new EditableDescriptorManager().createDescriptorRoot(ApplicationBean.class).getRootBean();
                int n = this.earRootPath.lastIndexOf("/");
                if (n == -1) {
                    n = this.earRootPath.lastIndexOf("\\");
                }
                String string = this.earRootPath.substring(n + 1);
                this.appBean.setDisplayNames(new String[]{string});
            }
        }
        return this.appBean;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.links.size();
        for (int i = 0; i < n; ++i) {
            Link link = (Link)this.links.get(i);
            link.toString(stringBuffer);
            stringBuffer.append(LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private void write() throws VirtualEarException {
        File file;
        Closeable closeable;
        if (this.linksDirty) {
            closeable = null;
            try {
                file = new File(this.earRootPath, FILE_NAME);
                closeable = new FileWriter(file);
                ((Writer)closeable).write(this.toString());
            }
            catch (IOException iOException) {
                throw new VirtualEarException(iOException);
            }
            finally {
                if (closeable != null) {
                    try {
                        ((OutputStreamWriter)closeable).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.appBeanDirty) {
            closeable = null;
            try {
                file = new File(this.earRootPath, "META-INF");
                file.mkdirs();
                File file2 = new File(file, "application.xml");
                closeable = new FileOutputStream(file2);
                new EditableDescriptorManager().writeDescriptorAsXML(((DescriptorBean)this.appBean).getDescriptor(), (OutputStream)closeable);
            }
            catch (IOException iOException) {
                throw new VirtualEarException(iOException);
            }
            finally {
                if (closeable != null) {
                    try {
                        ((FileOutputStream)closeable).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static String[] split(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static String merge(String[] stringArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (i != n) {
                stringBuffer.append('/');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                stringBuffer.append("\\:");
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("\\ ");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i + 1 < n) {
                stringBuffer.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String normalize(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if ((string = string.replace(File.separatorChar, '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String toPlatformFormat(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace('/', File.separatorChar);
    }

    public static abstract class AbstractModuleTask
    extends AbstractTask {
        protected String uri = null;

        public void setUri(String string) {
            this.uri = string;
        }
    }

    public static abstract class AbstractLinkUnlinkTask
    extends AbstractTask {
        protected String sourcePath = null;
        protected String targetPath = null;

        public void setSource(String string) {
            this.sourcePath = string;
        }

        public void setTarget(String string) {
            this.targetPath = string;
        }
    }

    public static abstract class AbstractTask
    extends Task {
        protected String earRootPath = null;

        public void setEar(String string) {
            this.earRootPath = string;
        }

        public void execute() throws BuildException {
            String string;
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            thread2.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            if (System.getProperty("weblogic.home") == null && (string = this.getProject().getProperty("wl.home")) != null) {
                System.setProperty("weblogic.home", string);
            }
            try {
                this._execute(Cache.get(this.earRootPath));
            }
            catch (VirtualEarException virtualEarException) {
                this.error(virtualEarException.getMessage());
                throw new BuildException();
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        }

        protected abstract void _execute(VirtualEarManager var1) throws VirtualEarException;

        protected void info(String string) {
            this.log(string, 2);
        }

        protected void warning(String string) {
            this.log(string, 1);
        }

        protected void error(String string) {
            this.log(string, 0);
        }

        public void log(String string, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append(' ');
                    }
                    super.log(stringBuffer.toString(), n);
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                super.log(stringBuffer.toString(), n);
            }
        }
    }

    public static final class Validate
    extends AbstractTask {
        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            ApplicationBean applicationBean = virtualEarManager.getApplicationBean(true);
            if (applicationBean.getModules().length == 0) {
                this.warning(VirtualEarManager.NO_MODULES);
            }
        }
    }

    public static final class RemoveWebModuleTask
    extends AbstractModuleTask {
        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            virtualEarManager.removeWebModule(this.uri);
        }
    }

    public static final class RemoveEjbModuleTask
    extends AbstractModuleTask {
        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            virtualEarManager.removeEjbModule(this.uri);
        }
    }

    public static final class AddWebModuleTask
    extends AbstractModuleTask {
        private String contextPath;

        public void setContextPath(String string) {
            this.contextPath = string;
        }

        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            virtualEarManager.addWebModule(this.uri, this.contextPath);
        }
    }

    public static final class AddEjbModuleTask
    extends AbstractModuleTask {
        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            virtualEarManager.addEjbModule(this.uri);
        }
    }

    public static final class UnlinkTask
    extends AbstractLinkUnlinkTask {
        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            virtualEarManager.unlink(this.sourcePath, this.targetPath);
        }
    }

    public static final class LinkTask
    extends AbstractLinkUnlinkTask {
        protected void _execute(VirtualEarManager virtualEarManager) throws VirtualEarException {
            Object[] objectArray = new Object[]{VirtualEarManager.toPlatformFormat(VirtualEarManager.normalize(this.sourcePath)), VirtualEarManager.toPlatformFormat(VirtualEarManager.normalize(this.targetPath))};
            String string = MessageFormat.format(VirtualEarManager.LINKING_MSG, objectArray);
            this.info(string);
            virtualEarManager.link(this.sourcePath, this.targetPath);
        }
    }

    public static final class Link {
        private String source;
        private String target;

        private Link(String string, String string2) {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("Source should be absolute.");
            }
            if (file2.isAbsolute()) {
                throw new IllegalArgumentException("Target should be relative.");
            }
            this.source = VirtualEarManager.normalize(string);
            this.target = VirtualEarManager.normalize(string2);
        }

        public boolean equals(Object object) {
            Link link = (Link)object;
            return this.getSourceFile().equals(link.getSourceFile()) && this.getTargetFile().equals(link.getTargetFile());
        }

        public int hashCode() {
            return this.getSourceFile().hashCode() ^ this.getTargetFile().hashCode();
        }

        public String getSourcePath() {
            return this.source;
        }

        public File getSourceFile() {
            return new File(this.source);
        }

        public String getTargetPath() {
            return this.target;
        }

        public File getTargetFile() {
            return new File(this.target);
        }

        public String toString() {
            return this.toString(new StringBuffer()).toString();
        }

        private StringBuffer toString(StringBuffer stringBuffer) {
            stringBuffer.append(VirtualEarManager.escape(this.source));
            stringBuffer.append(" = ");
            stringBuffer.append(VirtualEarManager.escape(this.target));
            return stringBuffer;
        }
    }

    public static final class Cache {
        private static final HashMap cache = new HashMap();

        public static VirtualEarManager get(String string) throws VirtualEarException {
            VirtualEarManager virtualEarManager = (VirtualEarManager)cache.get(string);
            if (virtualEarManager == null) {
                virtualEarManager = new VirtualEarManager(string);
            }
            return virtualEarManager;
        }

        public static void remove(String string) {
            cache.remove(string);
        }
    }
}

