/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryReference;

public class J2EELibraryReference
extends LibraryReference {
    private final String contextRoot;

    J2EELibraryReference(BasicLibraryData basicLibraryData, boolean bl, String string) {
        super(basicLibraryData, bl);
        this.contextRoot = string;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public int hashCode() {
        return super.hashCode() ^ String.valueOf(this.contextRoot).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof J2EELibraryReference)) {
            return false;
        }
        return super.equals(object) && String.valueOf(this.contextRoot).equals(String.valueOf(((J2EELibraryReference)object).contextRoot));
    }

    protected void moreToString(StringBuffer stringBuffer) {
        stringBuffer.append(", ").append("exact-match").append(": ").append(this.getExactMatch());
        if (this.contextRoot != null) {
            stringBuffer.append(", ").append("context-root").append(": ").append(this.contextRoot);
        }
    }

    LibraryReference.LibEntry getCompositeEntry(Library library) {
        return new J2EELibEntry(library.getLocation(), this.getContextRoot());
    }

    static class J2EELibEntry
    extends LibraryReference.LibEntry {
        private String contextRoot;

        J2EELibEntry(File file, String string) {
            super(file);
            this.contextRoot = string;
        }

        public boolean equals(Object object) {
            if (object.getClass() != this.getClass() && !(object instanceof J2EELibEntry)) {
                return false;
            }
            J2EELibEntry j2EELibEntry = (J2EELibEntry)object;
            return this.location.equals(j2EELibEntry.location) && String.valueOf(this.contextRoot).equals(String.valueOf(j2EELibEntry.contextRoot));
        }

        public int hashCode() {
            return this.location.hashCode() * 17 ^ String.valueOf(this.contextRoot).hashCode();
        }
    }
}

