/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.internal.library.util.DeweyDecimal;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.LibraryConstants;
import weblogic.management.configuration.LibraryMBean;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class LibraryData
extends BasicLibraryData
implements Serializable {
    private static final long serialVersionUID = 1648716277382804679L;
    private File location = null;
    private final LibraryConstants.AutoReferrer[] autoRef;
    private final Attributes attributes;

    public static LibraryData newEmptyInstance(File file) {
        Attributes attributes = null;
        LibraryConstants.AutoReferrer[] autoReferrerArray = null;
        try {
            attributes = LibraryData.getManifestAttributes(file);
            autoReferrerArray = LibraryData.checkAutoRefLib(attributes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new LibraryData(null, null, null, file, autoReferrerArray, attributes);
    }

    public static LibraryData newInstance(String string, String string2, String string3, File file) throws IOException, IllegalSpecVersionTypeException {
        return new LibraryData(string, string2, string3, file);
    }

    public static LibraryData initFromManifest(File file) throws IOException, IllegalSpecVersionTypeException {
        return new LibraryData(file, LibraryData.getManifestAttributes(file));
    }

    public static LibraryData initFromManifest(File file, Attributes attributes) throws IllegalSpecVersionTypeException {
        return new LibraryData(file, attributes);
    }

    public static LibraryData initFromMBean(LibraryMBean libraryMBean, File file) throws IOException, IllegalSpecVersionTypeException {
        return new LibraryData(libraryMBean, file);
    }

    public static LibraryData cloneWithNewName(String string, LibraryData libraryData) {
        return new LibraryData(string, libraryData.getSpecificationVersion(), libraryData.getImplementationVersion(), libraryData.getLocation(), libraryData.getAutoRef(), libraryData.getAttributes());
    }

    private LibraryData(String string, String string2, String string3, File file) throws IOException, IllegalSpecVersionTypeException {
        super(string, string2, string3);
        this.location = file;
        this.attributes = LibraryData.getManifestAttributes(file);
        this.autoRef = LibraryData.checkAutoRefLib(this.attributes);
    }

    private LibraryData(String string, DeweyDecimal deweyDecimal, String string2, File file, LibraryConstants.AutoReferrer[] autoReferrerArray, Attributes attributes) {
        super(string, deweyDecimal, string2);
        this.location = file;
        this.attributes = attributes;
        this.autoRef = autoReferrerArray;
    }

    private LibraryData(LibraryMBean libraryMBean, File file) throws IOException, IllegalSpecVersionTypeException {
        super(libraryMBean);
        this.location = file;
        this.attributes = LibraryData.getManifestAttributes(file);
        this.autoRef = LibraryData.checkAutoRefLib(this.attributes);
    }

    private LibraryData(File file, Attributes attributes) throws IllegalSpecVersionTypeException {
        super(attributes);
        this.location = file;
        this.attributes = attributes;
        this.autoRef = LibraryData.checkAutoRefLib(attributes);
    }

    private LibraryData(BasicLibraryData basicLibraryData, File file, LibraryConstants.AutoReferrer[] autoReferrerArray, Attributes attributes) {
        super(basicLibraryData.getName(), basicLibraryData.getSpecificationVersion(), basicLibraryData.getImplementationVersion());
        this.location = file;
        this.autoRef = autoReferrerArray;
        this.attributes = attributes;
    }

    public File getLocation() {
        return this.location;
    }

    public LibraryConstants.AutoReferrer[] getAutoRef() {
        return this.autoRef;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    void setLocation(File file) {
        this.location = file;
    }

    public LibraryData importData(LibraryData libraryData) {
        BasicLibraryData basicLibraryData = super.importData(libraryData);
        File file = this.getLocation() == null ? libraryData.getLocation() : this.getLocation();
        LibraryConstants.AutoReferrer[] autoReferrerArray = this.getAutoRef().length == 0 ? libraryData.getAutoRef() : this.getAutoRef();
        Attributes attributes = this.getAttributes() == null ? libraryData.getAttributes() : this.getAttributes();
        return new LibraryData(basicLibraryData, file, autoReferrerArray, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getManifestAttributes(File file) throws IOException {
        Attributes attributes = null;
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
        }
        catch (IOException iOException) {
            LibraryData.closeJar(virtualJarFile);
            throw iOException;
        }
        try {
            Manifest manifest = virtualJarFile.getManifest();
            if (manifest != null) {
                attributes = manifest.getMainAttributes();
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibraryData.closeJar(virtualJarFile);
            throw throwable;
        }
        LibraryData.closeJar(virtualJarFile);
        return attributes;
    }

    private static void closeJar(VirtualJarFile virtualJarFile) {
        try {
            if (virtualJarFile != null) {
                virtualJarFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static LibraryConstants.AutoReferrer[] checkAutoRefLib(Attributes attributes) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue("Auto-Ref-By");
        }
        if (string != null) {
            HashSet<LibraryConstants.AutoReferrer> hashSet = new HashSet<LibraryConstants.AutoReferrer>();
            for (String string2 : string.split(",")) {
                hashSet.add(LibraryConstants.AutoReferrer.valueOf(string2.trim()));
            }
            return hashSet.toArray(new LibraryConstants.AutoReferrer[0]);
        }
        return new LibraryConstants.AutoReferrer[0];
    }
}

