/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import weblogic.application.Type;
import weblogic.application.internal.library.LibraryRuntimeMBeanImpl;
import weblogic.application.library.CachableLibMetadata;
import weblogic.application.library.CachableLibMetadataEntry;
import weblogic.application.library.CachableLibMetadataType;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryReference;
import weblogic.management.runtime.LibraryRuntimeMBean;

public abstract class LibraryDefinition
implements Library,
CachableLibMetadata,
Comparable {
    private final LibraryData libData;
    private LibraryRuntimeMBeanImpl runtime = null;

    public LibraryDefinition(LibraryData libraryData, Type type) {
        this.libData = libraryData;
        libraryData.setType(type);
    }

    public void init() throws LibraryProcessingException {
    }

    public void cleanup() throws LibraryProcessingException {
    }

    public void remove() throws LibraryProcessingException {
    }

    public String getName() {
        return this.libData.getName();
    }

    public Type getType() {
        return this.libData.getType();
    }

    public String getSpecificationVersion() {
        if (this.libData.getSpecificationVersion() == null) {
            return null;
        }
        return this.libData.getSpecificationVersion().toString();
    }

    public String getImplementationVersion() {
        return this.libData.getImplementationVersion();
    }

    public File getLocation() {
        return this.libData.getLocation();
    }

    public void setLocation(File file) {
        this.libData.setLocation(file);
    }

    public void setRuntime(LibraryRuntimeMBeanImpl libraryRuntimeMBeanImpl) {
        this.runtime = libraryRuntimeMBeanImpl;
    }

    public LibraryRuntimeMBeanImpl getRuntimeImpl() {
        return this.runtime;
    }

    public LibraryRuntimeMBean getRuntime() {
        return this.getRuntimeImpl();
    }

    public String toString() {
        return this.libData.toString();
    }

    public LibraryData getLibData() {
        return this.libData;
    }

    public int compareTo(Object object) {
        return this.compareTo((LibraryDefinition)object);
    }

    public int compareTo(LibraryDefinition libraryDefinition) {
        return this.getName().compareTo(libraryDefinition.getName());
    }

    public LibraryReference[] getLibraryReferences() {
        return null;
    }

    public CachableLibMetadataEntry[] findAllCachableEntry() {
        return new CachableLibMetadataEntry[0];
    }

    public CachableLibMetadataEntry getCachableEntry(CachableLibMetadataType cachableLibMetadataType) {
        return null;
    }

    public LibraryConstants.AutoReferrer[] getAutoRef() {
        return this.libData.getAutoRef();
    }
}

