/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.security.AccessController;
import java.util.HashSet;
import weblogic.application.utils.LibraryUtils;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.deploy.event.VetoableDeploymentEvent;
import weblogic.deploy.event.VetoableDeploymentListener;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class LibraryDeploymentListener
implements VetoableDeploymentListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void vetoableApplicationActivate(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentVetoException {
        ServerRuntimeMBean serverRuntimeMBean;
        if (!(vetoableDeploymentEvent.getAppDeployment() instanceof LibraryMBean)) {
            return;
        }
        if (vetoableDeploymentEvent.isNewAppDeployment() || vetoableDeploymentEvent.isStaticAppDeployment()) {
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("First or static deploy " + vetoableDeploymentEvent.getAppDeployment().getName());
            }
            return;
        }
        LibraryMBean libraryMBean = (LibraryMBean)vetoableDeploymentEvent.getAppDeployment();
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Got Library deploy notification: " + libraryMBean.getName());
        }
        if (!this.verifyServerName(vetoableDeploymentEvent, serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime(), libraryMBean)) {
            return;
        }
        this.verifyLibrary(libraryMBean, serverRuntimeMBean);
    }

    public void vetoableApplicationDeploy(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentVetoException {
        this.vetoableApplicationActivate(vetoableDeploymentEvent);
    }

    public void vetoableApplicationUndeploy(VetoableDeploymentEvent vetoableDeploymentEvent) throws DeploymentVetoException {
        ServerRuntimeMBean serverRuntimeMBean;
        if (!(vetoableDeploymentEvent.getAppDeployment() instanceof LibraryMBean)) {
            return;
        }
        LibraryMBean libraryMBean = (LibraryMBean)vetoableDeploymentEvent.getAppDeployment();
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Got Library undeploy notification: " + libraryMBean.getName());
        }
        if (!this.verifyServerName(vetoableDeploymentEvent, serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime(), libraryMBean)) {
            return;
        }
        this.verifyLibrary(libraryMBean, serverRuntimeMBean);
    }

    private boolean verifyServerName(VetoableDeploymentEvent vetoableDeploymentEvent, ServerRuntimeMBean serverRuntimeMBean, LibraryMBean libraryMBean) {
        String[] stringArray = vetoableDeploymentEvent.getTargets();
        if (stringArray == null) {
            stringArray = this.getAppTargets(libraryMBean.getTargets());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!serverRuntimeMBean.getName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void verifyLibrary(LibraryMBean libraryMBean, ServerRuntimeMBean serverRuntimeMBean) throws DeploymentVetoException {
        LibraryRuntimeMBean libraryRuntimeMBean;
        String string = libraryMBean.getName();
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Trying to get libruntimembean for lib " + string);
        }
        if ((libraryRuntimeMBean = serverRuntimeMBean.lookupLibraryRuntime(string)) == null) {
            return;
        }
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("is " + libraryRuntimeMBean.getName() + " used? " + libraryRuntimeMBean.isReferenced());
        }
        if (libraryRuntimeMBean.isReferenced()) {
            throw new DeploymentVetoException(this.formatErrorMessage(libraryRuntimeMBean, serverRuntimeMBean.getName()));
        }
    }

    private String formatErrorMessage(LibraryRuntimeMBean libraryRuntimeMBean, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cannot undeploy library ").append(LibraryUtils.toString(libraryRuntimeMBean.getLibraryName(), libraryRuntimeMBean.getSpecificationVersion(), libraryRuntimeMBean.getImplementationVersion())).append(" from server ").append(string).append(", because the following deployed applications reference it: ");
        String[] stringArray = libraryRuntimeMBean.getReferencingNames();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private String[] getAppTargets(TargetMBean[] targetMBeanArray) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            hashSet.addAll(targetMBeanArray[i].getServerNames());
        }
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Targets from TargetMBean: " + hashSet);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }
}

