/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.internal.library.LibraryRegistry;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.application.utils.PathUtils;
import weblogic.utils.FileUtils;

public final class LibraryInitializer {
    private static final LibraryRegistry libraryRegistry = LibraryRegistry.getRegistry();
    private final ApplicationFactoryManager libFactories;
    private final File baseExtractDir;
    private final Collection libdirs = new HashSet();
    private boolean verbose = false;
    private boolean silent = false;

    public LibraryInitializer() {
        this(new File(System.getProperty("java.io.tmpdir"), "libraries"), LibraryUtils.initStandardAppLibraryFactories());
    }

    public LibraryInitializer(File file) {
        this(file, LibraryUtils.initStandardAppLibraryFactories());
    }

    public LibraryInitializer(File file, ApplicationFactoryManager applicationFactoryManager) {
        this.baseExtractDir = file;
        this.libFactories = applicationFactoryManager;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void setSilent() {
        this.silent = true;
    }

    public Library[] getAllLibraries() {
        Collection<LibraryDefinition> collection = libraryRegistry.getAll();
        return collection.toArray(new Library[collection.size()]);
    }

    public void cleanup() {
        LibraryLoggingUtils.cleanupLibrariesAndRemove();
        FileUtils.remove((File)this.baseExtractDir);
    }

    public void registerLibrary(File file, LibraryData libraryData) throws LoggableLibraryProcessingException {
        LibraryLoggingUtils.checkLibraryExists(file);
        LibraryData libraryData2 = LibraryLoggingUtils.initLibraryData(file);
        libraryData2 = LibraryInitializer.mergeData(libraryData2, libraryData, file);
        LibraryDefinition libraryDefinition = this.getLibraryDefinition(libraryData2);
        LibraryLoggingUtils.registerLibrary(libraryDefinition, this.verbose);
    }

    public void initRegisteredLibraries() throws LoggableLibraryProcessingException {
        Collection<LibraryDefinition> collection = libraryRegistry.getAll();
        for (LibraryDefinition libraryDefinition : collection) {
            LibraryLoggingUtils.initLibraryDefinition(libraryDefinition);
        }
    }

    public void registerLibdir(String string) throws LoggableLibraryProcessingException {
        File file = new File(string);
        LibraryLoggingUtils.checkLibdirIsValid(file);
        try {
            if (!this.libdirs.add(file.getCanonicalFile())) {
                return;
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                this.registerLibrary(fileArray[i], LibraryData.newEmptyInstance(fileArray[i]));
                continue;
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                if (this.silent) continue;
                loggableLibraryProcessingException.getLoggable().log();
            }
        }
    }

    private LibraryDefinition getLibraryDefinition(LibraryData libraryData) throws LoggableLibraryProcessingException {
        File file = new File(this.baseExtractDir, PathUtils.generateTempPath(null, libraryData.getName(), libraryData.getSpecificationVersion() + libraryData.getImplementationVersion()));
        LibraryDefinition libraryDefinition = LibraryLoggingUtils.getLibraryDefinition(libraryData, file, this.libFactories.getLibraryFactories());
        return libraryDefinition;
    }

    private static LibraryData mergeData(LibraryData libraryData, LibraryData libraryData2, File file) throws LoggableLibraryProcessingException {
        if (libraryData2.getName() == null && libraryData.getName() == null) {
            libraryData2 = LibraryData.cloneWithNewName(LibraryInitializer.getName(file), libraryData2);
        }
        libraryData = libraryData.importData(libraryData2);
        libraryData2 = libraryData2.importData(libraryData);
        LibraryLoggingUtils.handleAppcLibraryInfoMismatch(libraryData, libraryData2, file);
        return libraryData;
    }

    private static String getName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        if (file.getName().indexOf(".") < 0) {
            return file.getName();
        }
        return file.getName().substring(0, file.getName().lastIndexOf("."));
    }
}

