/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import weblogic.application.Type;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.internal.library.LibraryRegistry;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryProvider;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LibraryReferencer;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.application.utils.XMLWriter;
import weblogic.management.runtime.LibraryRuntimeMBean;

public class LibraryManager
implements LibraryProvider {
    private static final LibraryRegistry libReg = LibraryRegistry.getRegistry();
    private final List libraries = new ArrayList();
    private final List resolvedRefs = new ArrayList();
    private final Collection unresolvedRefs = new ArrayList();
    private final Collection allRefs = new HashSet();
    private final Set libRefs = new HashSet();
    private final LibraryReferencer referencer;
    private final List<LibraryDefinition> autoRefLibs = new ArrayList<LibraryDefinition>();

    public LibraryManager(LibraryReferencer libraryReferencer) {
        this(libraryReferencer, null);
    }

    public LibraryManager(LibraryReferencer libraryReferencer, LibraryReference[] libraryReferenceArray) {
        if (libraryReferencer == null) {
            throw new IllegalArgumentException("null referencer not allowed");
        }
        this.lookup(libraryReferenceArray);
        this.referencer = libraryReferencer;
    }

    public void lookup(LibraryReference[] libraryReferenceArray) {
        if (libraryReferenceArray == null) {
            return;
        }
        for (int i = 0; i < libraryReferenceArray.length; ++i) {
            this.lookup(libraryReferenceArray[i]);
        }
    }

    private void lookup(LibraryReference libraryReference) {
        if (libraryReference == null) {
            return;
        }
        this.findReferencedLibraries(libraryReference);
    }

    private boolean isDuplicateRef(LibraryReference libraryReference) {
        if (this.allRefs.contains(libraryReference)) {
            return true;
        }
        this.allRefs.add(libraryReference);
        return false;
    }

    public Library[] getUnreferencedLibraries() {
        Collection<LibraryDefinition> collection = libReg.getAll();
        Iterator iterator = this.libraries.iterator();
        while (iterator.hasNext()) {
            collection.remove(iterator.next());
        }
        return collection.toArray(new Library[collection.size()]);
    }

    public boolean hasReferencedLibraries() {
        return !this.libraries.isEmpty();
    }

    public Library[] getReferencedLibraries() {
        return this.libraries.toArray(new Library[this.libraries.size()]);
    }

    public Library[] getAutoReferencedLibraries() {
        return this.autoRefLibs.toArray(new Library[this.autoRefLibs.size()]);
    }

    public LibraryReferencer getReferencer() {
        return this.referencer;
    }

    public void lookupAndAddAutoReferences(Type type, LibraryConstants.AutoReferrer autoReferrer) {
        Object object;
        Collection<LibraryDefinition> collection = libReg.getAll();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (LibraryDefinition object2 : collection) {
            boolean basicLibraryData = false;
            object = object2.getAutoRef();
            for (int i = 0; !basicLibraryData && i < ((LibraryConstants.AutoReferrer[])object).length; ++i) {
                basicLibraryData = object[i] == autoReferrer;
            }
            if (!basicLibraryData || type != null && !type.equals(object2.getType())) continue;
            if (this.libraries.contains(object2)) {
                if (!LibraryUtils.isDebugOn()) continue;
                LibraryUtils.debug("The auto-ref library: " + object2.getName() + " is explicitly referred");
                continue;
            }
            treeSet.add(object2.getName());
        }
        try {
            for (String string : treeSet) {
                BasicLibraryData basicLibraryData = new BasicLibraryData(string, (String)null, (String)null, type);
                object = libReg.lookup(new J2EELibraryReference(basicLibraryData, false, null));
                this.autoRefLibs.add((LibraryDefinition)object);
                ((LibraryDefinition)object).getRuntimeImpl().addReference(this.referencer);
            }
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            // empty catch block
        }
    }

    public void initializeReferencedLibraries() throws LoggableLibraryProcessingException {
        for (LibraryDefinition libraryDefinition : this.libraries) {
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("Calling init on " + libraryDefinition);
            }
            LibraryLoggingUtils.initLibraryDefinition(libraryDefinition);
        }
    }

    public LibraryReference[] getLibraryReferences() {
        return this.resolvedRefs.toArray(new LibraryReference[this.resolvedRefs.size()]);
    }

    public LibraryRuntimeMBean[] getReferencedLibraryRuntimes() {
        LibraryRuntimeMBean[] libraryRuntimeMBeanArray = new LibraryRuntimeMBean[this.libraries.size()];
        int n = this.libraries.size();
        for (int i = 0; i < n; ++i) {
            libraryRuntimeMBeanArray[i] = ((Library)this.libraries.get(i)).getRuntime();
        }
        return libraryRuntimeMBeanArray;
    }

    public boolean hasUnresolvedReferences() {
        return !this.unresolvedRefs.isEmpty();
    }

    public LibraryReference[] getUnresolvedReferences() {
        return this.unresolvedRefs.toArray(new LibraryReference[this.unresolvedRefs.size()]);
    }

    public void resetUnresolvedReferences() {
        this.unresolvedRefs.clear();
    }

    public String getUnresolvedReferencesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.unresolvedRefs.iterator();
        while (iterator.hasNext()) {
            LibraryReference libraryReference = (LibraryReference)iterator.next();
            stringBuffer.append("[").append(libraryReference.toString()).append("]");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public void getUnresolvedReferencesError(StringBuffer stringBuffer) {
        stringBuffer.append(this.referencer.getUnresolvedError()).append(" ").append(this.getUnresolvedReferencesAsString());
    }

    public String getUnresolvedReferencesError() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getUnresolvedReferencesError(stringBuffer);
        return stringBuffer.toString();
    }

    private void registerUnresolvedLibraryRef(LibraryReference libraryReference) {
        this.unresolvedRefs.add(libraryReference);
    }

    private void registerLibrary(LibraryReference libraryReference, Library library) {
        if (!this.libRefs.add(libraryReference.getCompositeEntry(library))) {
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("Ignoroning entry --> " + library.getLocation());
            }
            return;
        }
        this.resolvedRefs.add(libraryReference);
        this.libraries.add(library);
    }

    private void findReferencedLibraries(LibraryReference libraryReference) {
        if (this.isDuplicateRef(libraryReference)) {
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("Ignoring duplicate reference: " + libraryReference);
            }
            return;
        }
        LibraryDefinition libraryDefinition = libReg.lookup(libraryReference);
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Referenced library is " + libraryDefinition);
        }
        if (libraryDefinition == null) {
            this.registerUnresolvedLibraryRef(libraryReference);
            return;
        }
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Adding library to result list: " + libraryDefinition);
        }
        this.registerLibrary(libraryReference, libraryDefinition);
        LibraryReference[] libraryReferenceArray = libraryDefinition.getLibraryReferences();
        if (libraryReferenceArray != null) {
            for (int i = 0; i < libraryReferenceArray.length; ++i) {
                if (LibraryUtils.isDebugOn()) {
                    LibraryUtils.debug("Found library reference " + libraryReferenceArray[i]);
                }
                this.findReferencedLibraries(libraryReferenceArray[i]);
            }
        } else if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("This library does not reference other libraries");
        }
    }

    public void addReferences() {
        for (LibraryDefinition libraryDefinition : this.libraries) {
            libraryDefinition.getRuntimeImpl().addReference(this.referencer);
        }
    }

    public void removeReferences() {
        for (LibraryDefinition libraryDefinition : this.libraries) {
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("For library: " + libraryDefinition.getName());
            }
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("removing its ref to:" + this.referencer.getReferencerName());
            }
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("library runtime is: " + libraryDefinition.getRuntimeImpl());
            }
            libraryDefinition.getRuntimeImpl().removeReference(this.referencer);
        }
        for (LibraryDefinition libraryDefinition : this.autoRefLibs) {
            libraryDefinition.getRuntimeImpl().removeReference(this.referencer);
        }
        this.autoRefLibs.clear();
        this.libraries.clear();
        this.libRefs.clear();
    }

    public File[] getOptionalPackages(LibraryReference[] libraryReferenceArray) {
        if (libraryReferenceArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>(libraryReferenceArray.length);
        for (int i = 0; i < libraryReferenceArray.length; ++i) {
            LibraryDefinition libraryDefinition = libReg.lookup(libraryReferenceArray[i]);
            if (libraryDefinition != null) {
                arrayList.add(libraryDefinition.getLocation());
            }
            if (this.isDuplicateRef(libraryReferenceArray[i])) continue;
            if (libraryDefinition == null) {
                this.registerUnresolvedLibraryRef(libraryReferenceArray[i]);
                continue;
            }
            this.registerLibrary(libraryReferenceArray[i], libraryDefinition);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        if (this.libraries.isEmpty()) {
            return;
        }
        String string = this.referencer.getReferencerName();
        if (string == null) {
            string = "app";
        }
        xMLWriter.addElement("referencer");
        xMLWriter.addElement("name", string);
        int n = this.libraries.size();
        for (int i = 0; i < n; ++i) {
            Library library = (Library)this.libraries.get(i);
            LibraryReference libraryReference = (LibraryReference)this.resolvedRefs.get(i);
            xMLWriter.addElement("reference", libraryReference.toString());
            xMLWriter.addElement("library", library.toString());
        }
        xMLWriter.closeElement();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.libraries.isEmpty()) {
            stringBuffer.append("No libraries available\n");
        } else {
            stringBuffer.append("Available libraries ").append(this.libraries.toString());
        }
        if (this.unresolvedRefs.isEmpty()) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\n").append("Unresolved references ").append(this.unresolvedRefs.toString());
        return stringBuffer.toString();
    }
}

