/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import weblogic.application.library.CachableLibMetadata;
import weblogic.application.library.CachableLibMetadataEntry;
import weblogic.application.library.LibraryProcessingException;
import weblogic.utils.FileUtils;

public final class LibraryMetadataCache {
    private static final String CACHE_FILE = ".cache.ser";
    private static final LibraryMetadataCache INSTANCE = new LibraryMetadataCache();
    private Map cacheObjectMap = new HashMap();
    private boolean useCache = true;

    private LibraryMetadataCache() {
    }

    public static LibraryMetadataCache getInstance() {
        return INSTANCE;
    }

    public void disableCache() {
        this.useCache = false;
    }

    public void initLibraryCache(CachableLibMetadata cachableLibMetadata) throws LibraryProcessingException {
        if (!this.useCache) {
            return;
        }
        CachableLibMetadataEntry[] cachableLibMetadataEntryArray = cachableLibMetadata.findAllCachableEntry();
        for (int i = 0; i < cachableLibMetadataEntryArray.length; ++i) {
            this.lookupCachedObject(cachableLibMetadataEntryArray[i]);
        }
    }

    public void clearLibraryCache(CachableLibMetadata cachableLibMetadata) {
        if (!this.useCache) {
            return;
        }
        CachableLibMetadataEntry[] cachableLibMetadataEntryArray = cachableLibMetadata.findAllCachableEntry();
        for (int i = 0; i < cachableLibMetadataEntryArray.length; ++i) {
            File file = LibraryMetadataCache.getCacheFile(cachableLibMetadataEntryArray[i], false);
            this.cacheObjectMap.remove(file);
            LibraryMetadataCache.remove(cachableLibMetadataEntryArray[i]);
        }
    }

    public Object lookupCachedObject(CachableLibMetadataEntry cachableLibMetadataEntry) throws LibraryProcessingException {
        Object object;
        if (cachableLibMetadataEntry == null) {
            return null;
        }
        if (!this.useCache) {
            return cachableLibMetadataEntry.getCachableObject();
        }
        File file = LibraryMetadataCache.getCacheFile(cachableLibMetadataEntry, true);
        if (!LibraryMetadataCache.isStale(file, cachableLibMetadataEntry)) {
            object = this.cacheObjectMap.get(file);
            if (object != null) {
                return object;
            }
            try {
                Object object2 = LibraryMetadataCache.readObject(file);
                this.cacheObjectMap.put(file, object2);
                return object2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file.exists()) {
            file.delete();
        }
        object = cachableLibMetadataEntry.getCachableObject();
        try {
            LibraryMetadataCache.writeObject(file, object);
        }
        catch (IOException iOException) {
            file.delete();
        }
        this.cacheObjectMap.put(file, object);
        return object;
    }

    private static void remove(CachableLibMetadataEntry cachableLibMetadataEntry) {
        File file = LibraryMetadataCache.getCacheDir(cachableLibMetadataEntry);
        if (!file.exists()) {
            return;
        }
        FileUtils.remove((File)file);
    }

    public static File getCacheDir(CachableLibMetadataEntry cachableLibMetadataEntry) {
        return new File(cachableLibMetadataEntry.getLocation(), cachableLibMetadataEntry.getType().getName());
    }

    private static File getCacheFile(CachableLibMetadataEntry cachableLibMetadataEntry, boolean bl) {
        File file = LibraryMetadataCache.getCacheDir(cachableLibMetadataEntry);
        if (!file.exists() && bl) {
            file.mkdirs();
        }
        return new File(file, CACHE_FILE);
    }

    private static boolean isStale(File file, CachableLibMetadataEntry cachableLibMetadataEntry) {
        return !file.exists() || cachableLibMetadataEntry.isStale(file.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object;
        block5: {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(file));
                object = objectInputStream.readObject();
                Object var4_3 = null;
                if (objectInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (objectInputStream == null) break block6;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeObject(File file, Object object) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(object);
            Object var4_3 = null;
            if (objectOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (objectOutputStream == null) throw throwable;
            try {
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

