/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.io.File;
import weblogic.application.Type;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.library.Library;

public abstract class LibraryReference {
    private final BasicLibraryData libData;
    private final boolean exactMatch;

    protected LibraryReference(BasicLibraryData basicLibraryData, boolean bl, Type type) {
        this(basicLibraryData, bl);
        this.libData.setType(type);
    }

    protected LibraryReference(BasicLibraryData basicLibraryData, boolean bl) {
        this.libData = basicLibraryData;
        this.exactMatch = bl;
    }

    public String getName() {
        return this.libData.getName();
    }

    public String getSpecificationVersion() {
        if (this.libData.getSpecificationVersion() == null) {
            return null;
        }
        return this.libData.getSpecificationVersion().toString();
    }

    public String getImplementationVersion() {
        return this.libData.getImplementationVersion();
    }

    public Type getType() {
        return this.libData.getType();
    }

    public boolean getExactMatch() {
        return this.exactMatch;
    }

    public BasicLibraryData getLibData() {
        return this.libData;
    }

    protected abstract void moreToString(StringBuffer var1);

    public int hashCode() {
        return String.valueOf(this.getName()).hashCode() ^ String.valueOf(this.getSpecificationVersion()).hashCode() ^ String.valueOf(this.getImplementationVersion()).hashCode() ^ String.valueOf(this.exactMatch).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LibraryReference)) {
            return false;
        }
        LibraryReference libraryReference = (LibraryReference)object;
        return this.getName().equals(libraryReference.getName()) && String.valueOf(this.getSpecificationVersion()).equals(String.valueOf(libraryReference.getSpecificationVersion())) && String.valueOf(libraryReference.getImplementationVersion()).equals(String.valueOf(libraryReference.getImplementationVersion())) && this.exactMatch == libraryReference.exactMatch;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.libData.toString());
        this.moreToString(stringBuffer);
        return stringBuffer.toString();
    }

    LibEntry getCompositeEntry(Library library) {
        return new LibEntry(library.getLocation());
    }

    static class LibEntry {
        protected File location;

        LibEntry(File file) {
            this.location = file;
        }

        public boolean equals(Object object) {
            if (this.getClass() != object.getClass() && !(object instanceof LibEntry)) {
                return false;
            }
            LibEntry libEntry = (LibEntry)object;
            return this.location.equals(libEntry.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }
    }
}

