/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.Attributes;
import weblogic.application.Type;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.internal.library.LibraryRegistry;
import weblogic.application.internal.library.OptionalPackageReference;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryReference;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.utils.StringUtils;

public final class LibraryReferenceFactory {
    private LibraryReferenceFactory() {
    }

    public static J2EELibraryReference[] getAppLibReference() {
        return LibraryReferenceFactory.getAppLibReference(LibraryRegistry.getRegistry());
    }

    public static J2EELibraryReference[] getAppLibReference(LibraryRegistry libraryRegistry) {
        return LibraryReferenceFactory.getMatchingJ2EELibRefs(libraryRegistry, ApplicationLibrary.class, null);
    }

    public static J2EELibraryReference[] getWebAppLibReference() {
        return LibraryReferenceFactory.getMatchingJ2EELibRefs(LibraryRegistry.getRegistry(), Type.WAR);
    }

    public static J2EELibraryReference[] getWebAppLibReference(LibraryRegistry libraryRegistry) {
        return LibraryReferenceFactory.getMatchingJ2EELibRefs(libraryRegistry, Type.WAR);
    }

    private static J2EELibraryReference[] getMatchingJ2EELibRefs(LibraryRegistry libraryRegistry, Type type) {
        return LibraryReferenceFactory.getMatchingJ2EELibRefs(libraryRegistry, Library.class, type);
    }

    private static J2EELibraryReference[] getMatchingJ2EELibRefs(LibraryRegistry libraryRegistry, Class clazz, Type type) {
        if (clazz == null) {
            throw new IllegalArgumentException("libCategory cannot be null");
        }
        ArrayList<J2EELibraryReference> arrayList = new ArrayList<J2EELibraryReference>();
        Collection<LibraryDefinition> collection = libraryRegistry.getAll();
        for (Library library : collection) {
            if (!clazz.isAssignableFrom(library.getClass())) continue;
            try {
                BasicLibraryData basicLibraryData = new BasicLibraryData(library.getName(), library.getSpecificationVersion(), library.getImplementationVersion(), type);
                arrayList.add(new J2EELibraryReference(basicLibraryData, true, null));
            }
            catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
                throw new AssertionError((Object)illegalSpecVersionTypeException);
            }
        }
        return arrayList.toArray(new J2EELibraryReference[arrayList.size()]);
    }

    public static J2EELibraryReference[] getAppLibReference(LibraryRefBean[] libraryRefBeanArray) throws IllegalSpecVersionTypeException {
        return LibraryReferenceFactory.getReference(libraryRefBeanArray, null);
    }

    public static J2EELibraryReference[] getWebLibReference(LibraryRefBean[] libraryRefBeanArray) throws IllegalSpecVersionTypeException {
        return LibraryReferenceFactory.getReference(libraryRefBeanArray, Type.WAR);
    }

    public static LibraryReference[] getOptPackReference(String string, Attributes attributes) {
        String string2 = attributes.getValue(Attributes.Name.EXTENSION_LIST);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string2, (String)" ");
        ArrayList<OptionalPackageReference> arrayList = new ArrayList<OptionalPackageReference>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray[i].trim();
            if (string4.length() == 0) continue;
            String string5 = attributes.getValue(string4 + "-" + Attributes.Name.EXTENSION_NAME);
            if (string5 == null) {
                LibraryLoggingUtils.warnMissingExtensionName(string4, string);
                continue;
            }
            String string6 = attributes.getValue(stringArray[i] + "-" + Attributes.Name.SPECIFICATION_VERSION);
            BasicLibraryData basicLibraryData = LibraryLoggingUtils.initOptionalPackageRefLibData(string5, string6, string3 = attributes.getValue(stringArray[i] + "-" + Attributes.Name.IMPLEMENTATION_VERSION), string);
            if (basicLibraryData == null) continue;
            arrayList.add(new OptionalPackageReference(basicLibraryData, string));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new OptionalPackageReference[arrayList.size()]);
    }

    private static J2EELibraryReference[] getReference(LibraryRefBean[] libraryRefBeanArray, Type type) throws IllegalSpecVersionTypeException {
        if (libraryRefBeanArray == null) {
            return null;
        }
        J2EELibraryReference[] j2EELibraryReferenceArray = new J2EELibraryReference[libraryRefBeanArray.length];
        for (int i = 0; i < libraryRefBeanArray.length; ++i) {
            BasicLibraryData basicLibraryData = new BasicLibraryData(libraryRefBeanArray[i].getLibraryName(), libraryRefBeanArray[i].getSpecificationVersion(), libraryRefBeanArray[i].getImplementationVersion(), type);
            j2EELibraryReferenceArray[i] = new J2EELibraryReference(basicLibraryData, libraryRefBeanArray[i].getExactMatch(), libraryRefBeanArray[i].getContextRoot());
        }
        return j2EELibraryReferenceArray;
    }
}

