/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JamService;
import com.bea.util.jam.JamServiceFactory;
import com.bea.util.jam.JamServiceParams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.jars.VirtualJarFile;

public class AnnotationDetector {
    private final MetaDataFilter filter;
    private static final DebugCategory debug = Debug.getCategory((String)"weblogic.application.annotationdetector.debug");
    private final Class[] annotations;

    public AnnotationDetector(Class[] classArray) {
        this.annotations = classArray;
        this.filter = new ClassAnnotationMetaDataFilter(classArray);
    }

    public AnnotationDetector(Class clazz) {
        this.annotations = new Class[]{clazz};
        this.filter = new ClassAnnotationMetaDataFilter(clazz);
    }

    public boolean isAnnotated(ZipFile zipFile) throws IOException {
        Enumeration<? extends ZipEntry> enumeration;
        Enumeration<? extends ZipEntry> enumeration2 = enumeration = zipFile == null ? null : zipFile.entries();
        if (enumeration == null) {
            return false;
        }
        Resource resource = new Resource(zipFile);
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            if (debug.isEnabled()) {
                Debug.say((String)("Scanning annotations in archive " + zipFile.getName() + " entry " + zipEntry.getName()));
            }
            resource.setEntry(zipEntry);
            if (!this.filter.matches((MetaDataFilter.Resource)resource)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnnotated(VirtualJarFile virtualJarFile) throws IOException {
        Iterator iterator;
        Iterator iterator2 = iterator = virtualJarFile == null ? null : virtualJarFile.entries();
        if (iterator == null) {
            return false;
        }
        return this.isAnnotated(virtualJarFile, iterator);
    }

    public boolean isAnnotated(VirtualJarFile virtualJarFile, Iterator iterator) throws IOException {
        Resource resource = new Resource(virtualJarFile);
        while (iterator.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)iterator.next();
            if (debug.isEnabled()) {
                Debug.say((String)("Scanning annotations in archive " + virtualJarFile.getName() + " entry " + zipEntry.getName()));
            }
            resource.setEntry(zipEntry);
            if (!this.filter.matches((MetaDataFilter.Resource)resource)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnnotated(File file) throws IOException {
        if (debug.isEnabled()) {
            Debug.say((String)("Recursively scanning annotations in directory " + file.getName()));
        }
        return this.scan(file, this.filter, new FileResource());
    }

    private boolean scan(File file, MetaDataFilter metaDataFilter, FileResource fileResource) throws IOException {
        if (debug.isEnabled()) {
            Debug.say((String)("Scanning annotations in file " + file.getName()));
        }
        fileResource.setFile(file);
        if (metaDataFilter.matches((MetaDataFilter.Resource)fileResource)) {
            return true;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!this.scan(fileArray[i], metaDataFilter, fileResource)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnnotatedSources(File file) throws IOException {
        JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
        JamServiceParams jamServiceParams = jamServiceFactory.createServiceParams();
        this.includeSources(file, jamServiceParams);
        JamService jamService = jamServiceFactory.createService(jamServiceParams);
        JClass[] jClassArray = jamService.getAllClasses();
        if (jClassArray == null) {
            return false;
        }
        for (int i = 0; i < jClassArray.length; ++i) {
            if (!this.hasAnnotation(jClassArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(JClass jClass) throws IOException {
        for (int i = 0; i < this.annotations.length; ++i) {
            if (jClass.getAnnotation(this.annotations[i]) == null) continue;
            return true;
        }
        return false;
    }

    private void includeSources(File file, JamServiceParams jamServiceParams) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.isJavaSource(fileArray[i])) {
                jamServiceParams.includeSourceFile(fileArray[i]);
                continue;
            }
            this.includeSources(fileArray[i], jamServiceParams);
        }
    }

    private boolean isJavaSource(File file) {
        return file.getName().endsWith(".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAnnotated(ZipInputStream zipInputStream) throws IOException {
        Resource resource = new Resource(zipInputStream);
        ZipEntry zipEntry = null;
        while (true) {
            Object var6_4;
            block6: {
                boolean bl;
                block7: {
                    block5: {
                        if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                            return false;
                        }
                        try {
                            if (zipEntry.isDirectory()) {
                                var6_4 = null;
                                break block5;
                            }
                            resource.setEntry(zipEntry);
                            if (!this.filter.matches((MetaDataFilter.Resource)resource)) break block6;
                            bl = true;
                            break block7;
                        }
                        catch (Throwable throwable) {
                            var6_4 = null;
                            zipInputStream.closeEntry();
                            throw throwable;
                        }
                    }
                    zipInputStream.closeEntry();
                    continue;
                }
                var6_4 = null;
                zipInputStream.closeEntry();
                return bl;
            }
            var6_4 = null;
            zipInputStream.closeEntry();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("Usage AnnotationScanner <file>");
            System.exit(-1);
        }
        AnnotationDetector annotationDetector = new AnnotationDetector(new Class[]{Class.forName("javax.ejb.MessageDriven"), Class.forName("javax.ejb.Stateful"), Class.forName("javax.ejb.Stateless")});
        System.out.println("Do we have annotations in the module? " + annotationDetector.isAnnotated(new ZipFile(stringArray[0])));
    }

    public static class FileResource
    implements MetaDataFilter.Resource {
        private File _file = null;

        public void setFile(File file) {
            this._file = file;
        }

        public String getName() {
            return this._file.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getContent() throws IOException {
            Object object;
            long l = this._file.length();
            FileInputStream fileInputStream = new FileInputStream(this._file);
            try {
                byte[] byArray;
                if (l <= 0L) {
                    int n;
                    object = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[1024];
                    while ((n = fileInputStream.read(byArray2)) != -1) {
                        ((ByteArrayOutputStream)object).write(byArray2, 0, n);
                    }
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                } else {
                    int n;
                    byArray = new byte[(int)l];
                    int n2 = 0;
                    int n3 = (int)l;
                    while ((n = fileInputStream.read(byArray, n2, n3 - n2)) > 0 && (n2 += n) != n3) {
                    }
                }
                object = byArray;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return object;
        }
    }

    private static class Resource
    implements MetaDataFilter.Resource {
        private final ZipFile _file;
        private final VirtualJarFile _vjf;
        private final ZipInputStream zip;
        private ZipEntry _entry = null;

        public Resource(ZipFile zipFile) {
            this._file = zipFile;
            this._vjf = null;
            this.zip = null;
        }

        public Resource(VirtualJarFile virtualJarFile) {
            this._file = null;
            this._vjf = virtualJarFile;
            this.zip = null;
        }

        public Resource(ZipInputStream zipInputStream) {
            this.zip = zipInputStream;
            this._file = null;
            this._vjf = null;
        }

        public void setEntry(ZipEntry zipEntry) {
            this._entry = zipEntry;
        }

        public String getName() {
            return this._entry.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public byte[] getContent() throws IOException {
            long l = this._entry.getSize();
            if (l == 0L) {
                return new byte[0];
            }
            byte[] byArray = null;
            InputStream inputStream = null;
            try {
                if (this._file != null) {
                    inputStream = this._file.getInputStream(this._entry);
                } else if (this._vjf != null) {
                    inputStream = this._vjf.getInputStream(this._entry);
                } else if (this.zip != null) {
                    inputStream = this.zip;
                }
                if (l < 0L) {
                    int n;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[1024];
                    while ((n = inputStream.read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                } else {
                    int n;
                    byArray = new byte[(int)l];
                    int n2 = 0;
                    int n3 = (int)l;
                    while ((n = inputStream.read(byArray, n2, n3 - n2)) > 0) {
                        if ((n2 += n) != n3) continue;
                        break;
                    }
                }
                Object var9_10 = null;
                if (this.zip != null || inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (this.zip != null || inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {}
            return byArray;
        }
    }
}

