/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import weblogic.application.ModuleException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.DirectoryClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.EmptyEnumerator;

public final class AppFileOverrideUtils {
    private static final String OVERRIDE_SUBDIRECTORY = "AppFileOverrides";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDeployment");

    private AppFileOverrideUtils() {
    }

    public static void addFinderIfRequired(AppDeploymentMBean appDeploymentMBean, GenericClassLoader genericClassLoader) throws ModuleException {
        if (appDeploymentMBean == null || genericClassLoader == null || appDeploymentMBean.getLocalPlanDir() == null) {
            return;
        }
        File file = new File(appDeploymentMBean.getLocalPlanDir(), OVERRIDE_SUBDIRECTORY);
        if (!file.isDirectory()) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Application File Override is not enabled for " + appDeploymentMBean.getApplicationName());
            }
            return;
        }
        try {
            String string = null;
            if (DEBUG.isDebugEnabled()) {
                string = appDeploymentMBean.getLocalPlanDir() + File.separator + OVERRIDE_SUBDIRECTORY;
                DEBUG.debug("Application File Overrides enabled for " + appDeploymentMBean.getApplicationName() + ", overrides located at: " + string);
            }
            genericClassLoader.addClassFinderFirst((ClassFinder)new AppFileOverrideFinder((ClassFinder)new DirectoryClassFinder(file), string));
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException);
        }
    }

    public static ClassFinder getFinderIfRequired(AppDeploymentMBean appDeploymentMBean, String string) throws ModuleException {
        if (appDeploymentMBean == null || appDeploymentMBean.getLocalPlanDir() == null) {
            return null;
        }
        File file = string == null ? new File(appDeploymentMBean.getLocalPlanDir(), OVERRIDE_SUBDIRECTORY) : new File(appDeploymentMBean.getLocalPlanDir() + File.separator + OVERRIDE_SUBDIRECTORY, string);
        if (!file.isDirectory()) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Application File Override is not enabled for " + appDeploymentMBean.getApplicationName() + (string == null ? "" : ", moduleURI: " + string));
            }
            return null;
        }
        try {
            String string2 = null;
            if (DEBUG.isDebugEnabled()) {
                string2 = appDeploymentMBean.getLocalPlanDir() + File.separator + OVERRIDE_SUBDIRECTORY + (string == null ? "" : File.separator + string);
                DEBUG.debug("Application File Override finder returned for " + appDeploymentMBean.getApplicationName() + ", overrides located at: " + string2);
            }
            return new AppFileOverrideFinder((ClassFinder)new DirectoryClassFinder(file), string2);
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException);
        }
    }

    private static final class AppFileOverrideFinder
    implements ClassFinder {
        private ClassFinder delegate;
        private String debugDir;

        public AppFileOverrideFinder(ClassFinder classFinder, String string) {
            this.delegate = classFinder;
            this.debugDir = string;
        }

        public Source getSource(String string) {
            if (string.endsWith(".class")) {
                return null;
            }
            Source source = this.delegate.getSource(string);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("getSource(" + string + ") found " + source);
                if (this.debugDir != null) {
                    File file = new File(this.debugDir + File.separator + string);
                    DEBUG.debug(" resource file: " + this.debugDir + File.separator + string + ", exists = " + file.exists());
                }
            }
            return source;
        }

        public Enumeration getSources(String string) {
            if (string.endsWith(".class")) {
                return EmptyEnumerator.EMPTY;
            }
            return this.delegate.getSources(string);
        }

        public Source getClassSource(String string) {
            return null;
        }

        public String getClassPath() {
            return "";
        }

        public ClassFinder getManifestFinder() {
            return NullClassFinder.NULL_FINDER;
        }

        public Enumeration entries() {
            return EmptyEnumerator.EMPTY;
        }

        public void close() {
            this.delegate.close();
        }
    }
}

