/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFileManager;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.J2EELogger;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.StringWorkContext;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public final class ApplicationVersionUtils {
    private static final String DELIMITER = "#";
    private static final String LIB_DELIMITER = "@";
    public static final int MAX_VERSION_ID_LENGTH = 215;
    private static final String versionIdCharsRegExpr = "[\\w\\.\\-\\_]*";
    private static final String[] invalidVersionIdStrings = new String[]{".", ".."};
    private static final WorkContextMap workCtxMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int defaultPropagationMode = 214;
    private static final int adminModePropagationMode = 150;
    private static final ApplicationAccess applicationAccess = ApplicationAccess.getApplicationAccess();
    private static final AppRuntimeStateManager appRTStateMgr = AppRuntimeStateManager.getManager();
    private static final String APP_CTX_BIND_APPLICATION_ID = "weblogic.BindApplicationId";
    private static final String APP_CTX_APPNAME_PREFIX = "weblogic.app.";
    private static final String APP_CTX_ADMIN_MODE = "weblogic.app.internal.AdminMode";
    private static final String APP_VERSION_MANIFEST_ATTR_NAME = "Weblogic-Application-Version";
    private static final String LIB_NAME_MANIFEST_ATTR_NAME = "Extension-Name";
    private static final String LIB_SPEC_VER_MANIFEST_ATTR_NAME = "Specification-Version";
    private static final String LIB_IMPL_VER_MANIFEST_ATTR_NAME = "Implementation-Version";
    private static final String ADMIN_MODE = "weblogic.app.adminMode";
    private static final boolean defaultAdminMode = false;
    private static final String IGNORE_SESSIONS = "weblogic.app.ignoreSessions";
    private static final boolean defaultIgnoreSessions = false;
    private static final String RMI_GRACE_PERIOD = "weblogic.app.rmiGracePeriod";
    private static final int defaultRMIGracePeriod = 30;
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");

    private static String getFirstToken(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string3 = string.substring(0, n);
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    private static String getSecondToken(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(n + 1);
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    public static String getNonVersionedName(String string) {
        return ApplicationVersionUtils.getFirstToken(string, DELIMITER);
    }

    public static String getApplicationName(String string) {
        return ApplicationVersionUtils.getNonVersionedName(string);
    }

    public static String getVersionId(String string) {
        return ApplicationVersionUtils.getSecondToken(string, DELIMITER);
    }

    public static String getArchiveVersion(String string) {
        return ApplicationVersionUtils.getFirstToken(string, DELIMITER);
    }

    public static String getArchiveVersion(AppDeploymentMBean appDeploymentMBean) {
        return ApplicationVersionUtils.getArchiveVersion(appDeploymentMBean.getVersionIdentifier());
    }

    public static String getPlanVersion(String string) {
        return ApplicationVersionUtils.getSecondToken(string, DELIMITER);
    }

    public static String getPlanVersion(AppDeploymentMBean appDeploymentMBean) {
        return ApplicationVersionUtils.getPlanVersion(appDeploymentMBean.getVersionIdentifier());
    }

    public static String getApplicationId(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + DELIMITER + string2;
    }

    public static String getVersionId(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + DELIMITER + string2;
    }

    public static String getLibVersionId(String string, String string2) {
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string + LIB_DELIMITER + string2;
    }

    public static String getLibSpecVersion(String string) {
        return ApplicationVersionUtils.getFirstToken(string, LIB_DELIMITER);
    }

    public static String getLibImplVersion(String string) {
        return ApplicationVersionUtils.getSecondToken(string, LIB_DELIMITER);
    }

    public static boolean isLibraryVersion(String string) {
        return string != null && string.indexOf(LIB_DELIMITER) != -1;
    }

    public static void setCurrentVersionId(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        try {
            workCtxMap.put(ApplicationVersionUtils.getWorkCtxAppName(string), PrimitiveContextFactory.create((String)string2), 214);
            if (DEBUG_APP_VERSION.isEnabled()) {
                Debug.say((String)("*** setCurrentVersionId(appName=" + string + ", versionId=" + string2 + ")"));
            }
        }
        catch (PropertyReadOnlyException propertyReadOnlyException) {
            Debug.assertion((boolean)false, (String)("WorkContext property for '" + string + "' is read-only"));
        }
    }

    public static void setCurrentVersionId(String string) {
        String string2 = ApplicationVersionUtils.getApplicationName(string);
        String string3 = ApplicationVersionUtils.getVersionId(string);
        ApplicationVersionUtils.setCurrentVersionId(string2, string3);
    }

    private static String getWorkCtxAppName(String string) {
        return APP_CTX_APPNAME_PREFIX + string;
    }

    public static void setCurrentAdminMode(boolean bl) {
        try {
            workCtxMap.put(APP_CTX_ADMIN_MODE, PrimitiveContextFactory.create((String)Boolean.toString(bl)), 150);
            if (DEBUG_APP_VERSION.isEnabled()) {
                Debug.say((String)("*** setAdminMode(adminMode=" + bl + ")"));
            }
        }
        catch (PropertyReadOnlyException propertyReadOnlyException) {
            Debug.assertion((boolean)false, (String)"WorkContext property for AdminMode is read-only");
        }
    }

    public static void unsetCurrentVersionId(String string) {
        String string2 = ApplicationVersionUtils.getApplicationName(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        String string3 = ApplicationVersionUtils.getWorkCtxAppName(string2);
        if (workCtxMap.isEmpty() || workCtxMap.get(string3) == null) {
            return;
        }
        try {
            workCtxMap.remove(string3);
            if (DEBUG_APP_VERSION.isEnabled()) {
                Debug.say((String)("*** unsetCurrentVersionId(appName=" + string2 + ")"));
            }
        }
        catch (PropertyReadOnlyException propertyReadOnlyException) {
            Debug.assertion((boolean)false, (String)("WorkContext property for '" + string2 + "' is read-only"));
        }
        catch (NoWorkContextException noWorkContextException) {
            Debug.assertion((boolean)false, (String)"No WorkContext is available");
        }
    }

    public static void unsetCurrentAdminMode() {
        if (workCtxMap.isEmpty() || workCtxMap.get(APP_CTX_ADMIN_MODE) == null) {
            return;
        }
        try {
            workCtxMap.remove(APP_CTX_ADMIN_MODE);
            if (DEBUG_APP_VERSION.isEnabled()) {
                Debug.say((String)"*** unsetAdminMode");
            }
        }
        catch (PropertyReadOnlyException propertyReadOnlyException) {
            Debug.assertion((boolean)false, (String)"WorkContext property for AdminMode is read-only");
        }
        catch (NoWorkContextException noWorkContextException) {
            Debug.assertion((boolean)false, (String)"No WorkContext is available");
        }
    }

    public static String getCurrentVersionId(String string) {
        String string2;
        String string3;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (!workCtxMap.isEmpty() && (string3 = workCtxMap.get(ApplicationVersionUtils.getWorkCtxAppName(string))) != null && string3 instanceof StringWorkContext && (string2 = ((StringWorkContext)string3).toString()).length() > 0) {
            return string2;
        }
        string3 = ApplicationVersionUtils.getCurrentApplicationId();
        if (string3 == null) {
            return null;
        }
        string2 = ApplicationVersionUtils.getApplicationName(string3);
        if (string.equals(string2)) {
            return ApplicationVersionUtils.getVersionId(string3);
        }
        return null;
    }

    public static String getCurrentVersionId() {
        String string = applicationAccess.getCurrentApplicationName();
        return ApplicationVersionUtils.getVersionId(string);
    }

    public static String getCurrentApplicationId() {
        return applicationAccess.getCurrentApplicationName();
    }

    public static boolean getCurrentAdminMode() {
        if (workCtxMap.isEmpty()) {
            return false;
        }
        boolean bl = false;
        WorkContext workContext = workCtxMap.get(APP_CTX_ADMIN_MODE);
        if (workContext != null && workContext instanceof StringWorkContext) {
            bl = Boolean.valueOf(((StringWorkContext)workContext).toString());
        }
        return bl;
    }

    public static boolean isAdminModeRequest() {
        boolean bl;
        boolean bl2;
        boolean bl3 = ApplicationVersionUtils.getCurrentAdminMode();
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isAdminRequest(): isAdminModeSet : " + bl3));
        }
        if (bl3) {
            return true;
        }
        ServerChannel serverChannel = ServerHelper.getServerChannel();
        boolean bl4 = bl2 = serverChannel != null && ChannelHelper.isAdminChannel((ServerChannel)serverChannel);
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isAdminRequest(): isAdminChannel() : " + bl2));
        }
        if (bl2) {
            return true;
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        boolean bl5 = SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)authenticatedSubject);
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isAdminRequest(): doesUserHaveAnyAdminRoles('" + authenticatedSubject + "') : " + bl5));
        }
        if (bl5) {
            return true;
        }
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getCurrentApplicationRuntime();
        boolean bl6 = bl = applicationRuntimeMBean != null && applicationRuntimeMBean.getActiveVersionState() == 1;
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isAdminRequest(): isRequestedAppAdminMode() : " + bl));
        }
        if (bl) {
            return true;
        }
        boolean bl7 = ApplicationVersionUtils.getAdminModeAppCtxParam(applicationAccess.getCurrentApplicationContext());
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isAdminRequest(): hasAdminModeCtxParam() : " + bl7));
        }
        return bl7;
    }

    public static String getActiveVersionId(String string, boolean bl) {
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(ApplicationVersionUtils.getDomain(), string, bl);
        if (appDeploymentMBean == null) {
            return null;
        }
        return appDeploymentMBean.getVersionIdentifier();
    }

    public static String getActiveVersionId(String string) {
        return ApplicationVersionUtils.getActiveVersionId(string, false);
    }

    public static String getActiveVersionId() {
        String string = applicationAccess.getCurrentApplicationName();
        return ApplicationVersionUtils.getActiveVersionId(ApplicationVersionUtils.getApplicationName(string));
    }

    public static String getDisplayName(String string, String string2) {
        if (string == null) {
            return "";
        }
        String string3 = string;
        if (string2 != null) {
            string3 = string3 + " " + ApplicationVersionUtils.getDisplayVersionId(string2);
        }
        return string3;
    }

    public static String getDisplayName(BasicDeploymentMBean basicDeploymentMBean) {
        if (basicDeploymentMBean == null) {
            return "";
        }
        if (basicDeploymentMBean instanceof AppDeploymentMBean) {
            return ApplicationVersionUtils.getAppDeploymentDisplayName((AppDeploymentMBean)basicDeploymentMBean);
        }
        return ApplicationVersionUtils.getSystemResourceDisplayName((SystemResourceMBean)basicDeploymentMBean);
    }

    private static String getSystemResourceDisplayName(SystemResourceMBean systemResourceMBean) {
        return ApplicationVersionUtils.getDisplayName(systemResourceMBean.getName(), null);
    }

    private static String getAppDeploymentDisplayName(AppDeploymentMBean appDeploymentMBean) {
        return ApplicationVersionUtils.getDisplayName(appDeploymentMBean.getApplicationName(), appDeploymentMBean.getVersionIdentifier());
    }

    public static String getDisplayName(String string) {
        if (string == null) {
            return "";
        }
        String string2 = ApplicationVersionUtils.getApplicationName(string);
        String string3 = ApplicationVersionUtils.getVersionId(string);
        return ApplicationVersionUtils.getDisplayName(string2, string3);
    }

    public static String getDisplayVersionId(String string) {
        if (string == null) {
            return "";
        }
        String string2 = null;
        String string3 = ApplicationVersionUtils.getArchiveVersion(string);
        String string4 = ApplicationVersionUtils.getPlanVersion(string);
        if (ApplicationVersionUtils.isLibraryVersion(string3)) {
            String string5 = ApplicationVersionUtils.getLibSpecVersion(string3);
            String string6 = ApplicationVersionUtils.getLibImplVersion(string3);
            if (string5 != null) {
                string2 = "[LibSpecVersion=" + string5;
            }
            if (string6 != null) {
                if (string2 == null) {
                    string2 = "[";
                }
                string2 = string2 + ",LibImplVersion=" + string6;
            }
        } else {
            string2 = string4 == null ? "[Version=" + string3 : "[ArchiveVersion=" + string3;
        }
        if (string4 != null) {
            string2 = string2 + ",PlanVersion=" + string4;
        }
        if (string2 != null) {
            string2 = string2 + "]";
        }
        return string2;
    }

    public static String replaceDelimiter(String string, char c) {
        if (string == null) {
            return null;
        }
        return string.replace(DELIMITER.charAt(0), c);
    }

    public static boolean isSameComponent(String string, String string2, String string3, String string4) {
        if (string == null || string.length() == 0) {
            return string3 == null || string3.length() == 0;
        }
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        String string5 = DELIMITER;
        String string6 = DELIMITER;
        if (string2 != null && string2.length() > 0) {
            string5 = string5 + string2;
        }
        if (string4 != null && string4.length() > 0) {
            string6 = string6 + string4;
        }
        return string.replaceAll(string5, string6).equals(string3);
    }

    public static void setBindApplicationId(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            workCtxMap.put(APP_CTX_BIND_APPLICATION_ID, PrimitiveContextFactory.create((String)string));
            if (DEBUG_APP_VERSION.isEnabled()) {
                Debug.say((String)("*** setBindAppId(appId=" + string + ")"));
            }
        }
        catch (PropertyReadOnlyException propertyReadOnlyException) {
            Debug.assertion((boolean)false, (String)"WorkContext property for BindApplicationId is read-only");
        }
    }

    public static void unsetBindApplicationId() {
        if (workCtxMap.isEmpty() || workCtxMap.get(APP_CTX_BIND_APPLICATION_ID) == null) {
            return;
        }
        try {
            workCtxMap.remove(APP_CTX_BIND_APPLICATION_ID);
            if (DEBUG_APP_VERSION.isEnabled()) {
                Debug.say((String)"*** unsetBindAppId");
            }
        }
        catch (PropertyReadOnlyException propertyReadOnlyException) {
            Debug.assertion((boolean)false, (String)"WorkContext property for BindApplicationId is read-only");
        }
        catch (NoWorkContextException noWorkContextException) {
            Debug.assertion((boolean)false, (String)"No WorkContext is available");
        }
    }

    public static String getBindApplicationId() {
        if (workCtxMap.isEmpty()) {
            return null;
        }
        WorkContext workContext = workCtxMap.get(APP_CTX_BIND_APPLICATION_ID);
        String string = null;
        if (workContext != null && workContext instanceof StringWorkContext && (string = ((StringWorkContext)workContext).toString()).length() > 0) {
            return string;
        }
        String string2 = applicationAccess.getCurrentApplicationName();
        if (ApplicationVersionUtils.getVersionId(string2) != null) {
            return string2;
        }
        return null;
    }

    public static String getManifestVersion(VirtualJarFile virtualJarFile) {
        Attributes attributes;
        if (virtualJarFile == null) {
            return null;
        }
        Manifest manifest = null;
        try {
            manifest = virtualJarFile.getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
            try {
                String string = attributes.getValue(APP_VERSION_MANIFEST_ATTR_NAME);
                if (string != null) {
                    string = string.trim();
                }
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getManifestVersion(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        VirtualJarFile virtualJarFile = null;
        try {
            try {
                virtualJarFile = ApplicationFileManager.newInstance(string).getVirtualJarFile();
                string2 = ApplicationVersionUtils.getManifestVersion(virtualJarFile);
                Object var5_4 = null;
                if (virtualJarFile == null) return string2;
            }
            catch (IOException iOException) {
                String string3 = null;
                Object var5_5 = null;
                if (virtualJarFile == null) return string3;
                try {
                    virtualJarFile.close();
                    return string3;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (virtualJarFile == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            virtualJarFile.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return string2;
        }
        virtualJarFile.close();
        return string2;
    }

    public static String getLibName(VirtualJarFile virtualJarFile) {
        Attributes attributes;
        if (virtualJarFile == null) {
            return null;
        }
        Manifest manifest = null;
        try {
            manifest = virtualJarFile.getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
            try {
                String string = attributes.getValue(LIB_NAME_MANIFEST_ATTR_NAME);
                if (string != null) {
                    string = string.trim();
                }
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    public static String getLibVersionId(VirtualJarFile virtualJarFile) {
        Attributes attributes;
        if (virtualJarFile == null) {
            return null;
        }
        Manifest manifest = null;
        try {
            manifest = virtualJarFile.getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
            try {
                String string;
                String string2 = attributes.getValue(LIB_SPEC_VER_MANIFEST_ATTR_NAME);
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if ((string = attributes.getValue(LIB_IMPL_VER_MANIFEST_ATTR_NAME)) != null) {
                    string = string.trim();
                }
                return ApplicationVersionUtils.getLibVersionId(string2, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLibName(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        VirtualJarFile virtualJarFile = null;
        try {
            try {
                virtualJarFile = ApplicationFileManager.newInstance(string).getVirtualJarFile();
                string2 = ApplicationVersionUtils.getLibName(virtualJarFile);
                Object var5_4 = null;
                if (virtualJarFile == null) return string2;
            }
            catch (IOException iOException) {
                String string3 = null;
                Object var5_5 = null;
                if (virtualJarFile == null) return string3;
                try {
                    virtualJarFile.close();
                    return string3;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (virtualJarFile == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            virtualJarFile.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return string2;
        }
        virtualJarFile.close();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLibVersionId(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        VirtualJarFile virtualJarFile = null;
        try {
            try {
                virtualJarFile = ApplicationFileManager.newInstance(string).getVirtualJarFile();
                string2 = ApplicationVersionUtils.getLibVersionId(virtualJarFile);
                Object var5_4 = null;
                if (virtualJarFile == null) return string2;
            }
            catch (IOException iOException) {
                String string3 = null;
                Object var5_5 = null;
                if (virtualJarFile == null) return string3;
                try {
                    virtualJarFile.close();
                    return string3;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (virtualJarFile == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            virtualJarFile.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return string2;
        }
        virtualJarFile.close();
        return string2;
    }

    public static AppDeploymentMBean[] getAppDeployments(String string) {
        return ApplicationVersionUtils.getAppDeployments(ApplicationVersionUtils.getDomain(), string);
    }

    public static AppDeploymentMBean[] getAppDeployments(DomainMBean domainMBean, String string) {
        return ApplicationVersionUtils.getAppDeployments(domainMBean, string, false);
    }

    public static AppDeploymentMBean[] getAppDeployments(DomainMBean domainMBean, String string, boolean bl) {
        AppDeploymentMBean[] appDeploymentMBeanArray;
        ArrayList<AppDeploymentMBean> arrayList;
        if (domainMBean == null || string == null) {
            return null;
        }
        if (bl) {
            arrayList = new ArrayList<AppDeploymentMBean>();
            appDeploymentMBeanArray = domainMBean.getInternalAppDeployments();
            if (appDeploymentMBeanArray != null) {
                arrayList.addAll(Arrays.asList(appDeploymentMBeanArray));
            }
            if ((appDeploymentMBeanArray = domainMBean.getAppDeployments()) != null) {
                arrayList.addAll(Arrays.asList(appDeploymentMBeanArray));
            }
            appDeploymentMBeanArray = arrayList.toArray(new AppDeploymentMBean[arrayList.size()]);
        } else {
            appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domainMBean);
        }
        if (appDeploymentMBeanArray == null) {
            return null;
        }
        arrayList = new ArrayList();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            if (!appDeploymentMBeanArray[i].getApplicationName().equals(string)) continue;
            arrayList.add(appDeploymentMBeanArray[i]);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray2 = new AppDeploymentMBean[arrayList.size()];
        arrayList.toArray(appDeploymentMBeanArray2);
        return appDeploymentMBeanArray2;
    }

    private static DomainMBean getDomain() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain();
    }

    public static AppDeploymentMBean getAppDeployment(String string, String string2) {
        return ApplicationVersionUtils.getAppDeployment(ApplicationVersionUtils.getDomain(), string, string2);
    }

    public static AppDeploymentMBean getAppDeployment(DomainMBean domainMBean, String string, String string2) {
        if (domainMBean == null || string == null) {
            return null;
        }
        String string3 = ApplicationVersionUtils.getApplicationId(string, string2);
        AppDeploymentMBean appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(string3, domainMBean);
        if (appDeploymentMBean != null) {
            return appDeploymentMBean;
        }
        String string4 = ApplicationVersionUtils.getArchiveVersion(string2);
        String string5 = ApplicationVersionUtils.getPlanVersion(string2);
        if (string2 == null || string5 == null) {
            AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domainMBean);
            if (appDeploymentMBeanArray == null) {
                return null;
            }
            AppDeploymentMBean appDeploymentMBean2 = null;
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                AppDeploymentMBean appDeploymentMBean3 = appDeploymentMBeanArray[i];
                if (!appDeploymentMBean3.getApplicationName().equals(string)) continue;
                if (string2 == null) {
                    return appDeploymentMBean3;
                }
                String string6 = ApplicationVersionUtils.getArchiveVersion(appDeploymentMBean3.getVersionIdentifier());
                if (!string4.equals(string6)) continue;
                if (ApplicationVersionUtils.isActiveVersion(appDeploymentMBean3)) {
                    return appDeploymentMBean3;
                }
                if (appDeploymentMBean2 != null) continue;
                appDeploymentMBean2 = appDeploymentMBean3;
            }
            return appDeploymentMBean2;
        }
        return null;
    }

    public static boolean isActiveVersion(AppDeploymentMBean appDeploymentMBean) {
        return ApplicationVersionUtils.isActiveVersion(appDeploymentMBean.getName());
    }

    public static boolean isActiveVersion(String string) {
        if (appRTStateMgr.isActiveVersion(string)) {
            return true;
        }
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getApplicationRuntime(ApplicationVersionUtils.getApplicationName(string), ApplicationVersionUtils.getVersionId(string));
        return applicationRuntimeMBean != null && (applicationRuntimeMBean.getActiveVersionState() == 1 || applicationRuntimeMBean.getActiveVersionState() == 2);
    }

    public static long getRetireTimeMillis(AppDeploymentMBean appDeploymentMBean) {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return appRTStateMgr.getRetireTimeMillis(appDeploymentMBean.getName());
        }
        return 0L;
    }

    public static boolean isAdminMode(AppDeploymentMBean appDeploymentMBean) {
        if (appDeploymentMBean == null) {
            return false;
        }
        return ApplicationVersionUtils.isAdminMode(appDeploymentMBean.getName());
    }

    public static boolean isAdminMode(String string) {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return appRTStateMgr.isAdminMode(string);
        }
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getApplicationRuntime(ApplicationVersionUtils.getApplicationName(string), ApplicationVersionUtils.getVersionId(string));
        return applicationRuntimeMBean != null && applicationRuntimeMBean.getActiveVersionState() == 1;
    }

    public static BasicDeploymentMBean getDeployment(DomainMBean domainMBean, String string) {
        AppDeploymentMBean appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(string, domainMBean);
        if (appDeploymentMBean != null) {
            return appDeploymentMBean;
        }
        return domainMBean.lookupSystemResource(string);
    }

    public static AppDeploymentMBean getActiveAppDeployment(DomainMBean domainMBean, String string, boolean bl) {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return ApplicationVersionUtils.getActiveAppDeploymentAdmin(domainMBean, string, bl);
        }
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getActiveApplicationRuntime(string, bl);
        if (applicationRuntimeMBean == null) {
            return null;
        }
        String string2 = applicationRuntimeMBean.getApplicationVersion();
        return ApplicationVersionUtils.getAppDeployment(string, string2);
    }

    public static AppDeploymentMBean getActiveAppDeployment(String string, boolean bl) {
        return ApplicationVersionUtils.getActiveAppDeployment(ApplicationVersionUtils.getDomain(), string, bl);
    }

    public static AppDeploymentMBean getActiveAppDeployment(String string) {
        return ApplicationVersionUtils.getActiveAppDeployment(string, false);
    }

    public static AppDeploymentMBean getActiveAppDeployment(DomainMBean domainMBean, String string) {
        return ApplicationVersionUtils.getActiveAppDeployment(domainMBean, string, false);
    }

    private static AppDeploymentMBean getActiveAppDeploymentAdmin(DomainMBean domainMBean, String string, boolean bl) {
        AppDeploymentMBean[] appDeploymentMBeanArray;
        if (string == null) {
            return null;
        }
        DomainMBean domainMBean2 = domainMBean;
        if (domainMBean2 == null) {
            domainMBean2 = ApplicationVersionUtils.getDomain();
        }
        if ((appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domainMBean2)) == null) {
            return null;
        }
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            if (!appDeploymentMBean.getApplicationName().equals(string) || ApplicationVersionUtils.isAdminMode(appDeploymentMBean) != bl || appDeploymentMBean.getVersionIdentifier() != null && !appRTStateMgr.isActiveVersion(appDeploymentMBean)) continue;
            return appDeploymentMBean;
        }
        return null;
    }

    public static ApplicationRuntimeMBean[] getApplicationRuntimes(String string) {
        if (string == null) {
            return null;
        }
        ApplicationRuntimeMBean[] applicationRuntimeMBeanArray = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getApplicationRuntimes();
        if (applicationRuntimeMBeanArray == null) {
            return null;
        }
        ArrayList<ApplicationRuntimeMBean> arrayList = new ArrayList<ApplicationRuntimeMBean>();
        for (int i = 0; i < applicationRuntimeMBeanArray.length; ++i) {
            if (!applicationRuntimeMBeanArray[i].getApplicationName().equals(string)) continue;
            arrayList.add(applicationRuntimeMBeanArray[i]);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ApplicationRuntimeMBean[] applicationRuntimeMBeanArray2 = new ApplicationRuntimeMBean[arrayList.size()];
        arrayList.toArray(applicationRuntimeMBeanArray2);
        return applicationRuntimeMBeanArray2;
    }

    public static ApplicationRuntimeMBean getApplicationRuntime(String string, String string2) {
        return ApplicationVersionUtils.getApplicationRuntime(string, string2, false, 0);
    }

    public static ApplicationRuntimeMBean getActiveApplicationRuntime(String string, boolean bl) {
        return ApplicationVersionUtils.getApplicationRuntime(string, null, true, bl ? 1 : 2);
    }

    public static ApplicationRuntimeMBean getActiveApplicationRuntime(String string) {
        return ApplicationVersionUtils.getActiveApplicationRuntime(string, false);
    }

    private static ApplicationRuntimeMBean getApplicationRuntime(String string, String string2, boolean bl, int n) {
        if (string == null) {
            return null;
        }
        ApplicationRuntimeMBean[] applicationRuntimeMBeanArray = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getApplicationRuntimes();
        if (applicationRuntimeMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < applicationRuntimeMBeanArray.length; ++i) {
            ApplicationRuntimeMBean applicationRuntimeMBean = applicationRuntimeMBeanArray[i];
            if (!string.equals(applicationRuntimeMBean.getApplicationName()) || !(string2 == null ? !bl || applicationRuntimeMBean.getActiveVersionState() == n : string2.equals(applicationRuntimeMBean.getApplicationVersion()))) continue;
            return applicationRuntimeMBean;
        }
        return null;
    }

    public static ApplicationRuntimeMBean getCurrentApplicationRuntime() {
        ApplicationContextInternal applicationContextInternal = applicationAccess.getCurrentApplicationContext();
        if (applicationContextInternal == null) {
            return null;
        }
        return applicationContextInternal.getRuntime();
    }

    public static void setAppContextParam(ApplicationContext applicationContext, String string, boolean bl) {
        if (applicationContext == null) {
            return;
        }
        ApplicationContextInternal applicationContextInternal = (ApplicationContextInternal)applicationContext;
        HashMap<String, String> hashMap = applicationContextInternal.getApplicationParameters();
        if (hashMap == null || hashMap == Collections.EMPTY_MAP) {
            hashMap = new HashMap<String, String>();
            applicationContextInternal.setApplicationParameters(hashMap);
        }
        hashMap.put(string, Boolean.toString(bl));
    }

    public static void setAdminModeAppCtxParam(ApplicationContext applicationContext, boolean bl) {
        ApplicationVersionUtils.setAppContextParam(applicationContext, ADMIN_MODE, bl);
    }

    public static void setIgnoreSessionsAppCtxParam(ApplicationContext applicationContext, boolean bl) {
        ApplicationVersionUtils.setAppContextParam(applicationContext, IGNORE_SESSIONS, bl);
    }

    public static void setAppContextParam(ApplicationContext applicationContext, String string, int n) {
        if (applicationContext == null) {
            return;
        }
        ApplicationContextInternal applicationContextInternal = (ApplicationContextInternal)applicationContext;
        HashMap<String, String> hashMap = applicationContextInternal.getApplicationParameters();
        if (hashMap == null || hashMap == Collections.EMPTY_MAP) {
            hashMap = new HashMap<String, String>();
            applicationContextInternal.setApplicationParameters(hashMap);
        }
        hashMap.put(string, Integer.toString(n));
    }

    public static void setRMIGracePeriodAppCtxParam(ApplicationContext applicationContext, int n) {
        ApplicationVersionUtils.setAppContextParam(applicationContext, RMI_GRACE_PERIOD, n);
    }

    public static void setActiveVersionState(ApplicationContextInternal applicationContextInternal, int n) throws DeploymentException {
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = applicationContextInternal.getRuntime();
        ApplicationRuntimeMBean applicationRuntimeMBean = null;
        if (j2EEApplicationRuntimeMBeanImpl != null) {
            try {
                if (j2EEApplicationRuntimeMBeanImpl.getApplicationVersion() != null && (n == 2 || n == 1)) {
                    applicationRuntimeMBean = ApplicationVersionUtils.getActiveApplicationRuntime(applicationContextInternal.getApplicationName(), n == 1);
                }
                j2EEApplicationRuntimeMBeanImpl.setActiveVersionState(n);
                if (applicationRuntimeMBean != null) {
                    if (applicationContextInternal.isStaticDeploymentOperation()) {
                        PropertyChangeListener[] propertyChangeListenerArray;
                        if (n == 1 && (propertyChangeListenerArray = ((RuntimeMBeanDelegate)j2EEApplicationRuntimeMBeanImpl).getPropertyChangeListeners()) != null) {
                            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                                if (!propertyChangeListenerArray[i].getClass().getName().equals("weblogic.servlet.internal.ContextVersionManager$StateChangeListener")) continue;
                                ((RuntimeMBeanDelegate)applicationRuntimeMBean).addPropertyChangeListener(propertyChangeListenerArray[i]);
                            }
                        }
                    } else {
                        applicationRuntimeMBean.setActiveVersionState(0);
                    }
                }
            }
            catch (Exception exception) {
                Loggable loggable = J2EELogger.logCouldNotSetAppActiveVersionStateLoggable((String)ApplicationVersionUtils.getDisplayName(applicationContextInternal.getApplicationId()), (Throwable)exception);
                loggable.log();
                throw new DeploymentException(loggable.getMessage(), exception);
            }
        }
    }

    public static void unsetAppContextParam(ApplicationContext applicationContext, String string) {
        if (applicationContext == null) {
            return;
        }
        ApplicationContextInternal applicationContextInternal = (ApplicationContextInternal)applicationContext;
        Map map = applicationContextInternal.getApplicationParameters();
        if (map != null && map != Collections.EMPTY_MAP && map.remove(string) != null && map.size() == 0) {
            applicationContextInternal.setApplicationParameters(null);
        }
    }

    public static void unsetAdminModeAppCtxParam(ApplicationContext applicationContext) {
        ApplicationVersionUtils.unsetAppContextParam(applicationContext, ADMIN_MODE);
    }

    public static void unsetIgnoreSessionsAppCtxParam(ApplicationContext applicationContext) {
        ApplicationVersionUtils.unsetAppContextParam(applicationContext, IGNORE_SESSIONS);
    }

    public static void unsetRMIGracePeriodAppCtxParam(ApplicationContext applicationContext) {
        ApplicationVersionUtils.unsetAppContextParam(applicationContext, RMI_GRACE_PERIOD);
    }

    public static boolean getAppContextParam(ApplicationContext applicationContext, String string, boolean bl) {
        if (applicationContext == null) {
            return false;
        }
        ApplicationContextInternal applicationContextInternal = (ApplicationContextInternal)applicationContext;
        String string2 = applicationContextInternal.getApplicationParameter(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public static boolean getAdminModeAppCtxParam(ApplicationContext applicationContext) {
        return ApplicationVersionUtils.getAppContextParam(applicationContext, ADMIN_MODE, false);
    }

    public static boolean getIgnoreSessionsAppCtxParam(ApplicationContext applicationContext) {
        return ApplicationVersionUtils.getAppContextParam(applicationContext, IGNORE_SESSIONS, false);
    }

    public static int getAppContextParam(ApplicationContext applicationContext, String string, int n) {
        if (applicationContext == null) {
            return n;
        }
        ApplicationContextInternal applicationContextInternal = (ApplicationContextInternal)applicationContext;
        String string2 = applicationContextInternal.getApplicationParameter(string);
        if (string2 == null) {
            return n;
        }
        return Integer.valueOf(string2);
    }

    public static int getRMIGracePeriodAppCtxParam(ApplicationContext applicationContext) {
        return ApplicationVersionUtils.getAppContextParam(applicationContext, RMI_GRACE_PERIOD, 30);
    }

    public static boolean isVersionIdValid(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.length() > 215) {
            return false;
        }
        String string2 = ApplicationVersionUtils.getArchiveVersion(string);
        String string3 = ApplicationVersionUtils.getPlanVersion(string);
        String string4 = null;
        String string5 = null;
        if (ApplicationVersionUtils.isLibraryVersion(string2)) {
            string4 = ApplicationVersionUtils.getLibSpecVersion(string2);
            string5 = ApplicationVersionUtils.getLibImplVersion(string2);
            string2 = null;
        }
        return ApplicationVersionUtils.isVersionIdComponentValid(string2) && ApplicationVersionUtils.isVersionIdComponentValid(string4) && ApplicationVersionUtils.isVersionIdComponentValid(string5) && ApplicationVersionUtils.isVersionIdComponentValid(string3);
    }

    private static boolean isVersionIdComponentValid(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        for (int i = 0; i < invalidVersionIdStrings.length; ++i) {
            if (!string.equals(invalidVersionIdStrings[i])) continue;
            return false;
        }
        return string.matches(versionIdCharsRegExpr);
    }

    public static HashMap getDebugWorkContexts() {
        if (workCtxMap.isEmpty()) {
            return null;
        }
        HashMap<String, WorkContext> hashMap = new HashMap<String, WorkContext>();
        Iterator iterator = workCtxMap.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = workCtxMap.get(string);
            if (object instanceof StringWorkContext) {
                object = ((StringWorkContext)object).toString();
            }
            hashMap.put(string, (WorkContext)object);
        }
        return hashMap;
    }

    public static void removeAppWorkContextEntries() {
        if (workCtxMap.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = workCtxMap.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(APP_CTX_APPNAME_PREFIX)) continue;
            arrayList.add(string);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                workCtxMap.remove((String)iterator.next());
            }
            catch (PropertyReadOnlyException propertyReadOnlyException) {
                Debug.assertion((boolean)false, (String)"WorkContext property for is read-only");
            }
            catch (NoWorkContextException noWorkContextException) {
                Debug.assertion((boolean)false, (String)"No WorkContext is available");
            }
        }
    }
}

