/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.FileSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.URLSource;
import weblogic.utils.classloaders.ZipSource;

public class ClassFinderMetaDataEnumaration
implements Enumeration {
    private final ClassAnnotationMetaDataFilter annotationFilter;
    private final Enumeration delegate;
    private MetaDataFilter.Resource entry;

    public ClassFinderMetaDataEnumaration(ClassFinder classFinder, ClassAnnotationMetaDataFilter classAnnotationMetaDataFilter) {
        this.annotationFilter = classAnnotationMetaDataFilter;
        this.delegate = classFinder.entries();
    }

    public boolean hasMoreElements() {
        while (this.entry == null && this.delegate.hasMoreElements()) {
            final Source source = (Source)this.delegate.nextElement();
            if (!source.getURL().getFile().endsWith(".class")) continue;
            this.entry = new MetaDataFilter.Resource(){

                public String getName() {
                    if (source instanceof FileSource) {
                        FileSource fileSource = (FileSource)source;
                        try {
                            int n = new File(fileSource.getParentDir()).getCanonicalPath().length();
                            return fileSource.getFile().getCanonicalPath().substring(n + 1);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else if (source instanceof ZipSource) {
                        return ((ZipSource)source).getEntry().getName();
                    }
                    return source.getURL().getFile();
                }

                public byte[] getContent() throws IOException {
                    return new URLSource(source.getURL()).getBytes();
                }
            };
            try {
                if (this.annotationFilter.matches(this.entry)) continue;
                this.entry = null;
            }
            catch (IOException iOException) {
                this.entry = null;
                return false;
            }
        }
        return this.entry != null;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        String string = this.entry.getName();
        this.entry = null;
        string = string.replace('\\', '.');
        string = string.replace('/', '.');
        string = string.substring(0, string.length() - 6);
        return string;
    }
}

