/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.descriptor.wl.PreferApplicationPackagesBean;
import weblogic.j2ee.descriptor.wl.PreferApplicationResourcesBean;
import weblogic.utils.classloaders.FilteringClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtils {
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugFilteringClassLoader");

    public static void initFilterPatterns(PreferApplicationPackagesBean preferApplicationPackagesBean, PreferApplicationResourcesBean preferApplicationResourcesBean, GenericClassLoader genericClassLoader) {
        Iterator<Object> iterator;
        String[] stringArray = null;
        if (preferApplicationPackagesBean == null && preferApplicationResourcesBean == null) {
            return;
        }
        if (preferApplicationPackagesBean != null) {
            stringArray = preferApplicationPackagesBean.getPackageNames();
        }
        List<String> list = ClassLoaderUtils.validatePackages(stringArray);
        List<Object> list2 = preferApplicationResourcesBean != null ? Arrays.asList(preferApplicationResourcesBean.getResourceNames()) : Collections.emptyList();
        if (logger.isDebugEnabled()) {
            logger.debug("Filter list contains : " + list.size() + " elements ");
            for (String object2 : list) {
                logger.debug("Class Pattern: " + object2);
            }
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                logger.debug("Resource Pattern: " + string);
            }
        }
        if (list.isEmpty() && list2.isEmpty()) {
            return;
        }
        for (iterator = genericClassLoader.getParent(); iterator != null && iterator instanceof GenericClassLoader && !(iterator instanceof FilteringClassLoader); iterator = ((ClassLoader)((Object)iterator)).getParent()) {
        }
        if (!(iterator instanceof FilteringClassLoader)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No FilteringClassLoader in hierarchy, patterns " + list + " not being set.");
            }
            return;
        }
        FilteringClassLoader filteringClassLoader = (FilteringClassLoader)iterator;
        if (!list.isEmpty()) {
            filteringClassLoader.setFilterList(list);
        }
        if (!list2.isEmpty()) {
            filteringClassLoader.setResourceFilterList(list2);
        }
    }

    private static List<String> validatePackages(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!string.endsWith(".")) {
                string = string + ".";
            }
            arrayList.add(string);
        }
        return arrayList;
    }
}

