/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import weblogic.utils.PlatformConstants;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.SequencingEnumerator;

public final class CompositeWebAppFinder
implements ClassFinder {
    private MultiClassFinder webappFinder = new MultiClassFinder();
    private MultiClassFinder librariesFinder = null;

    public void addFinder(ClassFinder classFinder) {
        if (classFinder == null) {
            throw new IllegalArgumentException("Cannot add null finder");
        }
        this.webappFinder.addFinder(classFinder);
    }

    public void addFinderFirst(ClassFinder classFinder) {
        if (classFinder == null) {
            throw new IllegalArgumentException("Cannot add null finder");
        }
        this.webappFinder.addFinderFirst(classFinder);
    }

    public void addLibraryFinder(ClassFinder classFinder) {
        if (classFinder == null) {
            throw new IllegalArgumentException("Cannot add null finder");
        }
        this.initLibraryFinder();
        this.librariesFinder.addFinder(classFinder);
    }

    public ClassFinder getWebappFinder() {
        return this.webappFinder;
    }

    public ClassFinder getLibraryFinder() {
        return this.librariesFinder;
    }

    public Source getSource(String string) {
        Source source = this.webappFinder.getSource(string);
        if (source == null && this.librariesFinder != null) {
            source = this.librariesFinder.getSource(string);
        }
        return source;
    }

    public Enumeration getSources(String string) {
        SequencingEnumerator sequencingEnumerator = new SequencingEnumerator();
        sequencingEnumerator.addEnumeration(this.webappFinder.getSources(string));
        if (this.librariesFinder != null) {
            sequencingEnumerator.addEnumeration(this.librariesFinder.getSources(string));
        }
        return sequencingEnumerator;
    }

    public Source getClassSource(String string) {
        Source source = this.webappFinder.getClassSource(string);
        if (source == null && this.librariesFinder != null) {
            source = this.librariesFinder.getClassSource(string);
        }
        return source;
    }

    public String getClassPath() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.webappFinder.getClassPath();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(string2);
        }
        if (this.librariesFinder != null && (string = this.librariesFinder.getClassPath()) != null && string.trim().length() > 0) {
            stringBuffer.append(PlatformConstants.PATH_SEP).append(string);
        }
        return stringBuffer.toString();
    }

    public ClassFinder getManifestFinder() {
        ClassFinder classFinder;
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        ClassFinder classFinder2 = this.webappFinder.getManifestFinder();
        if (classFinder2 != null) {
            multiClassFinder.addFinder(classFinder2);
        }
        if (this.librariesFinder != null && (classFinder = this.librariesFinder.getManifestFinder()) != null) {
            multiClassFinder.addFinder(classFinder);
        }
        return multiClassFinder;
    }

    public Enumeration entries() {
        ArrayList<Enumeration> arrayList = new ArrayList<Enumeration>();
        Enumeration enumeration = this.webappFinder.entries();
        if (enumeration != null && enumeration != EmptyEnumerator.EMPTY) {
            arrayList.add(enumeration);
        }
        if (this.librariesFinder != null && (enumeration = this.librariesFinder.entries()) != null && enumeration != EmptyEnumerator.EMPTY) {
            arrayList.add(enumeration);
        }
        return new SequencingEnumerator(arrayList.toArray(new Enumeration[arrayList.size()]));
    }

    public void close() {
        this.webappFinder.close();
        if (this.librariesFinder != null) {
            this.librariesFinder.close();
            this.librariesFinder = null;
        }
    }

    private void initLibraryFinder() {
        if (this.librariesFinder == null) {
            this.librariesFinder = new MultiClassFinder();
        }
    }
}

