/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.application.CustomModuleFactory;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.internal.flow.CustomModuleHelper;
import weblogic.application.utils.ExtensionDescriptorParser;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.management.DeploymentException;
import weblogic.utils.compiler.ToolFailureException;

public class CustomModuleManager {
    private final EARModule parentModule;
    private EARModule[] scopedModules;
    private final CompilerCtx ctx;
    private final Map<String, Object> descriptors = new Hashtable<String, Object>();
    private WeblogicExtensionBean extDD;
    private String extDescriptorUri;
    private WeblogicExtensionBean earExtDD = null;

    public CustomModuleManager(CompilerCtx compilerCtx, EARModule eARModule, String string) throws ToolFailureException {
        this.ctx = compilerCtx;
        this.parentModule = eARModule;
        this.extDescriptorUri = string;
        this.scopedModules = this.createScopedCustomModules();
    }

    public String[] getDescriptorUris() {
        return this.descriptors.keySet().toArray(new String[0]);
    }

    public DescriptorBean getRootBean(String string) {
        return (DescriptorBean)this.descriptors.get(string);
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            for (int i = 0; i < this.scopedModules.length; ++i) {
                EARModule eARModule = this.scopedModules[i];
                eARModule.initModuleClassLoader(compilerCtx, this.parentModule.getModuleClassLoader());
                eARModule.setOutputDir(this.parentModule.getOutputDir());
                eARModule.merge(compilerCtx);
                String[] stringArray = eARModule.getDescriptorUris();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.descriptors.put(stringArray[j], eARModule.getRootBean(stringArray[j]));
                }
            }
        }
        catch (ToolFailureException toolFailureException) {
            if (this.extDD == null && this.earExtDD != null) {
                this.scopedModules = new EARModule[0];
                return;
            }
            throw toolFailureException;
        }
    }

    public void write(CompilerCtx compilerCtx) throws ToolFailureException {
        for (int i = 0; i < this.scopedModules.length; ++i) {
            this.scopedModules[i].write(compilerCtx);
        }
        if (this.extDD != null) {
            try {
                File file = new File(this.parentModule.getOutputDir(), this.extDescriptorUri);
                DescriptorUtils.writeDescriptor((DescriptorManager)new EditableDescriptorManager(), (DescriptorBean)this.extDD, file);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to write out " + this.extDescriptorUri, (Throwable)iOException);
            }
        }
        if (this.earExtDD != null && this.scopedModules.length > 0) {
            try {
                File file = new File(this.parentModule.getOutputDir(), this.extDescriptorUri);
                DescriptorUtils.writeDescriptor((DescriptorManager)new EditableDescriptorManager(), (DescriptorBean)this.earExtDD, file);
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to write out " + this.extDescriptorUri, (Throwable)iOException);
            }
        }
    }

    public void writeDescriptors(CompilerCtx compilerCtx) throws ToolFailureException {
        for (int i = 0; i < this.scopedModules.length; ++i) {
            this.scopedModules[i].writeDescriptors(compilerCtx);
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.scopedModules.length; ++i) {
            this.scopedModules[i].cleanup();
        }
    }

    private EARModule[] createScopedCustomModules() throws ToolFailureException {
        ExtensionDescriptorParser extensionDescriptorParser = new ExtensionDescriptorParser(this.parentModule.getVirtualJarFile(), this.ctx.getConfigDir(), this.ctx.getPlanBean(), this.parentModule.getURI(), this.extDescriptorUri);
        try {
            extensionDescriptorParser.mergeWlExtensionDescriptorsFromLibraries(this.ctx.getApplicationContext());
            this.extDD = extensionDescriptorParser.getWlExtensionDescriptor();
            this.earExtDD = this.ctx.getWLExtensionDD();
            if (this.extDD != null) {
                Map<String, CustomModuleFactory> map = CustomModuleHelper.initFactories(this.extDD, this.parentModule.getModuleClassLoader(), this.parentModule.getURI(), this.parentModule.getURI());
                if (map == null) {
                    return new EARModule[0];
                }
                CustomModuleBean[] customModuleBeanArray = this.extDD.getCustomModules();
                ArrayList<EARModule> arrayList = new ArrayList<EARModule>();
                for (int i = 0; i < customModuleBeanArray.length; ++i) {
                    CustomModuleFactory customModuleFactory = map.get(customModuleBeanArray[i].getProviderName());
                    EARModule eARModule = customModuleFactory.createToolsModule(customModuleBeanArray[i]);
                    if (eARModule == null) continue;
                    arrayList.add(eARModule);
                }
                this.descriptors.put(this.extDescriptorUri, this.extDD);
                return arrayList.toArray(new EARModule[0]);
            }
            if (this.earExtDD != null) {
                Map<String, CustomModuleFactory> map = null;
                try {
                    map = CustomModuleHelper.initFactories(this.earExtDD, this.parentModule.getModuleClassLoader(), this.parentModule.getURI(), this.parentModule.getURI());
                }
                catch (DeploymentException deploymentException) {
                    return new EARModule[0];
                }
                if (map == null) {
                    return new EARModule[0];
                }
                CustomModuleBean[] customModuleBeanArray = this.earExtDD.getCustomModules();
                ArrayList<EARModule> arrayList = new ArrayList<EARModule>();
                for (int i = 0; i < customModuleBeanArray.length; ++i) {
                    CustomModuleFactory customModuleFactory = map.get(customModuleBeanArray[i].getProviderName());
                    EARModule eARModule = customModuleFactory.createToolsModule(customModuleBeanArray[i]);
                    if (eARModule == null) continue;
                    arrayList.add(eARModule);
                }
                return arrayList.toArray(new EARModule[0]);
            }
            return new EARModule[0];
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Problem loading or merging weblogic-extension.xml for parent module", (Throwable)xMLStreamException);
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Problem loading or merging weblogic-extension.xml for parent module", (Throwable)iOException);
        }
        catch (DeploymentException deploymentException) {
            throw new ToolFailureException("Unable to create custom module factories", (Throwable)((Object)deploymentException));
        }
    }
}

