/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import weblogic.application.utils.DiscoveredModule;
import weblogic.application.utils.EJBDiscoveredModuleFactory;
import weblogic.application.utils.JavaDiscoveredModuleFactory;
import weblogic.application.utils.RarDiscoveredModuleFactory;
import weblogic.application.utils.WarDiscoveredModuleFactory;
import weblogic.utils.jars.VirtualJarFile;

public abstract class DiscoveredModuleFactory {
    private static final boolean debug = false;
    private static final DiscoveredModuleFactory[] factories = new DiscoveredModuleFactory[]{new WarDiscoveredModuleFactory(), new RarDiscoveredModuleFactory(), new JavaDiscoveredModuleFactory(), new EJBDiscoveredModuleFactory()};

    public abstract DiscoveredModule claim(File var1, String var2);

    public abstract DiscoveredModule claim(VirtualJarFile var1, ZipEntry var2, String var3) throws IOException;

    static DiscoveredModule makeDiscoveredModule(File file, String string) {
        for (int i = 0; i < factories.length; ++i) {
            DiscoveredModuleFactory discoveredModuleFactory = factories[i];
            DiscoveredModule discoveredModule = discoveredModuleFactory.claim(file, string);
            if (discoveredModule == null) continue;
            return discoveredModule;
        }
        return null;
    }

    static DiscoveredModule makeDiscoveredModule(VirtualJarFile virtualJarFile, ZipEntry zipEntry, String string) throws IOException {
        for (int i = 0; i < factories.length; ++i) {
            DiscoveredModuleFactory discoveredModuleFactory = factories[i];
            DiscoveredModule discoveredModule = discoveredModuleFactory.claim(virtualJarFile, zipEntry, string);
            if (discoveredModule == null) continue;
            return discoveredModule;
        }
        return null;
    }
}

