/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.ApplicationFileManager;
import weblogic.application.Deployment;
import weblogic.application.io.Ear;
import weblogic.application.utils.ModuleDiscovery;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.application.WarDetector;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFile;

public final class EarUtils {
    public static final Deployment.AdminModeCallback noopAdminModeCallback = new Deployment.AdminModeCallback(){

        public void completed() {
        }

        public void waitForCompletion(long l) {
        }
    };
    static final String EXPLODED_EAR_SUFFIX = ".ear";
    private static final DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugAppContainer");

    private EarUtils() {
    }

    public static boolean isDebugOn() {
        return debugLogger.isDebugEnabled();
    }

    public static void debug(String string) {
        debugLogger.debug(EarUtils.addClassName(string));
    }

    static String addClassName(String string) {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        String string2 = stackTraceElementArray[2].getClassName();
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        return "[" + string2 + "] " + string;
    }

    public static void handleUnsetContextRoot(String string, String string2, ApplicationBean applicationBean, WeblogicWebAppBean weblogicWebAppBean) {
        if (applicationBean == null) {
            return;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            WebBean webBean = moduleBeanArray[i].getWeb();
            if (webBean == null || !webBean.getWebUri().equals(string)) continue;
            if (webBean.getContextRoot() != null && webBean.getContextRoot().startsWith("__BEA_WLS_INTERNAL_UNSET_CONTEXT_ROOT")) {
                String string3 = null;
                if (string2 != null) {
                    string3 = string2;
                } else if (weblogicWebAppBean != null && weblogicWebAppBean.getContextRoots().length > 0) {
                    string3 = weblogicWebAppBean.getContextRoots()[0];
                } else if (string != null) {
                    string3 = WarDetector.instance.stem(string);
                }
                if (string3 != null) {
                    webBean.setContextRoot(string3);
                }
            }
            return;
        }
    }

    public static String fixAppContextRoot(String string) {
        if (string != null && string.startsWith("__BEA_WLS_INTERNAL_UNSET_CONTEXT_ROOT")) {
            return null;
        }
        return string;
    }

    public static boolean isEar(File file) {
        if (file.isDirectory()) {
            return new File(file, "META-INF/application.xml").exists() || EarUtils.isSplitDir(file) || file.getName().endsWith(EXPLODED_EAR_SUFFIX);
        }
        return file.getName().endsWith(EXPLODED_EAR_SUFFIX);
    }

    private static ApplicationBean createApplicationBean() {
        return (ApplicationBean)new DescriptorManager().createDescriptorRoot(ApplicationBean.class).getRootBean();
    }

    private static File extractAndGetTempRoot(VirtualJarFile virtualJarFile) throws IOException {
        File file;
        String string = virtualJarFile.getName();
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        if (n > -1) {
            string = string.substring(n);
        }
        if ((file = FileUtils.createTempDir((String)"_earscanner_tmp", null)).exists()) {
            FileUtils.remove((File)file);
        }
        file.mkdirs();
        JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)file);
        return file;
    }

    public static void linkURI(Ear ear, ApplicationFileManager applicationFileManager, String string, File file) throws IOException {
        ear.registerLink(string, file);
        applicationFileManager.registerLink(string, file.getAbsolutePath());
    }

    public static String reallyGetModuleURI(ModuleBean moduleBean) {
        if (moduleBean.getWeb() != null) {
            return moduleBean.getWeb().getWebUri();
        }
        return EarUtils.getModuleURI(moduleBean);
    }

    public static String getModuleURI(ModuleBean moduleBean) {
        if (moduleBean.getConnector() != null) {
            return moduleBean.getConnector();
        }
        if (moduleBean.getEjb() != null) {
            return moduleBean.getEjb();
        }
        if (moduleBean.getJava() != null) {
            return moduleBean.getJava();
        }
        if (moduleBean.getWeb() != null) {
            return EarUtils.getContextRootName(moduleBean);
        }
        if (moduleBean.getAltDd() != null) {
            return moduleBean.getAltDd();
        }
        throw new AssertionError((Object)"ModuleBean contains no module URI");
    }

    public static void informDescriptor(DescriptorBean descriptorBean) {
        try {
            new EditableDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)System.out);
        }
        catch (Exception exception) {
            Debug.say((String)("Failed to write descriptor to stdout because of " + exception));
        }
    }

    public static void handleParsingError(Throwable throwable, String string) throws ToolFailureException {
        throw new ToolFailureException(J2EELogger.logAppcErrorParsingEARDescriptorsLoggable((String)string, (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable)).getMessage(), throwable);
    }

    public static File getSplitDirProperties(File file) {
        return new File(file, ".beabuild.txt");
    }

    public static boolean isSplitDir(File file) {
        return EarUtils.getSplitDirProperties(file).exists();
    }

    public static String getContextRootName(ModuleBean moduleBean) {
        WebBean webBean = moduleBean.getWeb();
        if (webBean == null) {
            return null;
        }
        String string = EarUtils.fixAppContextRoot(webBean.getContextRoot());
        if (string == null || "".equals(string)) {
            return webBean.getWebUri();
        }
        return string;
    }

    public static File getConfigDir(ApplicationContextInternal applicationContextInternal) {
        return applicationContextInternal.getAppDeploymentMBean().getPlanDir() == null ? null : new File(applicationContextInternal.getAppDeploymentMBean().getLocalPlanDir());
    }

    public static void informRoleToPrincipalsMapping(Map map) {
        if (map == null) {
            return;
        }
        Debug.say((String)"**********************************");
        for (Map.Entry entry : map.entrySet()) {
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length <= 0) continue;
            Debug.say((String)("Role: " + entry.getKey() + " -> principals: "));
            for (int i = 0; i < stringArray.length; ++i) {
                Debug.say((String)stringArray[i]);
            }
        }
    }

    public static File[] getAppFiles(String[] stringArray, AppDeploymentMBean appDeploymentMBean) throws IOException {
        String string = appDeploymentMBean.getApplicationName();
        File file = new File(appDeploymentMBean.getAbsoluteSourcePath());
        if (!file.isDirectory()) {
            String string2 = DeployerRuntimeLogger.logPartialRedeployOfArchiveLoggable((String)string).getMessage();
            throw new IOException(string2);
        }
        if (!EarUtils.isEar(file)) {
            return new File[]{file};
        }
        ArrayList arrayList = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        VirtualJarFile virtualJarFile = null;
        try {
            Object object;
            ApplicationFileManager applicationFileManager = ApplicationFileManager.newInstance(file);
            virtualJarFile = applicationFileManager.getVirtualJarFile();
            String string3 = appDeploymentMBean.getAbsolutePlanDir();
            File file2 = string3 == null ? null : new File(string3);
            Map map = EarUtils.addAppDescriptors(appDeploymentMBean, arrayList, virtualJarFile);
            File file3 = (File)map.get("META-INF/application.xml");
            File file4 = (File)map.get("META-INF/weblogic-application.xml");
            File file5 = (File)map.get("META-INF/weblogic-extension.xml");
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(file3, file4, file5, file2, EarUtils.getDeploymentPlanDescriptor(appDeploymentMBean.getAbsolutePlanPath()), file.getName());
            ApplicationBean applicationBean = applicationDescriptor.getApplicationDescriptor();
            if (applicationBean == null && virtualJarFile != null) {
                applicationBean = ModuleDiscovery.discoverModules(virtualJarFile);
            }
            EarUtils.addAppURIs(applicationBean, hashSet, arrayList, virtualJarFile);
            if (!hashSet.isEmpty()) {
                object = applicationDescriptor.getWeblogicApplicationDescriptor();
                EarUtils.addWlAppURIs((WeblogicApplicationBean)object, hashSet, arrayList, virtualJarFile);
            }
            if (!hashSet.isEmpty()) {
                object = new StringBuffer();
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((StringBuffer)object).append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    ((StringBuffer)object).append(", ");
                }
                throw new IOException(J2EELogger.logUrisDidntMatchModulesLoggable((String)((StringBuffer)object).toString()).getMessage());
            }
        }
        catch (XMLStreamException xMLStreamException) {
            IOException iOException = new IOException(xMLStreamException.getMessage());
            iOException.initCause(xMLStreamException);
            throw iOException;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static DeploymentPlanBean getDeploymentPlanDescriptor(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        DeploymentPlanBean deploymentPlanBean = null;
        try {
            DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file);
            deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalArgumentException(xMLStreamException.getMessage(), xMLStreamException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage(), classCastException);
        }
        return deploymentPlanBean;
    }

    private static Map addAppDescriptors(AppDeploymentMBean appDeploymentMBean, List list, VirtualJarFile virtualJarFile) {
        Object object;
        String[] stringArray = new String[]{"META-INF/application.xml", "META-INF/weblogic-application.xml", "META-INF/weblogic-extension.xml"};
        HashMap<String, Object> hashMap = new HashMap<String, Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = EarUtils.getFile(stringArray[i], virtualJarFile);
            if (file == null) continue;
            hashMap.put(stringArray[i], file);
        }
        File file = appDeploymentMBean.getAbsolutePlanDir() == null ? null : new File(appDeploymentMBean.getAbsolutePlanDir());
        for (int i = 0; i < stringArray.length; ++i) {
            object = EarUtils.getExternalPlanDescriptorFile(EarUtils.getDeploymentPlanDescriptor(appDeploymentMBean.getAbsolutePlanPath()), file, appDeploymentMBean.getApplicationName(), stringArray[i]);
            if (object == null || !((File)object).exists()) continue;
            hashMap.put(stringArray[i], object);
        }
        String string = appDeploymentMBean.getAltDescriptorPath();
        if (string != null && string.trim().length() > 0) {
            hashMap.put("META-INF/application.xml", new File(string));
        }
        if ((object = appDeploymentMBean.getAltWLSDescriptorPath()) != null && ((String)object).trim().length() > 0) {
            hashMap.put("META-INF/weblogic-application.xml", new File((String)object));
        }
        for (File file2 : hashMap.values()) {
            if (!file2.exists()) continue;
            list.add(file2);
        }
        return hashMap;
    }

    private static File getFile(String string, VirtualJarFile virtualJarFile) {
        File[] fileArray = virtualJarFile.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = new File(fileArray[i], string);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static void addAppURIs(ApplicationBean applicationBean, Set set, List list, VirtualJarFile virtualJarFile) {
        if (applicationBean == null) {
            return;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            File file;
            String string = null;
            String string2 = null;
            if (moduleBeanArray[i].getWeb() != null) {
                string = moduleBeanArray[i].getWeb().getWebUri();
                string2 = EarUtils.fixAppContextRoot(moduleBeanArray[i].getWeb().getContextRoot());
                if (string2 == null || "".equals(string2) || "/".equals(string2)) {
                    string2 = string;
                }
                if (set.contains(string2)) {
                    file = EarUtils.getFile(string, virtualJarFile);
                    if (file != null) {
                        list.add(file);
                    }
                    set.remove(string2);
                }
            } else {
                if (moduleBeanArray[i].getEjb() != null) {
                    string = moduleBeanArray[i].getEjb();
                } else if (moduleBeanArray[i].getConnector() != null) {
                    string = moduleBeanArray[i].getConnector();
                } else if (moduleBeanArray[i].getJava() != null) {
                    string = moduleBeanArray[i].getJava();
                }
                if (string != null && set.contains(string)) {
                    file = EarUtils.getFile(string, virtualJarFile);
                    if (file != null) {
                        list.add(file);
                    }
                    set.remove(string);
                }
            }
            if (set.isEmpty()) break;
        }
    }

    private static void addWlAppURIs(WeblogicApplicationBean weblogicApplicationBean, Set set, List list, VirtualJarFile virtualJarFile) {
        if (weblogicApplicationBean == null) {
            return;
        }
        WeblogicModuleBean[] weblogicModuleBeanArray = weblogicApplicationBean.getModules();
        for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
            File file;
            if ("JDBC".equals(weblogicModuleBeanArray[i].getType())) {
                if (!set.contains(weblogicModuleBeanArray[i].getName())) continue;
                set.remove(weblogicModuleBeanArray[i].getName());
                file = EarUtils.getFile(weblogicModuleBeanArray[i].getPath(), virtualJarFile);
                if (file == null) continue;
                list.add(file);
                continue;
            }
            if (!set.contains(weblogicModuleBeanArray[i].getPath())) continue;
            set.remove(weblogicModuleBeanArray[i].getPath());
            file = EarUtils.getFile(weblogicModuleBeanArray[i].getPath(), virtualJarFile);
            if (file == null) continue;
            list.add(file);
        }
    }

    private static File getExternalPlanDescriptorFile(DeploymentPlanBean deploymentPlanBean, File file, String string, String string2) {
        if (deploymentPlanBean == null || file == null) {
            return null;
        }
        ModuleDescriptorBean moduleDescriptorBean = deploymentPlanBean.findModuleDescriptor(string, string2);
        if (moduleDescriptorBean == null || !moduleDescriptorBean.isExternal()) {
            return null;
        }
        File file2 = deploymentPlanBean.rootModule(string) ? file : new File(file, string);
        return new File(file2, moduleDescriptorBean.getUri());
    }

    public static String toModuleId(ApplicationContextInternal applicationContextInternal, String string) {
        if (string == null) {
            return string;
        }
        ApplicationBean applicationBean = applicationContextInternal.getApplicationDD();
        if (applicationBean == null) {
            return string;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray == null) {
            return string;
        }
        Map<String, String> map = applicationContextInternal.getModuleURItoIdMap();
        String string2 = map != null ? map.get(string) : null;
        return string2 != null ? string2 : string;
    }

    public static String[] toModuleIds(ApplicationContextInternal applicationContextInternal, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        ApplicationBean applicationBean = applicationContextInternal.getApplicationDD();
        if (applicationBean == null) {
            return stringArray;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray == null) {
            return stringArray;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = EarUtils.toModuleId(applicationContextInternal, stringArray[i]);
        }
        return stringArray2;
    }
}

