/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.internal.WlsExtensionReader;
import weblogic.application.utils.IOUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.utils.jars.VirtualJarFile;

public class ExtensionDescriptorParser
extends AbstractDescriptorLoader2 {
    private WeblogicExtensionBean wlExtBean = null;
    private boolean parsed = false;
    private final String extDescritorUri;
    private final String appName;

    public ExtensionDescriptorParser(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(virtualJarFile, file, deploymentPlanBean, string, string2);
        this.extDescritorUri = string2;
        this.appName = string;
    }

    public ExtensionDescriptorParser(InputStream inputStream) {
        super(inputStream);
        this.extDescritorUri = "";
        this.appName = "";
    }

    public WeblogicExtensionBean getWlExtensionDescriptor() throws IOException, XMLStreamException {
        if (!this.parsed) {
            this.wlExtBean = (WeblogicExtensionBean)this.loadDescriptorBean();
            this.parsed = true;
        }
        return this.wlExtBean;
    }

    protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return new WlsExtensionReader(inputStream, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeWlExtensionDescriptorsFromLibraries(ApplicationContextInternal applicationContextInternal) throws IOException, XMLStreamException {
        VirtualJarFile[] virtualJarFileArray = null;
        try {
            virtualJarFileArray = LibraryUtils.getLibraryVjarsWithDescriptor(applicationContextInternal, this.appName, this.extDescritorUri);
            WeblogicExtensionBean weblogicExtensionBean = this.getWlExtensionDescriptor();
            if (virtualJarFileArray.length > 0) {
                ExtensionDescriptorParser extensionDescriptorParser = this;
                if (weblogicExtensionBean == null) {
                    extensionDescriptorParser = new ExtensionDescriptorParser(virtualJarFileArray[0], this.getConfigDir(), this.getDeploymentPlan(), this.appName, this.extDescritorUri);
                    weblogicExtensionBean = (WeblogicExtensionBean)extensionDescriptorParser.loadDescriptorBean();
                    virtualJarFileArray[0].close();
                    if (virtualJarFileArray.length > 1) {
                        VirtualJarFile[] virtualJarFileArray2 = new VirtualJarFile[virtualJarFileArray.length - 1];
                        System.arraycopy(virtualJarFileArray, 1, virtualJarFileArray2, 0, virtualJarFileArray.length - 1);
                        virtualJarFileArray = virtualJarFileArray2;
                    } else {
                        virtualJarFileArray = new VirtualJarFile[]{};
                    }
                }
                if (virtualJarFileArray.length > 0) {
                    weblogicExtensionBean = (WeblogicExtensionBean)extensionDescriptorParser.mergeDescriptors(virtualJarFileArray);
                }
            }
            this.wlExtBean = weblogicExtensionBean;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.forceClose(virtualJarFileArray);
            throw throwable;
        }
        IOUtils.forceClose(virtualJarFileArray);
    }
}

