/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.jar.Attributes;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.Type;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.internal.library.LibraryManagerAggregate;
import weblogic.application.internal.library.LibraryRegistrationException;
import weblogic.application.internal.library.LibraryRegistry;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryFactory;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.jars.VirtualJarFile;

public final class LibraryLoggingUtils {
    private static final boolean optPackEnabled = Boolean.getBoolean("weblogic.application.RequireOptionalPackages");
    private static final LibraryRegistry libraryRegistry = LibraryRegistry.getRegistry();

    public static void verifyLibraryReferences(LibraryManager libraryManager) throws LoggableLibraryProcessingException {
        LibraryManagerAggregate libraryManagerAggregate = new LibraryManagerAggregate();
        libraryManagerAggregate.addLibraryManager(libraryManager);
        LibraryLoggingUtils.verifyLibraryReferences(libraryManagerAggregate, true);
    }

    public static void verifyLibraryReferences(LibraryManagerAggregate libraryManagerAggregate, boolean bl) throws LoggableLibraryProcessingException {
        LibraryLoggingUtils.verifyLibraryReferences(libraryManagerAggregate.getOptionalPackagesManager(), libraryManagerAggregate, bl);
    }

    public static void verifyLibraryReferences(LibraryManagerAggregate libraryManagerAggregate) throws LoggableLibraryProcessingException {
        LibraryLoggingUtils.verifyLibraryReferences(libraryManagerAggregate, true);
    }

    private static void verifyLibraryReferences(LibraryManager libraryManager, LibraryManagerAggregate libraryManagerAggregate, boolean bl) throws LoggableLibraryProcessingException {
        if (libraryManager != null) {
            LibraryLoggingUtils.handleOptPackErrorLevel(libraryManager);
        }
        if (libraryManagerAggregate.hasUnresolvedRefs()) {
            if (bl) {
                throw new LoggableLibraryProcessingException(J2EELogger.logUnresolvedLibraryReferencesLoggable((String)libraryManagerAggregate.getUnresolvedRefsError()));
            }
            throw new LoggableLibraryProcessingException(J2EELogger.logUnresolvedLibraryReferencesWarningLoggable((String)libraryManagerAggregate.getUnresolvedRefsError()));
        }
    }

    private static void handleOptPackErrorLevel(LibraryManager libraryManager) {
        if (!optPackEnabled && libraryManager.hasUnresolvedReferences()) {
            J2EELogger.logUnresolvedOptionalPackages((String)libraryManager.getUnresolvedReferencesAsString());
            libraryManager.resetUnresolvedReferences();
        }
    }

    public static void checkNoContextRootSet(J2EELibraryReference j2EELibraryReference, Type type) {
        if (type != Type.WAR && j2EELibraryReference.getContextRoot() != null) {
            J2EELogger.logContextPathSetForNonWarLibRef((String)j2EELibraryReference.toString(), (String)type.toString());
        }
    }

    public static LibraryData initLibraryData(String string, String string2, String string3, File file) throws LoggableLibraryProcessingException {
        LibraryData libraryData = null;
        try {
            libraryData = LibraryData.newInstance(string, string2, string3, file);
        }
        catch (IOException iOException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryInitErrorLoggable((String)file.getAbsolutePath(), (String)iOException.getMessage()), (Throwable)iOException);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryWithIllegalSpecVersionLoggable((String)file.getAbsolutePath(), (String)illegalSpecVersionTypeException.getSpecVersion()), (Throwable)illegalSpecVersionTypeException);
        }
        return libraryData;
    }

    public static LibraryData initLibraryData(File file, Attributes attributes) throws LoggableLibraryProcessingException {
        LibraryData libraryData = null;
        try {
            libraryData = LibraryData.initFromManifest(file, attributes);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryWithIllegalSpecVersionLoggable((String)file.getAbsolutePath(), (String)illegalSpecVersionTypeException.getSpecVersion()), (Throwable)illegalSpecVersionTypeException);
        }
        return libraryData;
    }

    public static LibraryData initLibraryData(File file) throws LoggableLibraryProcessingException {
        LibraryData libraryData = null;
        try {
            libraryData = LibraryData.initFromManifest(file);
        }
        catch (IOException iOException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryInitErrorLoggable((String)file.getAbsolutePath(), (String)iOException.getMessage()), (Throwable)iOException);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryWithIllegalSpecVersionLoggable((String)file.getAbsolutePath(), (String)illegalSpecVersionTypeException.getSpecVersion()), (Throwable)illegalSpecVersionTypeException);
        }
        return libraryData;
    }

    public static LibraryData initLibraryData(LibraryMBean libraryMBean, File file) throws LoggableLibraryProcessingException {
        LibraryData libraryData = null;
        try {
            libraryData = LibraryData.initFromMBean(libraryMBean, file);
        }
        catch (IOException iOException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryInitErrorLoggable((String)LibraryUtils.toString(libraryMBean), (String)iOException.getMessage()), (Throwable)iOException);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryWithIllegalMBeanSpecVersionLoggable((String)LibraryUtils.toString(libraryMBean), (String)illegalSpecVersionTypeException.getSpecVersion()), (Throwable)illegalSpecVersionTypeException);
        }
        return libraryData;
    }

    public static J2EELibraryReference[] initLibRefs(LibraryRefBean[] libraryRefBeanArray) throws LoggableLibraryProcessingException {
        J2EELibraryReference[] j2EELibraryReferenceArray = null;
        try {
            j2EELibraryReferenceArray = LibraryReferenceFactory.getAppLibReference(libraryRefBeanArray);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logIllegalAppLibSpecVersionRefLoggable((String)illegalSpecVersionTypeException.getSpecVersion()), (Throwable)illegalSpecVersionTypeException);
        }
        return j2EELibraryReferenceArray;
    }

    public static void handleAppcLibraryInfoMismatch(BasicLibraryData basicLibraryData, BasicLibraryData basicLibraryData2, File file) throws LoggableLibraryProcessingException {
        Collection collection = basicLibraryData.verifyDataConsistency(basicLibraryData2);
        if (!collection.isEmpty()) {
            throw new LoggableLibraryProcessingException(J2EELogger.logAppcLibraryInfoMismatchLoggable((String)file.getAbsolutePath(), (String)collection.toString()));
        }
    }

    public static void handleLibraryInfoMismatch(BasicLibraryData basicLibraryData, BasicLibraryData basicLibraryData2) throws LoggableLibraryProcessingException {
        Collection collection = basicLibraryData.verifyDataConsistency(basicLibraryData2);
        if (!collection.isEmpty()) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryInfoMismatchLoggable((String)basicLibraryData.toString(), (String)collection.toString()));
        }
    }

    public static LibraryDefinition getLibraryDefinition(LibraryData libraryData, File file, Iterator iterator) throws LoggableLibraryProcessingException {
        LibraryDefinition libraryDefinition = null;
        try {
            while (iterator.hasNext()) {
                LibraryFactory libraryFactory = (LibraryFactory)iterator.next();
                LibraryDefinition libraryDefinition2 = libraryFactory.createLibrary(libraryData, file);
                if (libraryDefinition2 == null) continue;
                return libraryDefinition2;
            }
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw loggableLibraryProcessingException;
        }
        catch (LibraryProcessingException libraryProcessingException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryInitErrorLoggable((String)libraryData.getLocation().getAbsolutePath(), (String)StackTraceUtils.throwable2StackTrace((Throwable)libraryProcessingException)), (Throwable)libraryProcessingException);
        }
        if (libraryDefinition == null) {
            throw new LoggableLibraryProcessingException(J2EELogger.logUnknownLibraryTypeLoggable((String)libraryData.getLocation().getAbsolutePath()));
        }
        return libraryDefinition;
    }

    public static void initLibraryDefinition(LibraryDefinition libraryDefinition) throws LoggableLibraryProcessingException {
        try {
            libraryDefinition.init();
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw loggableLibraryProcessingException;
        }
        catch (LibraryProcessingException libraryProcessingException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryInitErrorLoggable((String)libraryDefinition.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)libraryProcessingException)), (Throwable)libraryProcessingException);
        }
    }

    public static void registerLibrary(LibraryDefinition libraryDefinition, boolean bl) throws LoggableLibraryProcessingException {
        try {
            libraryRegistry.register(libraryDefinition);
            if (bl) {
                J2EELogger.logRegisteredLibrary((String)(libraryDefinition.toString() + " (" + libraryDefinition.getType() + ")"));
            }
        }
        catch (LibraryRegistrationException libraryRegistrationException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryRegistrationErrorLoggable((String)libraryDefinition.toString(), (String)libraryRegistrationException.getMessage()), (Throwable)((Object)libraryRegistrationException));
        }
    }

    public static void cleanupLibrariesAndRemove() {
        LibraryLoggingUtils.warnCleanupLibraries(true, true);
    }

    private static void warnCleanupLibraries(boolean bl, boolean bl2) {
        Collection<LibraryDefinition> collection = libraryRegistry.getAll();
        for (LibraryDefinition libraryDefinition : collection) {
            LibraryLoggingUtils.warnCleanupLibrary(libraryDefinition, bl2);
            if (!bl) continue;
            libraryRegistry.remove(libraryDefinition);
        }
    }

    private static void warnCleanupLibrary(LibraryDefinition libraryDefinition, boolean bl) {
        block4: {
            try {
                LibraryLoggingUtils.removeLibrary(libraryDefinition);
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                if (!bl) {
                    loggableLibraryProcessingException.getLoggable().log();
                }
            }
            catch (LibraryProcessingException libraryProcessingException) {
                if (bl) break block4;
                J2EELogger.logLibraryCleanupWarning((String)libraryDefinition.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)libraryProcessingException));
            }
        }
    }

    public static void partialCleanupAndRemove() {
        Collection<LibraryDefinition> collection = libraryRegistry.getAll();
        for (LibraryDefinition libraryDefinition : collection) {
            LibraryLoggingUtils.cleanupOnly(libraryDefinition, true);
            libraryRegistry.remove(libraryDefinition);
        }
    }

    private static void cleanupOnly(LibraryDefinition libraryDefinition, boolean bl) {
        block4: {
            try {
                libraryDefinition.cleanup();
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                if (!bl) {
                    loggableLibraryProcessingException.getLoggable().log();
                }
            }
            catch (LibraryProcessingException libraryProcessingException) {
                if (bl) break block4;
                J2EELogger.logLibraryCleanupWarning((String)libraryDefinition.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)libraryProcessingException));
            }
        }
    }

    public static void errorRemoveLibrary(LibraryDefinition libraryDefinition) throws LoggableLibraryProcessingException {
        try {
            LibraryLoggingUtils.removeLibrary(libraryDefinition);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw loggableLibraryProcessingException;
        }
        catch (LibraryProcessingException libraryProcessingException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryCleanupErrorLoggable((String)libraryDefinition.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)libraryProcessingException)), (Throwable)libraryProcessingException);
        }
    }

    private static void removeLibrary(LibraryDefinition libraryDefinition) throws LibraryProcessingException {
        libraryDefinition.cleanup();
        libraryDefinition.remove();
    }

    public static void checkLibraryExists(File file) throws LoggableLibraryProcessingException {
        if (!file.exists()) {
            throw new LoggableLibraryProcessingException(J2EELogger.logCannotFindLibraryLoggable((String)file.getAbsolutePath()));
        }
    }

    public static void checkLibdirIsValid(File file) throws LoggableLibraryProcessingException {
        if (!file.exists() || !file.isDirectory()) {
            throw new LoggableLibraryProcessingException(J2EELogger.logCannotProcessLibdirLoggable((String)file.getAbsolutePath()));
        }
    }

    public static void importLibrary(ApplicationLibrary applicationLibrary, J2EELibraryReference j2EELibraryReference, LibraryContext libraryContext, boolean bl, MultiClassFinder multiClassFinder) throws LoggableLibraryProcessingException {
        try {
            applicationLibrary.importLibrary(j2EELibraryReference, libraryContext, multiClassFinder);
            if (bl) {
                J2EELogger.logLibraryImport((String)applicationLibrary.toString(), (String)libraryContext.getRefappName());
            }
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw loggableLibraryProcessingException;
        }
        catch (LibraryProcessingException libraryProcessingException) {
            throw new LoggableLibraryProcessingException(J2EELogger.logErrorImportingLibraryLoggable((String)applicationLibrary.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)libraryProcessingException)), (Throwable)libraryProcessingException);
        }
    }

    public static void mergeDescriptors(ApplicationDescriptor applicationDescriptor, VirtualJarFile virtualJarFile) throws LoggableLibraryProcessingException {
        try {
            applicationDescriptor.mergeDescriptors(virtualJarFile);
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
    }

    public static void mergeDescriptors(ApplicationDescriptor applicationDescriptor, ApplicationDescriptor applicationDescriptor2) throws LoggableLibraryProcessingException {
        try {
            applicationDescriptor.mergeDescriptors(applicationDescriptor2);
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
    }

    public static void updateDescriptor(ApplicationDescriptor applicationDescriptor, ApplicationBean applicationBean) throws LoggableLibraryProcessingException {
        try {
            applicationDescriptor.updateApplicationDescriptor(applicationBean);
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
    }

    public static void errorMerging(Exception exception) throws LoggableLibraryProcessingException {
        throw new LoggableLibraryProcessingException(J2EELogger.logDescriptorMergeErrorLoggable((String)StackTraceUtils.throwable2StackTrace((Throwable)exception)), (Throwable)exception);
    }

    public static void checkIsAppLibrary(Library library) throws LoggableLibraryProcessingException {
        if (!(library instanceof ApplicationLibrary)) {
            throw new LoggableLibraryProcessingException(J2EELogger.logLibraryIsNotAppLibraryLoggable((String)library.toString()));
        }
    }

    public static void warnMissingExtensionName(String string, String string2) {
        J2EELogger.logCannotFindExtensionNameWarning((String)string, (String)string2);
    }

    public static BasicLibraryData initOptionalPackageRefLibData(String string, String string2, String string3, String string4) {
        BasicLibraryData basicLibraryData = null;
        try {
            basicLibraryData = new BasicLibraryData(string, string2, string3);
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            J2EELogger.logIllegalOptPackSpecVersionRefWarning((String)string, (String)string2, (String)string4);
            return null;
        }
        return basicLibraryData;
    }

    public static String registryToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<LibraryDefinition> iterator = libraryRegistry.getAll().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Object)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

