/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.DescriptorUpdater;
import weblogic.application.internal.library.BasicLibraryData;
import weblogic.application.internal.library.EarLibraryFactory;
import weblogic.application.internal.library.JarLibraryFactory;
import weblogic.application.internal.library.util.DeweyDecimal;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryProvider;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.application.library.LibraryReferencer;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.spi.EJBLibraryFactory;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.LibraryContextRootOverrideBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.servlet.internal.WarLibraryFactory;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class LibraryUtils {
    private static final DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugLibraries");
    private static ApplicationFactoryManager dumbLibFactories = ApplicationFactoryManager.getEmptyApplicationFactoryManager();
    private static boolean initializedDumbFactories = false;
    private static ApplicationFactoryManager standardLibFactories = ApplicationFactoryManager.getEmptyApplicationFactoryManager();
    private static boolean initializedStandardFactories = false;

    private LibraryUtils() {
    }

    public static boolean isDebugOn() {
        return debugLogger.isDebugEnabled();
    }

    public static void debug(String string) {
        debugLogger.debug(EarUtils.addClassName(string));
    }

    public static LibraryReferencer initReferencer(String string, RuntimeMBean runtimeMBean, String string2) {
        return new LibraryReferencer(string, runtimeMBean, string2);
    }

    public static LibraryReferencer initReferencer(ApplicationContextInternal applicationContextInternal, String string) {
        return LibraryUtils.initReferencer(ApplicationVersionUtils.getDisplayName(applicationContextInternal.getApplicationId()), applicationContextInternal.getRuntime(), string);
    }

    public static LibraryReferencer initAppReferencer(ApplicationContextInternal applicationContextInternal) {
        return LibraryUtils.initReferencer(ApplicationVersionUtils.getDisplayName(applicationContextInternal.getApplicationId()), applicationContextInternal.getRuntime(), LibraryUtils.getAppLibRefError());
    }

    public static LibraryReferencer initAppReferencer() {
        return LibraryUtils.initReferencer(null, null, LibraryUtils.getAppLibRefError());
    }

    public static LibraryReferencer initAppReferencer(String string) {
        return LibraryUtils.initReferencer(string, null, LibraryUtils.getAppLibRefError(string));
    }

    public static LibraryReferencer initOptPackReferencer(ApplicationContextInternal applicationContextInternal) {
        return LibraryUtils.initReferencer(ApplicationVersionUtils.getDisplayName(applicationContextInternal.getApplicationId()), applicationContextInternal.getRuntime(), "Unresolved Optional Package references (in META-INF/MANIFEST.MF):");
    }

    public static LibraryReferencer initOptPackReferencer() {
        return LibraryUtils.initReferencer(null, null, "Unresolved Optional Package references (in META-INF/MANIFEST.MF):");
    }

    private static String getAppLibRefError() {
        return LibraryUtils.getAppLibRefError(null);
    }

    private static String getAppLibRefError(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unresolved application library references");
        if (string != null) {
            stringBuffer.append(", for application ").append(string);
        }
        stringBuffer.append(", defined in weblogic-application.xml:");
        return stringBuffer.toString();
    }

    public static String nullOrString(DeweyDecimal deweyDecimal) {
        if (deweyDecimal == null) {
            return null;
        }
        return deweyDecimal.toString();
    }

    public static String getName(LibraryMBean libraryMBean) {
        return libraryMBean.getApplicationName();
    }

    public static String getSpecVersion(LibraryMBean libraryMBean) {
        return ApplicationVersionUtils.getLibSpecVersion(ApplicationVersionUtils.getVersionId(libraryMBean.getName()));
    }

    public static String getImplVersion(LibraryMBean libraryMBean) {
        return ApplicationVersionUtils.getLibImplVersion(ApplicationVersionUtils.getVersionId(libraryMBean.getName()));
    }

    public static String toString(BasicLibraryData basicLibraryData) {
        return LibraryUtils.toString(basicLibraryData.getName(), LibraryUtils.nullOrString(basicLibraryData.getSpecificationVersion()), basicLibraryData.getImplementationVersion());
    }

    public static String toString(LibraryMBean libraryMBean) {
        return LibraryUtils.toString(LibraryUtils.getName(libraryMBean), LibraryUtils.getSpecVersion(libraryMBean), LibraryUtils.getImplVersion(libraryMBean));
    }

    public static void resetAppDDs(ApplicationDescriptor applicationDescriptor, DescriptorUpdater descriptorUpdater) throws LoggableLibraryProcessingException {
        try {
            descriptorUpdater.setApplicationDescriptor(applicationDescriptor);
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
    }

    public static void importAppLibraries(LibraryManager libraryManager, LibraryContext libraryContext, DescriptorUpdater descriptorUpdater) throws LoggableLibraryProcessingException {
        LibraryUtils.importAppLibraries(libraryManager, libraryContext, descriptorUpdater, false);
    }

    public static void importAppLibraries(LibraryManager libraryManager, LibraryContext libraryContext, DescriptorUpdater descriptorUpdater, boolean bl) throws LoggableLibraryProcessingException {
        ApplicationDescriptor applicationDescriptor = libraryContext.getApplicationDescriptor();
        LibraryUtils.populateContextOverrides(libraryContext);
        try {
            descriptorUpdater.setApplicationDescriptor(new ApplicationDescriptor());
            libraryContext.notifyDescriptorUpdate();
            Library[] libraryArray = libraryManager.getReferencedLibraries();
            LibraryReference[] libraryReferenceArray = libraryManager.getLibraryReferences();
            MultiClassFinder multiClassFinder = new MultiClassFinder();
            for (int i = libraryArray.length - 1; i >= 0; --i) {
                LibraryUtils.processLibraryReference((J2EELibraryReference)libraryReferenceArray[i], libraryArray[i], libraryContext, bl, multiClassFinder);
            }
            libraryContext.addClassFinder((ClassFinder)multiClassFinder);
            ApplicationBean applicationBean = libraryContext.getApplicationDD();
            if (applicationBean != null) {
                LibraryUtils.overrideContextRoot(applicationBean, libraryContext.getContextRootOverrideMap());
            }
            LibraryLoggingUtils.updateDescriptor(libraryContext.getApplicationDescriptor(), applicationBean);
            libraryContext.notifyDescriptorUpdate();
            if (applicationDescriptor != null) {
                LibraryLoggingUtils.mergeDescriptors(applicationDescriptor, libraryContext.getApplicationDescriptor());
                descriptorUpdater.setApplicationDescriptor(applicationDescriptor);
                libraryContext.notifyDescriptorUpdate();
            }
            if (LibraryUtils.isDebugOn()) {
                libraryContext.getApplicationDescriptor().dumpMergedApplicationDescriptor(libraryContext.getRefappName());
            }
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
    }

    private static void processLibraryReference(J2EELibraryReference j2EELibraryReference, Library library, LibraryContext libraryContext, boolean bl, MultiClassFinder multiClassFinder) throws LoggableLibraryProcessingException {
        LibraryLoggingUtils.checkIsAppLibrary(library);
        ApplicationLibrary applicationLibrary = (ApplicationLibrary)((Object)library);
        LibraryLoggingUtils.importLibrary(applicationLibrary, j2EELibraryReference, libraryContext, bl, multiClassFinder);
    }

    public static String toString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LibraryConstants.LIBRARY_NAME).append(": ").append(string);
        if (string2 != null) {
            stringBuffer.append(", ").append(LibraryConstants.SPEC_VERSION_NAME).append(": ").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append(", ").append(LibraryConstants.IMPL_VERSION_NAME).append(": ").append(string3);
        }
        return stringBuffer.toString();
    }

    public static J2EELibraryReference[] initLibRefs(File file) throws LibraryProcessingException {
        WeblogicApplicationBean weblogicApplicationBean = null;
        try {
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(VirtualJarFactory.createVirtualJar((File)file));
            weblogicApplicationBean = applicationDescriptor.getWeblogicApplicationDescriptor();
        }
        catch (Exception exception) {
            throw new LibraryProcessingException(exception);
        }
        if (weblogicApplicationBean != null && weblogicApplicationBean.getLibraryRefs() != null) {
            return LibraryLoggingUtils.initLibRefs(weblogicApplicationBean.getLibraryRefs());
        }
        return new J2EELibraryReference[0];
    }

    /*
     * Loose catch block
     */
    public static LibraryReference[] iniOptPackRefs(File file) throws LibraryProcessingException {
        LibraryReference[] libraryReferenceArray;
        VirtualJarFile virtualJarFile;
        block11: {
            Manifest manifest;
            block9: {
                LibraryReference[] libraryReferenceArray2;
                block10: {
                    virtualJarFile = null;
                    virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
                    manifest = virtualJarFile.getManifest();
                    if (manifest != null) break block9;
                    libraryReferenceArray2 = null;
                    Object var5_6 = null;
                    if (virtualJarFile == null) break block10;
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return libraryReferenceArray2;
            }
            libraryReferenceArray = LibraryReferenceFactory.getOptPackReference(file.getAbsolutePath(), manifest.getMainAttributes());
            Object var5_7 = null;
            if (virtualJarFile == null) break block11;
            try {
                virtualJarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return libraryReferenceArray;
        catch (IOException iOException) {
            try {
                throw new LibraryProcessingException(iOException);
            }
            catch (Throwable throwable) {
                block12: {
                    Object var5_8 = null;
                    if (virtualJarFile == null) break block12;
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException2) {}
                }
                throw throwable;
            }
        }
    }

    public static LibraryReference[] initAllOptPacks(File file) throws LibraryProcessingException {
        ArrayList<LibraryReference> arrayList = new ArrayList<LibraryReference>();
        File[] fileArray = FileUtils.find((File)file, (FileFilter)new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && "MANIFEST.MF".equals(file.getName()) && "META-INF".equals(file.getParentFile().getName());
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            LibraryReference[] libraryReferenceArray = LibraryUtils.iniOptPackRefs(fileArray[i].getParentFile().getParentFile());
            if (libraryReferenceArray == null) continue;
            arrayList.addAll(Arrays.asList(libraryReferenceArray));
        }
        return arrayList.toArray(new LibraryReference[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationFactoryManager initDumbAppLibraryFactories() {
        ApplicationFactoryManager applicationFactoryManager = dumbLibFactories;
        synchronized (applicationFactoryManager) {
            if (!initializedDumbFactories) {
                LibraryUtils.initLibraryFactories(dumbLibFactories);
                dumbLibFactories.addLibraryFactory(new WarLibraryFactory.Noop());
                initializedDumbFactories = true;
            }
        }
        return dumbLibFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationFactoryManager initStandardAppLibraryFactories() {
        ApplicationFactoryManager applicationFactoryManager = standardLibFactories;
        synchronized (applicationFactoryManager) {
            if (!initializedStandardFactories) {
                LibraryUtils.initLibraryFactories(standardLibFactories);
                standardLibFactories.addLibraryFactory(new WarLibraryFactory());
                initializedStandardFactories = true;
            }
        }
        return standardLibFactories;
    }

    private static void initLibraryFactories(ApplicationFactoryManager applicationFactoryManager) {
        applicationFactoryManager.addLibraryFactory(new EarLibraryFactory());
        applicationFactoryManager.addLibraryFactory(new EJBLibraryFactory());
        applicationFactoryManager.addDefaultLibraryFactory(new JarLibraryFactory());
    }

    public static void addLibraryUsage(Getopt2 getopt2) {
        String string = "@";
        String string2 = "name";
        String string3 = "libspecver";
        String string4 = "libimplver";
        getopt2.addOption("library", "file", "Comma-separated list of libraries. Each library may optionally set its name and versions, if not already set in its manifest, using the following syntax: <file>[" + string + string2 + "=<string>" + string + string3 + "=<version> " + string + string4 + "=<version|string>]");
        getopt2.addOption("librarydir", "dir", "Registers all files in specified directory as libraries.");
    }

    public static VirtualJarFile[] getLibraryVjarsWithDescriptor(ApplicationContextInternal applicationContextInternal, String string, String string2) throws IOException {
        ArrayList<VirtualJarFile> arrayList = new ArrayList<VirtualJarFile>();
        LibraryProvider libraryProvider = applicationContextInternal.getLibraryProvider(string);
        if (libraryProvider != null) {
            Library[] libraryArray = libraryProvider.getReferencedLibraries();
            for (int i = 0; i < libraryArray.length; ++i) {
                Library library = libraryArray[i];
                VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)library.getLocation());
                if (virtualJarFile.getEntry(string2) != null) {
                    arrayList.add(virtualJarFile);
                    continue;
                }
                virtualJarFile.close();
            }
        }
        return arrayList.toArray(new VirtualJarFile[0]);
    }

    private static void populateContextOverrides(LibraryContext libraryContext) throws LoggableLibraryProcessingException {
        ApplicationDescriptor applicationDescriptor = libraryContext.getApplicationDescriptor();
        try {
            if (applicationDescriptor == null) {
                return;
            }
            WeblogicApplicationBean weblogicApplicationBean = applicationDescriptor.getWeblogicApplicationDescriptor();
            if (weblogicApplicationBean == null) {
                return;
            }
            LibraryContextRootOverrideBean[] libraryContextRootOverrideBeanArray = weblogicApplicationBean.getLibraryContextRootOverrides();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (libraryContextRootOverrideBeanArray != null) {
                if (LibraryUtils.isDebugOn()) {
                    LibraryUtils.debug("Adding LibraryContextRootOverrides ...");
                }
                for (int i = 0; i < libraryContextRootOverrideBeanArray.length; ++i) {
                    if (LibraryUtils.isDebugOn()) {
                        LibraryUtils.debug("Adding LibraryContextRootOverrideBean with context-root '" + libraryContextRootOverrideBeanArray[i].getContextRoot() + "' Override value: '" + libraryContextRootOverrideBeanArray[i].getOverrideValue() + "' ");
                    }
                    if (libraryContextRootOverrideBeanArray[i].getContextRoot() == null || libraryContextRootOverrideBeanArray[i].getOverrideValue() == null) continue;
                    hashMap.put(libraryContextRootOverrideBeanArray[i].getContextRoot(), libraryContextRootOverrideBeanArray[i].getOverrideValue());
                }
            }
            if (!hashMap.isEmpty()) {
                libraryContext.setContextRootOverrideMap(hashMap);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
    }

    private static void overrideContextRoot(ApplicationBean applicationBean, Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            String string;
            if (moduleBeanArray[i].getWeb() == null || (string = moduleBeanArray[i].getWeb().getContextRoot()) == null || map.get(string) == null) continue;
            String string2 = (String)map.get(string);
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("Overriding context-root '" + moduleBeanArray[i].getWeb().getContextRoot() + "' with value '" + string2 + "' from descriptor ");
            }
            moduleBeanArray[i].getWeb().setContextRoot(string2);
            if (!LibraryUtils.isDebugOn()) continue;
            LibraryUtils.debug("Context root from Descriptor '" + moduleBeanArray[i].getWeb().getContextRoot() + "'");
        }
    }
}

