/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import weblogic.application.utils.DiscoveredModule;
import weblogic.application.utils.DiscoveredModuleFactory;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.utils.application.WarDetector;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDiscovery {
    private static final int MAX_NESTED_DIR_DEPTH = 6;
    static final boolean debug = false;
    private static String[] knownExtensions = null;
    private static final FileFilter EXT_OR_DIR;

    private ModuleDiscovery() {
    }

    public static ApplicationBean discoverModules(VirtualJarFile virtualJarFile) throws IOException {
        if (virtualJarFile.isDirectory()) {
            File[] fileArray = virtualJarFile.getRootFiles();
            if (fileArray.length == 1) {
                return ModuleDiscovery.discoverModules(fileArray[0]);
            }
            return ModuleDiscovery.discoverModules(fileArray);
        }
        return ModuleDiscovery.discoverModulesArchived(virtualJarFile);
    }

    public static ApplicationBean discoverModules(File file) throws IOException {
        LinkedList<DiscoveredModule> linkedList = new LinkedList<DiscoveredModule>();
        ModuleDiscovery.findModules(file, linkedList);
        return ModuleDiscovery.populateAppBean(linkedList);
    }

    public static ApplicationBean discoverModules(File[] fileArray) throws IOException {
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        LinkedList<DiscoveredModule> linkedList = new LinkedList<DiscoveredModule>();
        for (int i = 0; i < fileArray.length; ++i) {
            ModuleDiscovery.findModules(fileArray[i], fileArray[i], 0, linkedList, true);
        }
        return ModuleDiscovery.populateAppBean(linkedList);
    }

    static void findModules(File file, List<DiscoveredModule> list) throws IOException {
        ModuleDiscovery.findModules(file, file, 0, list, false);
    }

    private static void findModules(File file, File file2, int n, List<DiscoveredModule> list, boolean bl) throws IOException {
        assert (file2.isDirectory());
        if (++n > 6) {
            return;
        }
        URI uRI = file.toURI();
        File[] fileArray = file2.listFiles(EXT_OR_DIR);
        for (int i = 0; i < fileArray.length; ++i) {
            URI uRI2 = uRI.relativize(fileArray[i].toURI());
            String string = uRI2.toString();
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ("APP-INF".equals(string) || "lib".equals(string) || bl && ModuleDiscovery.sawRelativePath(string, list)) continue;
            DiscoveredModule discoveredModule = DiscoveredModuleFactory.makeDiscoveredModule(fileArray[i], string);
            if (discoveredModule != null) {
                list.add(discoveredModule);
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            ModuleDiscovery.findModules(file, fileArray[i], n, list, bl);
        }
    }

    private static boolean sawRelativePath(String string, List<DiscoveredModule> list) {
        for (DiscoveredModule discoveredModule : list) {
            if (!string.startsWith(discoveredModule.getURI())) continue;
            return true;
        }
        return false;
    }

    private static ApplicationBean populateAppBean(List<DiscoveredModule> list) {
        ApplicationBean applicationBean = null;
        if (list.size() > 0) {
            applicationBean = (ApplicationBean)new DescriptorManager().createDescriptorRoot(ApplicationBean.class).getRootBean();
            for (DiscoveredModule discoveredModule : list) {
                discoveredModule.createModule(applicationBean);
            }
        }
        return applicationBean;
    }

    public static ApplicationBean discoverModulesArchived(VirtualJarFile virtualJarFile) throws IOException {
        ArrayList<DiscoveredModule> arrayList = new ArrayList<DiscoveredModule>();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            assert (!virtualJarFile.isDirectory());
            Iterator iterator = virtualJarFile.entries();
            while (iterator.hasNext()) {
                DiscoveredModule discoveredModule;
                ZipEntry zipEntry = (ZipEntry)iterator.next();
                String string = zipEntry.getName();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (ModuleDiscovery.alreadyClaimedPath(hashSet, string) || (discoveredModule = DiscoveredModuleFactory.makeDiscoveredModule(virtualJarFile, zipEntry, string)) == null) continue;
                hashSet.add(string);
                arrayList.add(discoveredModule);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ModuleDiscovery.populateAppBean(arrayList);
    }

    private static boolean alreadyClaimedPath(Set<String> set, String string) {
        if (set.contains(string)) {
            return true;
        }
        for (String string2 : set) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static void dumpBean(ApplicationBean applicationBean) throws IOException {
        new DescriptorManager().writeDescriptorAsXML(((DescriptorBean)applicationBean).getDescriptor(), (OutputStream)System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Usage: java " + ModuleDiscovery.class.getName() + " <ear | dir>");
            return;
        }
        ApplicationBean applicationBean = null;
        long l = System.currentTimeMillis();
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(stringArray[0]));
            applicationBean = ModuleDiscovery.discoverModules(virtualJarFile);
            long l2 = System.currentTimeMillis();
            if (applicationBean != null) {
                ModuleDiscovery.dumpBean(applicationBean);
            } else {
                System.out.println("AppBean is null");
            }
            System.out.println("Elapsed: " + (l2 - l));
            Object var8_5 = null;
            if (virtualJarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (virtualJarFile == null) throw throwable;
            try {
                virtualJarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            virtualJarFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    static {
        String[] stringArray = WarDetector.instance.getSuffixes();
        knownExtensions = new String[stringArray.length + 2];
        int n = 0;
        for (String string : stringArray) {
            ModuleDiscovery.knownExtensions[n++] = string;
        }
        ModuleDiscovery.knownExtensions[n++] = ".jar";
        ModuleDiscovery.knownExtensions[n++] = ".rar";
        EXT_OR_DIR = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                for (int i = 0; i < knownExtensions.length; ++i) {
                    if (!string.endsWith(knownExtensions[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

