/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import weblogic.application.ApplicationAccess;
import weblogic.application.internal.FlowContext;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.J2EEApplicationService;

public final class PathUtils {
    public static File getAppTempDir(String string, String string2) {
        return PathUtils.getAppTempDir(string, string2, null);
    }

    public static File getAppTempDir(String string, String string2, String string3) {
        return PathUtils.getAppTempDir(PathUtils.generateTempPath(string, string2, string3));
    }

    public static File getAppTempDir(String string) {
        FlowContext flowContext = (FlowContext)ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
        boolean bl = flowContext == null ? false : flowContext.isInternalApp();
        return PathUtils.getAppTempDir(string, bl);
    }

    public static File getAppTempDir(String string, boolean bl) {
        return new File(PathUtils.getRootTempDir(bl), string);
    }

    private static File getRootTempDir(boolean bl) {
        if (bl) {
            return TempPaths.internalAppTmpRoot;
        }
        return TempPaths.userAppTmpRoot;
    }

    public static String generateTempPath(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (string2 != null) {
            stringBuffer.append("_").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append("_").append(string3);
        }
        return string2 + File.separator + Long.toString(Math.abs(stringBuffer.toString().hashCode()), 36);
    }

    public static File generateDescriptorCacheDir(String string, String string2, boolean bl) {
        return new File(PathUtils.getRootTempDir(bl), PathUtils.generateTempPath(string, ApplicationVersionUtils.replaceDelimiter(string2, '_'), "__WL_DescriptorCache"));
    }

    private static final class TempPaths {
        private static final File tmpRoot = J2EEApplicationService.getTempDir();
        private static final File userAppTmpRoot = new File(tmpRoot, "_WL_user");
        private static final File internalAppTmpRoot = new File(tmpRoot, "_WL_internal");

        private TempPaths() {
        }
    }
}

