/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import weblogic.application.utils.IOUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class PersistenceUtils {
    private static final String persistenceUri = "META-INF/persistence.xml";
    private static final FileFilter JARFILE = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".jar") && file.isFile();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRootPersistenceJars(GenericClassLoader genericClassLoader, String string, ApplicationBean applicationBean) throws IOException {
        File[] fileArray = PersistenceUtils.getApplicationRoots(genericClassLoader, string, false);
        HashSet hashSet = null;
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2 = fileArray[i].listFiles(JARFILE);
            if (fileArray2 == null) continue;
            for (int j = 0; j < fileArray2.length; ++j) {
                Object var12_11;
                File file;
                String string2;
                if (hashSet == null) {
                    hashSet = new HashSet();
                    PersistenceUtils.loadJarModuleUris(applicationBean, hashSet);
                }
                if (hashSet.contains(string2 = PersistenceUtils.getSimpleName(file = fileArray2[j]))) continue;
                VirtualJarFile virtualJarFile = null;
                try {
                    virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
                    if (virtualJarFile.getEntries(persistenceUri).hasNext()) {
                        genericClassLoader.addClassFinder((ClassFinder)new JarClassFinder(file));
                    }
                    var12_11 = null;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    IOUtils.forceClose(virtualJarFile);
                    throw throwable;
                }
                IOUtils.forceClose(virtualJarFile);
                {
                    continue;
                }
            }
        }
    }

    private static String getSimpleName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(File.pathSeparator);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static void loadJarModuleUris(ApplicationBean applicationBean, Set set) {
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray != null) {
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                ModuleBean moduleBean = moduleBeanArray[i];
                if (moduleBean.isEjbSet() && moduleBean.getEjb() != null) {
                    set.add(moduleBean.getEjb());
                    continue;
                }
                if (!moduleBean.isJavaSet() || moduleBean.getJava() == null) continue;
                set.add(moduleBean.getJava());
            }
        }
    }

    public static File[] getApplicationRoots(GenericClassLoader genericClassLoader, String string, boolean bl) throws IOException {
        Enumeration enumeration = genericClassLoader.getResources(string + "#/");
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            File file = new File(((URL)enumeration.nextElement()).getFile());
            if (bl) {
                arrayList.add(file.getCanonicalFile());
                continue;
            }
            arrayList.add(file);
        }
        if (bl) {
            return arrayList.toArray(new File[0]);
        }
        return arrayList.toArray(new File[0]);
    }
}

