/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import weblogic.application.utils.DiscoveredModule;
import weblogic.application.utils.DiscoveredModuleFactory;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.utils.jars.VirtualJarFile;

class RarDiscoveredModuleFactory
extends DiscoveredModuleFactory {
    RarDiscoveredModuleFactory() {
    }

    public final DiscoveredModule claim(File file, String string) {
        if (!file.getName().endsWith(".rar")) {
            return null;
        }
        return new RarDiscoveredModule(string);
    }

    public final DiscoveredModule claim(VirtualJarFile virtualJarFile, ZipEntry zipEntry, String string) throws IOException {
        if (string.endsWith(".rar")) {
            return new RarDiscoveredModule(string);
        }
        return null;
    }

    private static class RarDiscoveredModule
    implements DiscoveredModule {
        private final String relPath;

        public RarDiscoveredModule(String string) {
            this.relPath = string;
        }

        public void createModule(ApplicationBean applicationBean) {
            ModuleBean moduleBean = applicationBean.createModule();
            moduleBean.setConnector(this.relPath);
        }

        public String getURI() {
            return this.relPath;
        }
    }
}

