/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.File;
import java.util.ArrayList;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.internal.flow.ModuleListenerInvoker;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.ejb.container.deployer.EJBDeployer;
import weblogic.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecPermSpecUtils {
    static String insertPermission(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null || string.trim().length() == 0) {
            if (string2 != null && string2.trim().length() > 0) {
                stringBuilder.append(string2);
            }
        } else if (string2 == null || string2.trim().length() == 0) {
            if (string != null && string.trim().length() > 0) {
                stringBuilder.append("grant {");
                stringBuilder.append(string);
                stringBuilder.append("};");
            }
        } else {
            stringBuilder.append(string2);
            int n = stringBuilder.indexOf("}");
            if (n != -1) {
                stringBuilder.insert(n - 1, string);
            }
        }
        return stringBuilder.toString();
    }

    private static ArrayList<Module> findEJBModules(ApplicationContextInternal applicationContextInternal) {
        Module[] moduleArray;
        ArrayList<Module> arrayList = null;
        if (applicationContextInternal != null && (moduleArray = applicationContextInternal.getApplicationModules()) != null && moduleArray.length > 0) {
            arrayList = new ArrayList<Module>();
            for (Module module : moduleArray) {
                ModuleListenerInvoker moduleListenerInvoker;
                Module module2;
                if (!(module instanceof ModuleListenerInvoker) || !WebLogicModuleType.MODULETYPE_EJB.equalsIgnoreCase((module2 = (moduleListenerInvoker = (ModuleListenerInvoker)module).getDelegate()).getType())) continue;
                arrayList.add(module2);
            }
        }
        return arrayList;
    }

    private static String constructReadPermsForEJBCompilerCacheDirs(ApplicationContextInternal applicationContextInternal) {
        ArrayList<Module> arrayList = SecPermSpecUtils.findEJBModules(applicationContextInternal);
        StringBuilder stringBuilder = null;
        if (arrayList != null && arrayList.size() > 0) {
            stringBuilder = new StringBuilder();
            File file = EJBDeployer.getEjbCompilerCacheDir();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = applicationContextInternal.getApplicationId();
                String string2 = arrayList.get(i).getId();
                File file2 = new File(file, StringUtils.mangle((String)(string + "_" + string2)));
                stringBuilder.append("\npermission java.io.FilePermission \"" + file2.getAbsolutePath() + System.getProperty("file.separator") + "-\", \"read\";\n");
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static String getNewSecurityPermissionSpec(ApplicationContextInternal applicationContextInternal, String string) {
        return SecPermSpecUtils.insertPermission(SecPermSpecUtils.constructReadPermsForEJBCompilerCacheDirs(applicationContextInternal), string);
    }
}

