/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import weblogic.application.utils.StateChange;
import weblogic.application.utils.StateChangeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.ErrorCollectionException;
import weblogic.work.ContextWrap;
import weblogic.work.WorkManagerFactory;

public final class StateMachineDriver {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG_TIMINGS = Boolean.getBoolean("weblogic.DEBUG_TIMINGS");
    private static final boolean USE_WORKMANAGER = !Boolean.getBoolean("weblogic.application.prepare.USE_JAVA_THREADS");

    public void nextState(StateChange stateChange, Object[] objectArray) throws StateChangeException {
        long l;
        long l2 = l = System.nanoTime();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                long l3 = System.nanoTime();
                stateChange.next(objectArray[i]);
                if (!DEBUG_TIMINGS) continue;
                l2 = System.nanoTime();
                System.out.println("JEEINST:application.StateMachine.nextState:" + (l2 - l3) + ":" + stateChange + ":" + objectArray[i]);
                l3 = l2;
                continue;
            }
            catch (Throwable throwable) {
                try {
                    this.previousState(stateChange, objectArray, i);
                }
                catch (StateChangeException stateChangeException) {
                    stateChange.logRollbackError(stateChangeException);
                }
                throw new StateChangeException(throwable);
            }
        }
        if (DEBUG_TIMINGS) {
            System.out.println("JEEINST:application.StateMachine.nextState(elapsed):" + (l2 - l) + ":" + stateChange);
        }
    }

    public void nextStateInParallel(StateChange stateChange, Object[] objectArray) throws StateChangeException {
        long l = System.nanoTime();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(objectArray.length);
        ErrorCollectionException errorCollectionException = new ParallelChange[objectArray.length];
        AuthenticatedSubject authenticatedSubject = null;
        if (!USE_WORKMANAGER) {
            authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            errorCollectionException[i] = new ParallelChange(objectArray[i], stateChange, authenticatedSubject, countDownLatch);
            if (USE_WORKMANAGER) {
                object = new ContextWrap(errorCollectionException[i]);
                WorkManagerFactory.getInstance().getSystem().schedule((Runnable)object);
                continue;
            }
            object = new Thread(errorCollectionException[i]);
            ((Thread)object).start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new StateChangeException(interruptedException);
        }
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (ParallelChange parallelChange : errorCollectionException) {
            if (parallelChange.result == null) continue;
            arrayList.add(parallelChange.result);
        }
        if (DEBUG_TIMINGS) {
            long l2 = System.nanoTime();
            System.out.println("JEEINST:application.StateMachine.nextStateInParallel(elapsed):" + (l2 - l) + ":" + stateChange);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (ParallelChange parallelChange : errorCollectionException) {
            if (parallelChange.result != null) continue;
            try {
                stateChange.previous(parallelChange.target);
            }
            catch (StateChangeException stateChangeException) {
                arrayList.add(stateChangeException);
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        ErrorCollectionException errorCollectionException2 = new ErrorCollectionException();
        for (Throwable throwable : arrayList) {
            errorCollectionException2.add(throwable);
        }
        throw new StateChangeException((Throwable)errorCollectionException2);
    }

    public void previousState(StateChange stateChange, Object[] objectArray) throws StateChangeException {
        this.previousState(stateChange, objectArray, objectArray.length);
    }

    private void previousState(StateChange stateChange, Object[] objectArray, int n) throws StateChangeException {
        ErrorCollectionException errorCollectionException = null;
        for (int i = n - 1; i >= 0; --i) {
            try {
                stateChange.previous(objectArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                errorCollectionException.addError(throwable);
            }
        }
        if (errorCollectionException != null) {
            throw new StateChangeException((Throwable)errorCollectionException);
        }
    }

    static class ParallelChange
    implements Runnable {
        final Object target;
        final StateChange change;
        final AuthenticatedSubject subject;
        CountDownLatch latch;
        Throwable result;

        ParallelChange(Object object, StateChange stateChange, AuthenticatedSubject authenticatedSubject, CountDownLatch countDownLatch) {
            this.target = object;
            this.change = stateChange;
            this.subject = authenticatedSubject;
            this.latch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doWork() {
            try {
                block4: {
                    try {
                        long l = System.nanoTime();
                        this.change.next(this.target);
                        if (!DEBUG_TIMINGS) break block4;
                        long l2 = System.nanoTime();
                        System.out.println("JEEINST:application.StateMachine.nextState(ParallelChange):" + (l2 - l) + ":" + this.change + ":" + this.target);
                        l = System.nanoTime();
                    }
                    catch (Throwable throwable) {
                        this.result = throwable;
                        Object var6_5 = null;
                        this.latch.countDown();
                    }
                }
                Object var6_4 = null;
                this.latch.countDown();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.latch.countDown();
                throw throwable;
            }
            return null;
        }

        public void run() {
            if (USE_WORKMANAGER) {
                this.doWork();
            } else {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)this.subject, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return ParallelChange.this.doWork();
                    }
                });
            }
        }
    }
}

