/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.security.AccessController;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.EarUtils;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class TargetUtils {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static TargetMBean findLocalServerTarget(TargetMBean[] targetMBeanArray) {
        if (targetMBeanArray == null) {
            return null;
        }
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        return TargetUtils.findLocalTarget(targetMBeanArray, serverMBean);
    }

    public static TargetMBean findLocalTarget(TargetMBean[] targetMBeanArray, ServerMBean serverMBean) {
        if (targetMBeanArray == null) {
            return null;
        }
        String string = serverMBean.getName();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean;
            if (targetMBeanArray[i] instanceof ClusterMBean) {
                if (serverMBean.getCluster() == null || !serverMBean.getCluster().getName().equals(targetMBeanArray[i].getName())) continue;
                return targetMBeanArray[i];
            }
            if (targetMBeanArray[i] instanceof VirtualHostMBean) {
                targetMBean = (VirtualHostMBean)targetMBeanArray[i];
                if (!TargetUtils.isDeployedLocally(targetMBean.getTargets())) continue;
                return targetMBean;
            }
            if (targetMBeanArray[i] instanceof JMSServerMBean) {
                targetMBean = (JMSServerMBean)targetMBeanArray[i];
                if (!TargetUtils.isDeployedLocally(targetMBean.getTargets())) continue;
                return targetMBean;
            }
            if (targetMBeanArray[i] instanceof SAFAgentMBean) {
                targetMBean = (SAFAgentMBean)targetMBeanArray[i];
                return TargetUtils.findLocalTarget(targetMBean.getTargets(), serverMBean);
            }
            if (!targetMBeanArray[i].getName().equals(string)) continue;
            return targetMBeanArray[i];
        }
        return null;
    }

    public static boolean isDeployedLocally(TargetMBean[] targetMBeanArray) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        return TargetUtils.findLocalTarget(targetMBeanArray, serverMBean) != null;
    }

    private static SubDeploymentMBean findSubDeployment(SubDeploymentMBean[] subDeploymentMBeanArray, ApplicationContextInternal applicationContextInternal, String string) {
        if (subDeploymentMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            String string2;
            String string3 = string2 = applicationContextInternal != null ? EarUtils.toModuleId(applicationContextInternal, subDeploymentMBeanArray[i].getName()) : subDeploymentMBeanArray[i].getName();
            if (!string.equals(string2)) continue;
            return subDeploymentMBeanArray[i];
        }
        return null;
    }

    public static TargetMBean[] findModuleTargets(BasicDeploymentMBean basicDeploymentMBean, BasicDeploymentMBean basicDeploymentMBean2, String string) {
        return TargetUtils.findModuleTargets(basicDeploymentMBean, basicDeploymentMBean2, null, string);
    }

    public static TargetMBean[] findModuleTargets(BasicDeploymentMBean basicDeploymentMBean, BasicDeploymentMBean basicDeploymentMBean2, ApplicationContextInternal applicationContextInternal, String string) {
        BasicDeploymentMBean basicDeploymentMBean3 = basicDeploymentMBean != null ? basicDeploymentMBean : basicDeploymentMBean2;
        SubDeploymentMBean subDeploymentMBean = TargetUtils.findSubDeployment(basicDeploymentMBean3.getSubDeployments(), applicationContextInternal, string);
        if (subDeploymentMBean == null || subDeploymentMBean.getTargets() == null || subDeploymentMBean.getTargets().length == 0) {
            return basicDeploymentMBean3.getTargets();
        }
        return subDeploymentMBean.getTargets();
    }

    public static boolean isModuleDeployedHere(BasicDeploymentMBean basicDeploymentMBean, String string) {
        SubDeploymentMBean subDeploymentMBean = TargetUtils.findSubDeployment(basicDeploymentMBean.getSubDeployments(), null, string);
        if (subDeploymentMBean != null && subDeploymentMBean.getTargets() != null && subDeploymentMBean.getTargets().length != 0) {
            return TargetUtils.isDeployedLocally(subDeploymentMBean.getTargets());
        }
        return TargetUtils.isDeployedLocally(basicDeploymentMBean.getTargets());
    }

    public static TargetMBean findLocalTarget(BasicDeploymentMBean basicDeploymentMBean, ServerMBean serverMBean) {
        TargetMBean[] targetMBeanArray = basicDeploymentMBean.getTargets();
        TargetMBean targetMBean = null;
        if (targetMBeanArray != null) {
            targetMBean = TargetUtils.findLocalTarget(targetMBeanArray, serverMBean);
        }
        if (targetMBean == null) {
            SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
            if (targetMBean != null) {
                SubDeploymentMBean subDeploymentMBean;
                for (int i = 0; i < subDeploymentMBeanArray.length && (targetMBean = TargetUtils.findLocalTarget((subDeploymentMBean = subDeploymentMBeanArray[i]).getTargets(), serverMBean)) == null; ++i) {
                }
            }
        }
        if (targetMBean == null) {
            targetMBean = serverMBean;
        }
        return targetMBean;
    }
}

