/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import weblogic.utils.jars.VirtualJarFile;

public class VirtualJarFileMetaDataIterator
implements MetaDataIterator,
MetaDataFilter.Resource {
    private final VirtualJarFile _vjf;
    private final MetaDataFilter _filter;
    private final Iterator _entries;
    private ZipEntry _entry = null;
    private ZipEntry _last = null;

    public VirtualJarFileMetaDataIterator(VirtualJarFile virtualJarFile, MetaDataFilter metaDataFilter) {
        this._vjf = virtualJarFile;
        this._filter = metaDataFilter;
        this._entries = this._vjf == null ? null : this._vjf.entries();
    }

    public boolean hasNext() throws IOException {
        if (this._entries == null) {
            return false;
        }
        while (this._entry == null && this._entries.hasNext()) {
            this._entry = (ZipEntry)this._entries.next();
            if (this._filter == null || this._filter.matches((MetaDataFilter.Resource)this)) continue;
            this._entry = null;
        }
        return this._entry != null;
    }

    public Object next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this._entry.getName();
        this._last = this._entry;
        this._entry = null;
        return string;
    }

    public InputStream getInputStream() throws IOException {
        if (this._last == null) {
            throw new IllegalStateException();
        }
        return this._vjf.getInputStream(this._last);
    }

    public File getFile() {
        if (this._last == null) {
            throw new IllegalStateException();
        }
        return null;
    }

    public void close() {
    }

    public String getName() {
        return this._entry.getName();
    }

    public byte[] getContent() throws IOException {
        byte[] byArray;
        long l = this._entry.getSize();
        if (l == 0L) {
            return new byte[0];
        }
        InputStream inputStream = this._vjf.getInputStream(this._entry);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        if (l < 0L) {
            int n;
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            int n = 0;
            while ((long)(n = inputStream.read(byArray2)) < l) {
                l -= (long)n;
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.write(byArray2, 0, n);
            byArray = byteArrayOutputStream.toByteArray();
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return byArray;
    }
}

