/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.utils;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class XMLWriter {
    private static final String sep = System.getProperty("line.separator");
    private static final int DEFAULT_INDENT = 2;
    private static final int DEFAULT_MAX_ATTRS_ON_SAME_LINE = 2;
    private boolean wroteFirstElement = false;
    private boolean hasElements = false;
    private boolean incompleteOpenTag = false;
    private boolean hasAttributes = false;
    private boolean closeOnNewLine = false;
    private final Stack elementStack = new Stack();
    private final PrintWriter pw;
    private final int indent;
    private final int maxAttrsOnSameLine;
    private boolean textOnSameLineAsParentElement = true;

    public XMLWriter(PrintWriter printWriter) {
        this(printWriter, 2);
    }

    public XMLWriter(PrintWriter printWriter, int n) {
        this(printWriter, n, 2);
    }

    public XMLWriter(PrintWriter printWriter, int n, int n2) {
        this.indent = n;
        this.maxAttrsOnSameLine = n2;
        this.pw = printWriter;
    }

    public void flush() {
        this.pw.flush();
    }

    public void startDocumentDTD(String string, String string2, String string3) {
        if (this.hasElements) {
            throw new MalformedXMLRuntimeException("Cannot init document after elements have been added");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE ").append(string);
        if (string2 != null) {
            stringBuffer.append(" PUBLIC \"").append(string2).append("\"");
        }
        if (string3 != null) {
            stringBuffer.append(" \"").append(string3).append("\"");
        }
        stringBuffer.append(">").append(sep);
        this.writeGeneric(stringBuffer.toString());
    }

    public void setTextOnSameLineAsParentElement(boolean bl) {
        this.textOnSameLineAsParentElement = bl;
    }

    public void addComment(String string) {
        this.finishIncompleteTag();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sep).append(this.getIndent()).append("<!--").append(string).append("-->");
        this.writeGeneric(stringBuffer.toString());
    }

    public void addAttribute(String string, String string2) {
        if (!this.incompleteOpenTag) {
            throw new MalformedXMLRuntimeException("Illegal call to addAttribute");
        }
        this.hasAttributes = true;
        if (this.closeOnNewLine) {
            this.pw.print(sep);
            this.pw.print(this.getIndent());
        } else {
            this.pw.print(" ");
        }
        this.pw.print(string);
        this.pw.print("=\"");
        this.pw.print(string2);
        this.pw.print("\"");
    }

    public void addAttribute(Map map) {
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            stringArray[n] = (String)entry.getKey();
            stringArray[n + 1] = (String)entry.getValue();
            n += 2;
        }
        this.addAttribute(stringArray);
    }

    public void addAttribute(String[] stringArray) {
        if (!this.hasAttributes && stringArray.length / 2 > this.maxAttrsOnSameLine) {
            this.closeOnNewLine = true;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            this.addAttribute(string, string2);
        }
    }

    public void addNestedElements(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addElement(stringArray[i]);
        }
    }

    public void addEmptyElements(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addEmptyElement(stringArray[i]);
        }
    }

    public void addEmptyElement(String string) {
        this.addElement(string);
        this.closeElement();
    }

    public void addElement(String string) {
        this.hasElements = true;
        this.finishIncompleteTag();
        if (this.wroteFirstElement) {
            this.pw.print(sep);
        } else {
            this.wroteFirstElement = true;
        }
        this.pw.print(this.getIndent());
        this.pw.print("<");
        this.pw.print(string);
        this.elementStack.push(string);
        this.incompleteOpenTag = true;
        this.hasAttributes = false;
        this.closeOnNewLine = false;
    }

    public void addElement(String string, String string2) {
        this.addElement(string);
        this.addText(string2, !this.textOnSameLineAsParentElement);
        this.closeElement(!this.textOnSameLineAsParentElement);
    }

    public void addElement(String string, String[] stringArray) {
        this.addElement(string);
        this.addAttribute(stringArray);
    }

    public void closeElement() {
        this.closeElement(true);
    }

    private void closeElement(boolean bl) {
        if (this.elementStack.isEmpty()) {
            throw new MalformedXMLRuntimeException("Illegal call to closeElement");
        }
        String string = this.elementStack.pop();
        if (this.incompleteOpenTag) {
            if (this.closeOnNewLine) {
                this.pw.print(sep);
                this.pw.print(this.getIndent());
            }
            this.pw.print("/>");
            this.incompleteOpenTag = false;
        } else {
            if (bl) {
                this.pw.print(sep);
                this.pw.print(this.getIndent());
            }
            this.pw.print("</");
            this.pw.print(string);
            this.pw.print(">");
        }
        this.hasAttributes = false;
    }

    public void addText(String string) {
        this.addText(string, true);
    }

    private void addText(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        this.finishIncompleteTag();
        if (bl) {
            this.pw.print(sep);
            this.pw.print(this.getIndent());
        }
        this.pw.print(string.trim());
    }

    public void addCDATA(String string) {
        if (string.trim().length() == 0) {
            return;
        }
        this.finishIncompleteTag();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sep).append(this.getIndent()).append("<![CDATA[");
        String string2 = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, sep);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(sep).append(this.getIndent()).append(this.getIndentUnit()).append(stringTokenizer.nextToken().trim());
        }
        stringBuffer.append(sep).append(this.getIndent()).append("]]>");
        this.writeGeneric(stringBuffer.toString());
    }

    public void finish() {
        this.closeAll();
        this.pw.flush();
    }

    private void closeAll() {
        while (!this.elementStack.isEmpty()) {
            this.closeElement();
        }
    }

    private void finishIncompleteTag() {
        if (this.incompleteOpenTag) {
            if (this.closeOnNewLine) {
                this.pw.print(sep);
                this.pw.print(this.getIndent(this.getStackSize() - 1));
            }
            this.pw.print(">");
            this.incompleteOpenTag = false;
        }
    }

    private void writeGeneric(String string) {
        this.pw.print(string);
    }

    private String getIndent() {
        return this.getIndent(this.getStackSize());
    }

    private String getIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n * this.indent;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String getIndentUnit() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private int getStackSize() {
        return this.elementStack.size();
    }

    public static void main(String[] stringArray) {
        XMLWriter xMLWriter = new XMLWriter(new PrintWriter(System.out), 2, 3);
        xMLWriter.addElement("project");
        xMLWriter.addAttribute("name", "foo-project");
        xMLWriter.addAttribute("default", "default-target");
        xMLWriter.addAttribute("a3", "v3");
        xMLWriter.addAttribute("a4", "v4");
        xMLWriter.addElement("description", "this is a project of some sort");
        xMLWriter.addComment("A comment between description and target");
        xMLWriter.addElement("target", new String[]{"a1", "v1", "a2", "v2", "a3", "v3"});
        xMLWriter.addAttribute("name", "default-target");
        xMLWriter.addAttribute("a5", "v5");
        xMLWriter.addElement("test-suite");
        xMLWriter.addAttribute("testunit", "foo-testunit");
        xMLWriter.addElement("test");
        xMLWriter.addAttribute("name", "foo-test");
        xMLWriter.addElement("javatest");
        xMLWriter.addAttribute("testclass", "weblogic.qa.frame.test.foo");
        xMLWriter.addCDATA("Some CDATA nested inside the second \"javatest\" element");
        xMLWriter.closeElement();
        xMLWriter.addElement("javatest", new String[]{"a1", "v1", "a2", "v2", "a3", "v3", "a4", "v4"});
        xMLWriter.addText("Some text nested inside the second \"javatest\" element");
        xMLWriter.closeElement();
        xMLWriter.addElement("javatest", new String[]{"a1", "v1", "a2", "v2", "a3", "v3"});
        xMLWriter.closeElement();
        xMLWriter.addComment("Some nested elements");
        xMLWriter.addNestedElements(new String[]{"e1", "e2", "e3", "e4"});
        xMLWriter.finish();
        System.out.println(sep);
    }

    private class Stack
    extends ArrayList {
        private static final long serialVersionUID = -7341083262157803283L;

        private Stack() {
        }

        public void push(String string) {
            super.add(0, string);
        }

        public String pop() {
            return (String)super.remove(0);
        }
    }

    private class MalformedXMLRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 5122932004316476798L;

        private MalformedXMLRuntimeException(String string) {
            super(string);
        }
    }
}

