/*
 * Decompiled with CFR 0.152.
 */
package weblogic.aspects;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import weblogic.aspects.AspectSystem;
import weblogic.aspects.AspectSystemClassFinder;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassPreProcessor;
import weblogic.utils.classloaders.ClasspathClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class AspectClassPreProcessor
implements ClassPreProcessor {
    public static final Logger logger = Logger.getLogger("weblogic.aspects");
    private Map classLoaderMap = new WeakHashMap();
    private boolean creating = false;
    private static AspectBundle NULL_BUNDLE = new AspectBundle();

    public void initialize(Hashtable hashtable) {
    }

    public byte[] preProcess(String string, byte[] byArray) {
        GenericClassLoader genericClassLoader;
        AspectBundle aspectBundle;
        ClassLoader classLoader;
        for (classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null && !(classLoader instanceof GenericClassLoader); classLoader = classLoader.getParent()) {
        }
        if (!(!(classLoader instanceof GenericClassLoader) || (aspectBundle = this.getAspectSystem(genericClassLoader = (GenericClassLoader)classLoader)) == null || aspectBundle.aspectIncludePattern != null && !aspectBundle.aspectIncludePattern.matcher(string).find() || aspectBundle.aspectExcludePattern != null && aspectBundle.aspectExcludePattern.matcher(string).find())) {
            try {
                byte[] byArray2 = aspectBundle.aspectSystem.weaveClass(string, byArray);
                return byArray2 == null ? byArray : byArray2;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not weave class " + string, iOException);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AspectBundle getAspectSystem(GenericClassLoader genericClassLoader) {
        AspectBundle aspectBundle;
        block7: {
            if (this.creating) {
                return null;
            }
            aspectBundle = (AspectBundle)this.classLoaderMap.get(genericClassLoader);
            if (aspectBundle == NULL_BUNDLE) {
                return null;
            }
            if (aspectBundle == null) {
                this.creating = true;
                try {
                    aspectBundle = AspectClassPreProcessor.createAspectSystem(genericClassLoader);
                    if (aspectBundle != null) {
                        this.classLoaderMap.put(genericClassLoader, aspectBundle);
                        break block7;
                    }
                    this.classLoaderMap.put(genericClassLoader, NULL_BUNDLE);
                    AspectBundle aspectBundle2 = null;
                    return aspectBundle2;
                }
                finally {
                    this.creating = false;
                }
            }
        }
        return aspectBundle;
    }

    private static AspectBundle createAspectSystem(GenericClassLoader genericClassLoader) {
        try {
            String string = null;
            String string2 = null;
            String string3 = null;
            Properties properties = new Properties();
            Object object = genericClassLoader;
            Object object2 = AspectClassPreProcessor.getSourceAsStream("wlaspect.properties", genericClassLoader);
            while (object2 != null) {
                Properties properties2 = new Properties();
                properties2.load((InputStream)object2);
                ((InputStream)object2).close();
                String string4 = (String)properties2.remove("aspect.system");
                if (string4 != null && (string3 == null || string4.equals(string3)) && !"false".equals(properties2.remove("aspect.enable"))) {
                    string2 = AspectClassPreProcessor.addToRegex((String)properties2.remove("aspect.exclude"), string2);
                    string = AspectClassPreProcessor.addToRegex((String)properties2.remove("aspect.include"), string);
                    string3 = string4;
                    for (String string5 : properties2.keySet()) {
                        if (properties.contains(string5)) continue;
                        properties.setProperty(string5, properties2.getProperty(string5));
                    }
                }
                if ((object = ((ClassLoader)object).getParent()) instanceof GenericClassLoader) {
                    object2 = AspectClassPreProcessor.getSourceAsStream("wlaspect.properties", (GenericClassLoader)object);
                    continue;
                }
                if (object != null) {
                    object2 = ((ClassLoader)object).getResourceAsStream("wlaspect.properties");
                    continue;
                }
                object2 = null;
            }
            if (string3 == null) {
                logger.info("Could not find aspect.system property");
                return null;
            }
            object2 = new AspectBundle();
            if (string != null) {
                ((AspectBundle)object2).aspectIncludePattern = Pattern.compile(string);
            }
            if (string2 != null) {
                ((AspectBundle)object2).aspectExcludePattern = Pattern.compile(string2);
            }
            try {
                ((AspectBundle)object2).aspectSystem = (AspectSystem)Class.forName(string3).newInstance();
                ((AspectBundle)object2).aspectSystem.init(genericClassLoader, properties);
                genericClassLoader.addClassFinder((ClassFinder)new AspectSystemClassFinder(((AspectBundle)object2).aspectSystem));
                return object2;
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.WARNING, "Could not create AspectSystem: " + string3, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "Could not access AspectSystem: " + string3, illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.WARNING, "Could not find AspectSystem: " + string3, classNotFoundException);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Could not initialize aspect subsystem", iOException);
        }
        return null;
    }

    private static String addToRegex(String string, String string2) {
        if (string == null) {
            return string2;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 == null ? stringArray[i] : string2 + "|" + stringArray[i];
        }
        return string2;
    }

    public static InputStream getSourceAsStream(String string, GenericClassLoader genericClassLoader) throws IOException {
        Source source = genericClassLoader.getClassFinder().getSource(string);
        if (source != null) {
            return source.getInputStream();
        }
        ClassLoader classLoader = genericClassLoader.getParent();
        if (classLoader instanceof GenericClassLoader) {
            GenericClassLoader genericClassLoader2 = (GenericClassLoader)classLoader;
            return AspectClassPreProcessor.getSourceAsStream(string, genericClassLoader2);
        }
        if (classLoader != null) {
            URL uRL = classLoader.getResource(string);
            return uRL == null ? null : uRL.openStream();
        }
        return null;
    }

    public static void main(String[] stringArray) throws ZipException, IOException {
        Object object;
        Object object2;
        Object object3;
        Getopt2 getopt2 = new Getopt2();
        getopt2.addOption("src", "jar or classes directory file", "This is the jar file of classes to process");
        getopt2.addOption("outjar", "jar file", "This is the output of the jar needed to modify the src jar");
        getopt2.addOption("aspects", "jar file", "These are the aspects you want to apply");
        getopt2.grok(stringArray);
        if (!(getopt2.hasOption("src") && getopt2.hasOption("outjar") && getopt2.hasOption("aspects"))) {
            getopt2.usageAndExit("Apply");
        }
        String string = getopt2.getOption("src");
        String string2 = getopt2.getOption("outjar");
        String string3 = getopt2.getOption("aspects");
        ClasspathClassLoader classpathClassLoader = new ClasspathClassLoader(string3, new ClassLoader(){

            public Class findClass(String string) throws ClassNotFoundException {
                return super.findClass(string);
            }
        });
        AspectBundle aspectBundle = AspectClassPreProcessor.createAspectSystem((GenericClassLoader)classpathClassLoader);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
        VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(string));
        Object object4 = virtualJarFile.entries();
        while (object4.hasNext()) {
            int n;
            ZipEntry zipEntry = (ZipEntry)object4.next();
            String string4 = zipEntry.getName();
            if (!string4.endsWith(".class")) continue;
            object3 = string4.substring(0, string4.length() - 6);
            object3 = ((String)object3).replace('/', '.');
            if (aspectBundle.aspectIncludePattern != null && !aspectBundle.aspectIncludePattern.matcher((CharSequence)object3).find() || aspectBundle.aspectExcludePattern != null && aspectBundle.aspectExcludePattern.matcher((CharSequence)object3).find()) continue;
            object2 = virtualJarFile.getInputStream(zipEntry);
            object = new ByteArrayOutputStream();
            while ((n = ((InputStream)object2).read()) != -1) {
                ((ByteArrayOutputStream)object).write(n);
            }
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            byte[] byArray2 = aspectBundle.aspectSystem.weaveClass((String)object3, byArray);
            if (byArray2 == null || byArray == byArray2) continue;
            ZipEntry zipEntry2 = new ZipEntry(string4);
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.write(byArray2);
            zipOutputStream.closeEntry();
        }
        object4 = aspectBundle.aspectSystem.getAllSources();
        for (String string4 : object4.keySet()) {
            object3 = (byte[])object4.get(string4);
            object2 = string4.replace('.', '/') + ".class";
            object = new ZipEntry((String)object2);
            zipOutputStream.putNextEntry((ZipEntry)object);
            zipOutputStream.write((byte[])object3);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.finish();
        zipOutputStream.close();
    }

    private static class AspectBundle {
        AspectSystem aspectSystem;
        Pattern aspectIncludePattern;
        Pattern aspectExcludePattern;

        private AspectBundle() {
        }
    }
}

