/*
 * Decompiled with CFR 0.152.
 */
package weblogic.aspects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import weblogic.aspects.AspectClassPreProcessor;
import weblogic.aspects.AspectSystem;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.JarClassFinder;

public class AspectJ
implements AspectSystem {
    private static final int BUFFER_SIZE = 8192;
    private BcelWorld world;
    private BcelWeaver weaver;
    private boolean aspects;
    private WeakReference gcl;
    private Properties properties;
    private String classPath;
    private static final Logger logger = AspectClassPreProcessor.logger;
    private Map classBytes = new HashMap();

    public void init(GenericClassLoader genericClassLoader, Properties properties) {
        logger.info("Initializing: " + properties);
        this.gcl = new WeakReference<GenericClassLoader>(genericClassLoader);
        this.classPath = genericClassLoader.getClassPath();
        this.properties = properties;
        String[] stringArray = genericClassLoader.getClassPath().split(File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        MessageHandler messageHandler = new MessageHandler();
        messageHandler.ignore(IMessage.INFO);
        this.world = new BcelWorld(arrayList, (IMessageHandler)messageHandler);
        this.weaver = new BcelWeaver(this.world);
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            this.addAspectJar(genericClassLoader, string, string2);
        }
    }

    private void addAspectJar(GenericClassLoader genericClassLoader, String string, String string2) {
        try {
            InputStream inputStream = AspectClassPreProcessor.getSourceAsStream(string2, genericClassLoader);
            if (inputStream == null) {
                logger.info("Configured aspects " + string + " not found as " + string2);
                return;
            }
            File file = File.createTempFile("aspects", ".jar");
            AspectJ.streamToFile(inputStream, file);
            this.weaver.addLibraryJarFile(file);
            genericClassLoader.addClassFinderFirst((ClassFinder)new JarClassFinder(file));
            logger.info("Aspects configured from " + string2);
            this.aspects = true;
            this.weaver.prepareForWeave();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Failed to copy aspect jar", iOException);
        }
    }

    private static void streamToFile(InputStream inputStream, File file) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)fileOutputStream).close();
        inputStream.close();
    }

    public byte[] weaveClass(String string, byte[] byArray) throws IOException {
        byte[] byArray2 = byArray;
        LazyClassGen lazyClassGen = null;
        if (this.aspects) {
            Object object;
            try {
                try {
                    UnwovenClassFile unwovenClassFile = new UnwovenClassFile(string, byArray);
                    this.weaver.addClassFile(unwovenClassFile);
                    String string2 = unwovenClassFile.getClassName();
                    object = this.world.resolve(string2);
                    BcelObjectType bcelObjectType = BcelWorld.getBcelObjectType((ResolvedTypeX)object);
                    bcelObjectType.resetState();
                    this.weaver.weave(object);
                    lazyClassGen = this.weaver.weaveWithoutDump(unwovenClassFile, bcelObjectType);
                }
                catch (ClassCastException classCastException) {
                    String string3;
                    GenericClassLoader genericClassLoader = (GenericClassLoader)this.gcl.get();
                    if (genericClassLoader != null && !(string3 = genericClassLoader.getClassPath()).equals(this.classPath)) {
                        this.init(genericClassLoader, this.properties);
                        return this.weaveClass(string, byArray);
                    }
                    throw classCastException;
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.WARNING, "Failed to weave: " + string, runtimeException);
            }
            if (lazyClassGen == null) {
                byArray2 = byArray;
            } else {
                logger.info("Weaved: " + string);
                byArray2 = lazyClassGen.getJavaClass().getBytes();
                for (String string2 : lazyClassGen.getChildClasses()) {
                    object = string + "$" + ((UnwovenClassFile.ChildClass)string2).name;
                    this.classBytes.put(object, ((UnwovenClassFile.ChildClass)string2).bytes);
                    logger.info("Added: " + (String)object);
                }
            }
        }
        return byArray2;
    }

    public Map getAllSources() {
        return this.classBytes;
    }
}

