/*
 * Decompiled with CFR 0.152.
 */
package weblogic.aspects;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.aspects.AspectSystem;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.EmptyEnumerator;

public class AspectSystemClassFinder
implements ClassFinder {
    private AspectSystem system;

    public AspectSystemClassFinder(AspectSystem aspectSystem) {
        this.system = aspectSystem;
    }

    public Source getSource(String string) {
        return null;
    }

    public Enumeration getSources(String string) {
        Vector vector = new Vector(0);
        return vector.elements();
    }

    public Source getClassSource(String string) {
        byte[] byArray = (byte[])this.system.getAllSources().get(string);
        if (byArray == null) {
            return null;
        }
        return new AspectSystemSource(byArray);
    }

    public String getClassPath() {
        return "";
    }

    public ClassFinder getManifestFinder() {
        return null;
    }

    public Enumeration entries() {
        return EmptyEnumerator.EMPTY;
    }

    public void close() {
    }

    private static class AspectSystemSource
    implements Source {
        private byte[] bytes;
        private long lastModified = System.currentTimeMillis();

        public AspectSystemSource(byte[] byArray) {
            this.bytes = byArray;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        public URL getURL() {
            return null;
        }

        public URL getCodeSourceURL() {
            return null;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public long length() {
            return this.bytes.length;
        }
    }
}

