/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import weblogic.auddi.soap.SOAPTransport;
import weblogic.auddi.soap.SOAPWrapperException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.response.Result;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.webservice.core.soap.MessageFactoryImpl;
import weblogic.webservice.core.soap.SOAPConnectionFactoryImpl;
import weblogic.webservice.core.soap.SOAPFactoryImpl;

class SAAJTransport
extends SOAPTransport {
    private static SOAPConnectionFactory s_soapConnectionFactory;
    private static MessageFactory s_messageFactory;
    private static SOAPFactory s_soapFactory;

    public SAAJTransport(String string, String string2, String string3) {
        Logger.trace("+weblogic.auddi.soap.SAAJTransport.CTOR");
        Logger.trace("messageFactoryClass : " + string);
        Logger.trace("connectionFactoryClass : " + string2);
        Logger.trace("soapFactoryClass : " + string3);
        if (s_messageFactory == null) {
            if (string != null && string.length() != 0) {
                try {
                    s_messageFactory = (MessageFactory)Class.forName(string).newInstance();
                    s_soapConnectionFactory = (SOAPConnectionFactory)Class.forName(string2).newInstance();
                    s_soapFactory = (SOAPFactory)Class.forName(string3).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    if (s_messageFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.notfound", string));
                    }
                    if (s_soapConnectionFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.notfound", string2));
                    }
                    throw new RuntimeException(UDDIMessages.get("error.class.notfound", string3));
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    if (s_messageFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string));
                    }
                    if (s_soapConnectionFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string2));
                    }
                    throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string3));
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    if (s_messageFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.access", string));
                    }
                    if (s_soapConnectionFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.access", string2));
                    }
                    throw new RuntimeException(UDDIMessages.get("error.class.access", string3));
                }
            } else {
                s_messageFactory = new MessageFactoryImpl();
                s_soapConnectionFactory = new SOAPConnectionFactoryImpl();
                s_soapFactory = new SOAPFactoryImpl();
            }
            if (s_envelopeURI == null) {
                try {
                    SOAPMessage sOAPMessage = s_messageFactory.createMessage();
                    SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
                    SOAPBody sOAPBody = sOAPEnvelope.getBody();
                    Name name = sOAPEnvelope.getElementName();
                    Name name2 = sOAPBody.getElementName();
                    s_envelopeURI = name.getURI();
                    s_envelopePrefix = name.getPrefix();
                    s_envelopeQualifiedName = name.getQualifiedName();
                    s_bodyURI = name2.getURI();
                    s_bodyQualifiedName = name2.getQualifiedName();
                }
                catch (SOAPException sOAPException) {
                    sOAPException.printStackTrace();
                    if (s_messageFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string));
                    }
                    if (s_soapConnectionFactory == null) {
                        throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string2));
                    }
                    throw new RuntimeException(UDDIMessages.get("error.class.instantiation", string3));
                }
            }
        }
        Logger.trace("SAAJTransport.MessageFactoryClass: " + s_messageFactory.getClass().getName());
        Logger.trace("SAAJTransport.SOAPConnectionFactoryClass: " + s_soapConnectionFactory.getClass().getName());
        Logger.trace("SAAJTransport.SOAPFactoryClass: " + s_soapFactory.getClass().getName());
        Logger.trace("-weblogic.auddi.soap.SAAJTransport.CTOR");
    }

    public String createFaultMessage(String string, String string2, Result result) {
        Logger.trace("+SAAJTransport.createFaultMessage()");
        try {
            int n;
            SOAPMessage sOAPMessage = s_messageFactory.createMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            SOAPFault sOAPFault = sOAPBody.addFault();
            SOAPFactory sOAPFactory = SOAPFactory.newInstance();
            if (string2 == null) {
                string2 = "";
            }
            string = string == null ? s_envelopePrefix + ":Client" : ((n = string.lastIndexOf(58)) != -1 ? s_envelopePrefix + string.substring(n) : s_envelopePrefix + ":" + string);
            sOAPFault.setFaultCode(string);
            sOAPFault.setFaultString(string2);
            Detail detail = sOAPFault.addDetail();
            Name name = sOAPPart.getEnvelope().createName("dispositionReport");
            DetailEntry detailEntry = detail.addDetailEntry(name);
            detailEntry.addNamespaceDeclaration("", "urn:uddi-org:api_v2");
            detailEntry.addAttribute(sOAPFactory.createName("generic"), "2.0");
            detailEntry.addAttribute(sOAPFactory.createName("operator"), PropertyManager.getRuntimeProperty("auddi.siteoperator"));
            SOAPElement sOAPElement = detailEntry.addChildElement("result");
            sOAPElement.addAttribute(sOAPFactory.createName("errno"), new Integer(result.getErrno()).toString());
            SOAPElement sOAPElement2 = sOAPElement.addChildElement("errInfo");
            sOAPElement2.addAttribute(sOAPFactory.createName("errCode"), result.getErrCode());
            sOAPElement2.addTextNode(result.getErrMsg());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            Logger.trace("-SAAJTransport.createFaultMessage()");
            return byteArrayOutputStream.toString();
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
            throw new RuntimeException(UDDIMessages.get("error.operation.failed", "createFaultMessage"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(UDDIMessages.get("error.operation.failed", "createFaultMessage"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendSOAPRequest(Element element, URL uRL, String string, int n) throws SOAPWrapperException {
        SOAPConnection sOAPConnection = null;
        try {
            Logger.trace("+SAAJTransport.sendSOAPRequest(org.w3c.dom.Element)");
            if (element == null) {
                Logger.trace("-SAAJTransport.sendSOAPRequest(org.w3c.dom.Element)");
                throw new IllegalArgumentException("Parameter request is null");
            }
            if (uRL == null) {
                Logger.trace("-SAAJTransport.sendSOAPRequest(org.w3c.dom.Element)");
                throw new IllegalArgumentException("Parameter url is null");
            }
            sOAPConnection = s_soapConnectionFactory.createConnection();
            SOAPMessage sOAPMessage = s_messageFactory.createMessage();
            sOAPMessage.getSOAPPart().setContent((Source)new DOMSource(element.getOwnerDocument()));
            SOAPMessage sOAPMessage2 = sOAPConnection.call(sOAPMessage, (Object)uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                sOAPMessage2.writeTo((OutputStream)byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new SOAPWrapperException(iOException);
            }
            String string2 = byteArrayOutputStream.toString();
            if (string2.indexOf("Fault>") != -1 || string2.indexOf("fault>") != -1) {
                string2 = this.fixSOAP(string2);
            }
            if (!string2.trim().startsWith("<?xml")) {
                string2 = "<?xml version='1.0' encoding='UTF-8'?>" + string2;
            }
            String string3 = string2;
            return string3;
        }
        catch (SOAPException sOAPException) {
            throw new SOAPWrapperException((Exception)((Object)sOAPException));
        }
        finally {
            try {
                sOAPConnection.close();
            }
            catch (SOAPException sOAPException) {
                Logger.debug("Exception while trying to close connection. Will be ignored:");
                Logger.debug(sOAPException);
            }
            finally {
                Logger.trace("-SAAJTransport.sendSOAPRequest(org.w3c.dom.Element)");
            }
        }
    }
}

