/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.soap;

import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.auddi.soap.SOAPWrapperException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.uddi.response.Result;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.ParserFactory;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLParser;
import weblogic.auddi.xml.XMLUtil;

abstract class SOAPTransport {
    protected static final String FAULT_CODE_CLIENT = ":Client";
    protected static String s_envelopeURI;
    protected static String s_bodyURI;
    protected static String s_envelopeQualifiedName;
    protected static String s_bodyQualifiedName;
    protected static String s_envelopePrefix;
    private static final String SAMPLE_XML = "<TempXml/>";
    private static String s_soapPrefix;
    private static String s_soapSuffix;

    SOAPTransport() {
    }

    public abstract String createFaultMessage(String var1, String var2, Result var3);

    public abstract String sendSOAPRequest(Element var1, URL var2, String var3, int var4) throws SOAPWrapperException;

    private String makeSOAPStringByParsing(String string) {
        Logger.trace("+SOAPTransport.makeSOAPStringByParsing");
        try {
            Element element = new ParserFactory().createDOMParser().parseRequest(string).getDocumentElement();
            Element element2 = this.makeSOAPElement(element);
            element2.setAttribute("xmlns:" + s_envelopePrefix, s_envelopeURI);
            String string2 = XMLUtil.nodeToString(element2);
            Logger.trace("-SOAPTransport.makeSOAPStringByParsing");
            return string2;
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            Logger.trace("-SOAPTransport.makeSOAPStringByParsing");
            return null;
        }
    }

    public String makeSOAPString(String string) {
        String string2;
        Logger.trace("+SOAPTransport.makeSOAPString");
        if (s_soapPrefix == null || s_soapSuffix == null) {
            string2 = this.makeSOAPStringByParsing(SAMPLE_XML);
            int n = string2.indexOf(SAMPLE_XML);
            s_soapPrefix = string2.substring(0, n);
            s_soapSuffix = string2.substring(n + SAMPLE_XML.length());
        }
        string2 = s_soapPrefix + string + s_soapSuffix;
        Logger.trace("-SOAPTransport.makeSOAPString");
        return string2;
    }

    protected Element makeSOAPElement(Element element) {
        Logger.trace("+SOAPTransport.makeSOAPElement");
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(s_envelopeURI, s_envelopeQualifiedName);
        Element element3 = document.createElementNS(s_bodyURI, s_bodyQualifiedName);
        element3.appendChild(element);
        element2.appendChild(element3);
        Logger.trace("-SOAPTransport.makeSOAPElement");
        return element2;
    }

    protected Element getSOAPContent(Element element) throws SOAPWrapperException {
        Logger.trace("+SOAPTransport.getSOAPContent");
        NodeList nodeList = element.getElementsByTagNameNS("*", "Body");
        if (nodeList.getLength() == 0) {
            XMLUtil.printXML(element);
            throw new SOAPWrapperException(UDDIMessages.get("error.soap.base"));
        }
        nodeList = nodeList.item(0).getChildNodes();
        Node node = null;
        Element element2 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            break;
        }
        Logger.trace("-SOAPTransport.getSOAPContent");
        return element2;
    }

    protected String fixSOAP(String string) {
        Document document;
        Object object;
        Logger.trace("+SOAPTransport.fixSOAP(String soap)");
        try {
            object = new ParserFactory().createDOMParserNS();
            document = ((XMLParser)object).parseRequest(string);
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            Logger.trace("-SOAPTransport.fixSOAP(String soap)");
            return string;
        }
        this.fixPrefix(document);
        object = document.getElementsByTagNameNS("*", "Fault");
        if (object.getLength() == 0) {
            return string;
        }
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = object.item(i);
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList.item(j);
                if (node2.getNodeType() != 1 || node2.getPrefix() == null || node2.getPrefix().length() == 0) continue;
                node2.setPrefix("");
            }
        }
        String string2 = XMLUtil.nodeToString(document.getDocumentElement());
        Logger.trace("-SOAPTransport.fixSOAP(String soap)");
        return string2;
    }

    private void fixPrefix(Document document) {
        int n;
        NodeList nodeList = document.getElementsByTagNameNS("*", "Envelope");
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            Element element = (Element)nodeList.item(n);
            String string = element.getPrefix();
            if (string != null && string.length() != 0) {
                return;
            }
            element.setPrefix("SOAP-ENV");
            element.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        nodeList = document.getElementsByTagNameNS("*", "Body");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            nodeList.item(n).setPrefix("SOAP-ENV");
        }
        nodeList = document.getElementsByTagNameNS("*", "Fault");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            nodeList.item(n).setPrefix("SOAP-ENV");
        }
    }

    static {
        s_soapPrefix = null;
        s_soapSuffix = null;
    }
}

